/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Cause;
import hudson.model.ItemGroup;
import hudson.model.Run;
import java.util.Date;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public final class BranchEventCause
extends Cause {
    private transient MultiBranchProject<?, ?> multiBranchProject;
    private final long timestamp;
    @NonNull
    private final String origin;

    BranchEventCause(SCMEvent<?> event) {
        this.timestamp = event.getTimestamp();
        this.origin = event.getOrigin();
    }

    public void onAddedTo(Run build) {
        ItemGroup g = build.getParent().getParent();
        if (g instanceof MultiBranchProject) {
            this.multiBranchProject = (MultiBranchProject)g;
        }
    }

    public Date getTimestamp() {
        return new Date(this.timestamp);
    }

    @NonNull
    public String getOrigin() {
        return this.origin;
    }

    public void onLoad(Run<?, ?> build) {
        this.onAddedTo(build);
    }

    @CheckForNull
    public MultiBranchProject<?, ?> getMultiBranchProject() {
        return this.multiBranchProject;
    }

    @Restricted(value={DoNotUse.class})
    @CheckForNull
    public String getIndexingUrl() {
        return this.multiBranchProject != null ? this.multiBranchProject.getIndexing().getUrl() : null;
    }

    public String getShortDescription() {
        return "Branch event";
    }
}

