/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.model.TopLevelItem;
import hudson.model.listeners.ItemListener;
import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.Timeout;
import jenkins.model.Jenkins;
import jenkins.slaves.WorkspaceLocator;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension(ordinal=-100.0)
@Restricted(value={NoExternalUse.class})
public class WorkspaceLocatorImpl
extends WorkspaceLocator {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceLocatorImpl.class.getName());
    static final int PATH_MAX_DEFAULT = 80;
    static int PATH_MAX = Integer.getInteger(WorkspaceLocatorImpl.class.getName() + ".PATH_MAX", 80);

    public FilePath locate(TopLevelItem item, Node node) {
        if (PATH_MAX == 0) {
            return null;
        }
        if (!(item.getParent() instanceof MultiBranchProject)) {
            return null;
        }
        String minimized = WorkspaceLocatorImpl.minimize(item.getFullName());
        if (node instanceof Jenkins) {
            String workspaceDir = ((Jenkins)node).getRawWorkspaceDir();
            if (!workspaceDir.contains("ITEM_FULL")) {
                LOGGER.log(Level.WARNING, "JENKINS-34564 path sanitization ineffective when using legacy Workspace Root Directory \u2018{0}\u2019; switch to $'{'JENKINS_HOME'}'/workspace/$'{'ITEM_FULLNAME'}' as in JENKINS-8446 / JENKINS-21942", workspaceDir);
            }
            return new FilePath(new File(WorkspaceLocatorImpl.expandVariablesForDirectory(workspaceDir, minimized, item.getRootDir().getPath())));
        }
        if (node instanceof Slave) {
            FilePath root = ((Slave)node).getWorkspaceRoot();
            return root != null ? root.child(minimized) : null;
        }
        return null;
    }

    static String expandVariablesForDirectory(String base, String itemFullName, String itemRootDir) {
        return Util.replaceMacro((String)base, (Map)ImmutableMap.of((Object)"JENKINS_HOME", (Object)Jenkins.getActiveInstance().getRootDir().getPath(), (Object)"ITEM_ROOTDIR", (Object)itemRootDir, (Object)"ITEM_FULLNAME", (Object)itemFullName, (Object)"ITEM_FULL_NAME", (Object)itemFullName.replace(':', '$')));
    }

    private static String uniqueSuffix(String name) {
        byte[] sha256;
        try {
            sha256 = MessageDigest.getInstance("SHA-256").digest(name.getBytes(Charsets.UTF_16LE));
        }
        catch (NoSuchAlgorithmException x) {
            throw new AssertionError("https://docs.oracle.com/javase/7/docs/technotes/guides/security/StandardNames.html#MessageDigest", x);
        }
        return new Base32(0).encodeToString(sha256).replaceFirst("=+$", "");
    }

    static String minimize(String name) {
        String mnemonic = name.replaceAll("(%[0-9A-F]{2}|[^a-zA-Z0-9-_.])+", "_");
        int maxSuffix = 53;
        int maxMnemonic = Math.max(PATH_MAX - maxSuffix, 1);
        if (maxSuffix + maxMnemonic > PATH_MAX) {
            LOGGER.log(Level.WARNING, "WorkspaceLocatorImpl.PATH_MAX is small enough that workspace path collisions are more likely to occur");
            int minSuffix = 11;
            maxMnemonic = Math.max((PATH_MAX - 11) / 2, 1);
            maxSuffix = Math.max(PATH_MAX - maxMnemonic, 11);
        }
        String result = StringUtils.right((String)mnemonic, (int)maxMnemonic) + "-" + WorkspaceLocatorImpl.uniqueSuffix(name).substring(0, --maxSuffix);
        return result;
    }

    @Extension
    public static class Deleter
    extends ItemListener {
        private static int runningTasks;

        public void onDeleted(Item item) {
            if (!(item instanceof TopLevelItem)) {
                return;
            }
            TopLevelItem tli = (TopLevelItem)item;
            Jenkins jenkins = Jenkins.getActiveInstance();
            FilePath masterLoc = new WorkspaceLocatorImpl().locate(tli, (Node)jenkins);
            if (masterLoc != null) {
                Computer.threadPoolForRemoting.submit(new CleanupTask(masterLoc, "master"));
                for (Node node : jenkins.getNodes()) {
                    FilePath slaveLoc = new WorkspaceLocatorImpl().locate(tli, node);
                    if (slaveLoc == null) continue;
                    Computer.threadPoolForRemoting.submit(new CleanupTask(slaveLoc, node.getNodeName()));
                }
            }
        }

        @VisibleForTesting
        static synchronized void waitForTasksToFinish() throws InterruptedException {
            while (runningTasks > 0) {
                Deleter.class.wait();
            }
        }

        private static synchronized void taskStarted() {
            ++runningTasks;
        }

        private static synchronized void taskFinished() {
            --runningTasks;
            Deleter.class.notifyAll();
        }

        private static class CleanupTask
        implements Runnable {
            @NonNull
            private final FilePath loc;
            @NonNull
            private final String nodeName;

            CleanupTask(FilePath loc, String nodeName) {
                this.loc = loc;
                this.nodeName = nodeName;
                Deleter.taskStarted();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                List dirs;
                Throwable throwable;
                Timeout timeout;
                String base;
                block23: {
                    String oldName;
                    Thread t;
                    block24: {
                        block25: {
                            base = this.loc.getName();
                            FilePath parent = this.loc.getParent();
                            if (parent == null) {
                                return;
                            }
                            t = Thread.currentThread();
                            oldName = t.getName();
                            t.setName(oldName + ": deleting workspace in " + this.loc + " on " + this.nodeName);
                            timeout = Timeout.limit(5L, TimeUnit.MINUTES);
                            throwable = null;
                            dirs = parent.listDirectories();
                            if (dirs != null) break block23;
                            if (timeout == null) break block24;
                            if (throwable == null) break block25;
                            try {
                                timeout.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break block24;
                        }
                        timeout.close();
                    }
                    t.setName(oldName);
                    Deleter.taskFinished();
                    return;
                }
                try {
                    try {
                        Iterator iterator = dirs.iterator();
                        while (iterator.hasNext()) {
                            FilePath child = (FilePath)iterator.next();
                            if (!child.getName().startsWith(base)) continue;
                            LOGGER.log(Level.INFO, "deleting obsolete workspace {0} on {1}", new Object[]{child, this.nodeName});
                            child.deleteRecursive();
                        }
                        return;
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throw throwable4;
                    }
                    finally {
                        if (timeout != null) {
                            if (throwable != null) {
                                try {
                                    timeout.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                timeout.close();
                            }
                        }
                    }
                }
                catch (IOException | InterruptedException x) {
                    LOGGER.log(Level.WARNING, "could not clean up workspace directory " + this.loc + " on " + this.nodeName, x);
                    return;
                }
            }
        }
    }
}

