/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import antlr.ANTLRException;
import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.PeriodicFolderTrigger;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.triggers.Trigger;
import hudson.util.DescribableList;
import hudson.util.PersistedList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import javax.servlet.ServletException;
import jenkins.branch.BranchProperty;
import jenkins.branch.BranchSource;
import jenkins.branch.DefaultBranchPropertyStrategy;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactory;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.branch.OrganizationFolderEmptyView;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.SCMSourceOwner;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@Restricted(value={NoExternalUse.class})
public final class OrganizationFolder
extends ComputedFolder<MultiBranchProject<?, ?>>
implements SCMSourceOwner,
MultiBranchProjectFactory.SCMSourceOwnerHack {
    private final DescribableList<SCMNavigator, SCMNavigatorDescriptor> navigators = new DescribableList((Saveable)this);
    private final DescribableList<MultiBranchProjectFactory, MultiBranchProjectFactoryDescriptor> projectFactories = new DescribableList((Saveable)this);
    private transient Map<SCMSource, ThreadLocal<SCMSourceCriteria>> criteriaBySource = new WeakHashMap<SCMSource, ThreadLocal<SCMSourceCriteria>>();

    public OrganizationFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    public void onCreatedFromScratch() {
        super.onCreatedFromScratch();
        for (MultiBranchProjectFactoryDescriptor d : ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class)) {
            MultiBranchProjectFactory f = d.newInstance();
            if (f == null) continue;
            this.projectFactories.add((Object)f);
        }
        try {
            this.addTrigger((Trigger)new PeriodicFolderTrigger("1d"));
        }
        catch (ANTLRException x) {
            throw new IllegalStateException(x);
        }
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.navigators.setOwner((Saveable)this);
        this.projectFactories.setOwner((Saveable)this);
        this.criteriaBySource = new WeakHashMap<SCMSource, ThreadLocal<SCMSourceCriteria>>();
    }

    public DescribableList<SCMNavigator, SCMNavigatorDescriptor> getNavigators() {
        return this.navigators;
    }

    public DescribableList<MultiBranchProjectFactory, MultiBranchProjectFactoryDescriptor> getProjectFactories() {
        return this.projectFactories;
    }

    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        this.navigators.rebuildHetero(req, req.getSubmittedForm(), (Collection)ExtensionList.lookup(SCMNavigatorDescriptor.class), "navigators");
        this.projectFactories.rebuildHetero(req, req.getSubmittedForm(), (Collection)ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class), "projectFactories");
    }

    protected void computeChildren(final ChildObserver<MultiBranchProject<?, ?>> observer, final TaskListener listener) throws IOException, InterruptedException {
        for (SCMNavigator navigator : this.navigators) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            listener.getLogger().format("Consulting %s%n", navigator.getDescriptor().getDisplayName());
            navigator.visitSources(new SCMSourceObserver(){

                public SCMSourceOwner getContext() {
                    return OrganizationFolder.this;
                }

                public TaskListener getListener() {
                    return listener;
                }

                public SCMSourceObserver.ProjectObserver observe(final String projectName) {
                    return new SCMSourceObserver.ProjectObserver(){
                        List<SCMSource> sources = new ArrayList<SCMSource>();

                        public void addSource(SCMSource source) {
                            this.sources.add(source);
                            source.setOwner((SCMSourceOwner)OrganizationFolder.this);
                        }

                        private List<BranchSource> createBranchSources() {
                            if (this.sources == null) {
                                throw new IllegalStateException();
                            }
                            ArrayList<BranchSource> branchSources = new ArrayList<BranchSource>();
                            for (SCMSource source : this.sources) {
                                branchSources.add(new BranchSource(source, new DefaultBranchPropertyStrategy(new BranchProperty[0])));
                            }
                            this.sources = null;
                            return branchSources;
                        }

                        public void addAttribute(String key, Object value) throws IllegalArgumentException, ClassCastException {
                            throw new IllegalArgumentException();
                        }

                        public void complete() throws IllegalStateException, InterruptedException {
                            MultiBranchProject existing = (MultiBranchProject)observer.shouldUpdate(projectName);
                            if (existing != null) {
                                PersistedList<BranchSource> sourcesList = existing.getSourcesList();
                                sourcesList.clear();
                                sourcesList.addAll(this.createBranchSources());
                                existing.scheduleBuild();
                                return;
                            }
                            if (!observer.mayCreate(projectName)) {
                                listener.getLogger().println("Ignoring duplicate child " + projectName);
                                return;
                            }
                            for (MultiBranchProjectFactory factory : OrganizationFolder.this.projectFactories) {
                                MultiBranchProject<?, ?> project;
                                try {
                                    project = factory.createProject((ItemGroup<?>)OrganizationFolder.this, projectName, (List<? extends SCMSource>)this.sources, Collections.<String, Object>emptyMap(), listener);
                                }
                                catch (InterruptedException x) {
                                    throw x;
                                }
                                catch (Exception x) {
                                    x.printStackTrace(listener.error("Failed to create a subproject " + projectName));
                                    continue;
                                }
                                if (project == null) continue;
                                project.getSourcesList().addAll(this.createBranchSources());
                                try {
                                    project.addTrigger((Trigger)new PeriodicFolderTrigger("1d"));
                                }
                                catch (ANTLRException x) {
                                    throw new IllegalStateException(x);
                                }
                                observer.created(project);
                                project.scheduleBuild();
                                break;
                            }
                        }
                    };
                }

                public void addAttribute(String key, Object value) throws IllegalArgumentException, ClassCastException {
                    throw new IllegalArgumentException();
                }
            });
        }
    }

    public List<SCMSource> getSCMSources() {
        HashSet<SCMSource> result = new HashSet<SCMSource>();
        for (MultiBranchProject child : this.getItems()) {
            result.addAll(child.getSCMSources());
        }
        return new ArrayList<SCMSource>(result);
    }

    public SCMSource getSCMSource(String sourceId) {
        return null;
    }

    public void onSCMSourceUpdated(SCMSource source) {
    }

    public SCMSourceCriteria getSCMSourceCriteria(SCMSource source) {
        ThreadLocal<SCMSourceCriteria> criteriaTL = this.criteriaBySource.get(source);
        return criteriaTL != null ? criteriaTL.get() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withSCMSourceCriteria(SCMSource source, SCMSourceCriteria criteria, Callable<T> body) throws Exception {
        ThreadLocal<Object> criteriaTL;
        Map<SCMSource, ThreadLocal<SCMSourceCriteria>> map = this.criteriaBySource;
        synchronized (map) {
            criteriaTL = this.criteriaBySource.get(source);
            if (criteriaTL == null) {
                criteriaTL = new ThreadLocal();
                this.criteriaBySource.put(source, criteriaTL);
            }
        }
        SCMSourceCriteria old = (SCMSourceCriteria)criteriaTL.get();
        try {
            criteriaTL.set(criteria);
            T t = body.call();
            return t;
        }
        finally {
            criteriaTL.set(old);
        }
    }

    public View getPrimaryView() {
        if (this.getItems().isEmpty()) {
            return new OrganizationFolderEmptyView((ViewGroup)this);
        }
        return super.getPrimaryView();
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractFolderDescriptor {
        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new OrganizationFolder(parent, name);
        }
    }
}

