/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.ExtensionPoint;
import hudson.model.AbstractDescribableImpl;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;

public abstract class MultiBranchProjectFactory
extends AbstractDescribableImpl<MultiBranchProjectFactory>
implements ExtensionPoint {
    @CheckForNull
    public abstract MultiBranchProject<?, ?> createProject(@Nonnull ItemGroup<?> var1, @Nonnull String var2, @Nonnull List<? extends SCMSource> var3, @Nonnull Map<String, Object> var4, @Nonnull TaskListener var5) throws IOException, InterruptedException;

    public MultiBranchProjectFactoryDescriptor getDescriptor() {
        return (MultiBranchProjectFactoryDescriptor)super.getDescriptor();
    }

    public static abstract class BySCMSourceCriteria
    extends MultiBranchProjectFactory {
        @Nonnull
        protected abstract SCMSourceCriteria getSCMSourceCriteria(@Nonnull SCMSource var1);

        @Nonnull
        protected abstract MultiBranchProject<?, ?> doCreateProject(@Nonnull ItemGroup<?> var1, @Nonnull String var2, @Nonnull Map<String, Object> var3);

        @Override
        public final MultiBranchProject<?, ?> createProject(ItemGroup<?> parent, String name, List<? extends SCMSource> scmSources, @Nonnull Map<String, Object> attributes, final TaskListener listener) throws IOException, InterruptedException {
            for (final SCMSource sCMSource : scmSources) {
                boolean empty;
                SCMSourceOwner owner = sCMSource.getOwner();
                if (!(owner instanceof SCMSourceOwnerHack)) {
                    throw new IOException("cannot influence criteria on " + owner);
                }
                try {
                    empty = ((SCMSourceOwnerHack)owner).withSCMSourceCriteria(sCMSource, this.getSCMSourceCriteria(sCMSource), new Callable<Boolean>(){

                        @Override
                        public Boolean call() throws Exception {
                            return sCMSource.fetch(listener).isEmpty();
                        }
                    });
                }
                catch (IOException x) {
                    throw x;
                }
                catch (InterruptedException x) {
                    throw x;
                }
                catch (RuntimeException x) {
                    throw x;
                }
                catch (Exception x) {
                    throw new AssertionError((Object)x);
                }
                if (empty) continue;
                return this.doCreateProject(parent, name, attributes);
            }
            return null;
        }
    }

    static interface SCMSourceOwnerHack
    extends SCMSourceOwner {
        public <T> T withSCMSourceCriteria(@Nonnull SCMSource var1, @Nonnull SCMSourceCriteria var2, @Nonnull Callable<T> var3) throws Exception;
    }
}

