/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigatorDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CustomOrganizationFolderDescriptor
extends TopLevelItemDescriptor {
    public final SCMNavigatorDescriptor delegate;

    CustomOrganizationFolderDescriptor(SCMNavigatorDescriptor delegate) {
        super(TopLevelItem.class);
        this.delegate = delegate;
    }

    public String getId() {
        return OrganizationFolder.class.getName() + "." + this.delegate.getId();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public TopLevelItem newInstance(ItemGroup parent, String name) {
        OrganizationFolder p = new OrganizationFolder(parent, name);
        p.getNavigators().add((Object)this.delegate.newInstance(name));
        return p;
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void addSpecificDescriptors() {
        if (ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class).isEmpty()) {
            return;
        }
        TopLevelItemDescriptor.all().size();
        for (SCMNavigatorDescriptor d : ExtensionList.lookup(SCMNavigatorDescriptor.class)) {
            if (d.newInstance((String)null) == null) continue;
            TopLevelItemDescriptor.all().add((Object)new CustomOrganizationFolderDescriptor(d));
        }
    }

    @Extension
    public static class HideGeneric
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            return !(descriptor instanceof OrganizationFolder.DescriptorImpl) || !(context instanceof View) && !(context instanceof ViewGroup);
        }
    }
}

