/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.List;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchPropertyStrategyDescriptor;
import jenkins.branch.MultiBranchProject;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchSource
extends AbstractDescribableImpl<BranchSource> {
    private final SCMSource source;
    private final BranchPropertyStrategy strategy;

    @DataBoundConstructor
    public BranchSource(SCMSource source, BranchPropertyStrategy strategy) {
        this.source = source;
        this.strategy = strategy;
    }

    public SCMSource getSource() {
        return this.source;
    }

    public BranchPropertyStrategy getStrategy() {
        return this.strategy;
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<BranchSource> {
        public String getDisplayName() {
            return "Branch source";
        }

        public List<BranchPropertyStrategyDescriptor> propertyStrategyDescriptors(@NonNull MultiBranchProject project, @NonNull SCMSourceDescriptor sourceDescriptor) {
            return BranchPropertyStrategyDescriptor.all(project, sourceDescriptor);
        }
    }
}

