/*
 * Decompiled with CFR 0.152.
 */
package jenkins.bouncycastle.api;

import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.ChannelProperty;
import hudson.remoting.Future;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.security.MasterToSlaveCallable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class InstallBouncyCastleJCAProvider
extends MasterToSlaveCallable<Boolean, Exception> {
    private static final long serialVersionUID = 1L;
    private static final ChannelProperty<Future> BOUNCYCASTLE_REGISTERED = new ChannelProperty(Future.class, "Bouncy Castle Registered");

    private InstallBouncyCastleJCAProvider() {
    }

    @Nonnull
    public Boolean call() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        return Boolean.TRUE;
    }

    public static void on(@Nonnull SlaveComputer c) throws IOException, InterruptedException {
        Channel channel = c.getChannel();
        if (channel == null) {
            throw new IOException("Remote agent is off-line");
        }
        InstallBouncyCastleJCAProvider.on(channel);
    }

    public static void on(@Nonnull Channel channel) throws IOException, InterruptedException {
        Future future = (Future)channel.getProperty(BOUNCYCASTLE_REGISTERED);
        try {
            if (future != null) {
                future.get(1L, TimeUnit.MINUTES);
            } else {
                channel.preloadJar(PEMEncodable.class.getClassLoader(), new Class[]{BouncyCastleProvider.class});
                future = (Future)channel.getProperty(BOUNCYCASTLE_REGISTERED);
                if (future == null) {
                    future = channel.callAsync((Callable)new InstallBouncyCastleJCAProvider());
                    channel.setProperty(BOUNCYCASTLE_REGISTERED, (Object)future);
                }
                future.get(1L, TimeUnit.MINUTES);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (TimeoutException e) {
            throw new IOException("Remote operation timed out", e);
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw new IOException(e);
            }
            if (e.getCause() instanceof SecurityException) {
                throw new SecurityException(e);
            }
            if (e.getCause() instanceof LinkageError) {
                throw new LinkageError("Could not register bouncy castle", e);
            }
            throw new IOException("Could not register bouncy castle", e);
        }
    }
}

