/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.api;

import com.google.gson.Gson;
import java.util.logging.Logger;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.api.BitBucketTeamsResponse;
import org.jenkinsci.plugins.api.BitbucketApiV2;
import org.jenkinsci.plugins.api.BitbucketMissingPermissionException;
import org.jenkinsci.plugins.api.BitbucketTeams;
import org.jenkinsci.plugins.api.BitbucketUser;
import org.scribe.builder.ServiceBuilder;
import org.scribe.model.OAuthRequest;
import org.scribe.model.Response;
import org.scribe.model.Token;
import org.scribe.model.Verb;
import org.scribe.model.Verifier;
import org.scribe.oauth.OAuthService;

public class BitbucketApiService {
    private static final Logger LOGGER = Logger.getLogger(BitbucketApiService.class.getName());
    private static final String API2_ENDPOINT = "https://api.bitbucket.org/2.0/";
    private OAuthService service;

    public BitbucketApiService(String apiKey, String apiSecret) {
        this(apiKey, apiSecret, null);
    }

    public BitbucketApiService(String apiKey, String apiSecret, String callback) {
        ServiceBuilder builder = new ServiceBuilder().provider(BitbucketApiV2.class).apiKey(apiKey).apiSecret(apiSecret);
        if (StringUtils.isNotBlank((String)callback)) {
            builder.callback(callback);
        }
        this.service = builder.build();
    }

    public Token createRquestToken() {
        return this.service.getRequestToken();
    }

    public String createAuthorizationCodeURL(Token requestToken) {
        return this.service.getAuthorizationUrl(requestToken);
    }

    public Token getTokenByAuthorizationCode(String code, Token requestToken) {
        Verifier v = new Verifier(code);
        return this.service.getAccessToken(requestToken, v);
    }

    public BitbucketUser getUserByToken(Token accessToken) {
        BitbucketUser bitbucketUser = this.getBitbucketUser(accessToken);
        bitbucketUser.addAuthority("authenticated");
        this.findAndAddUserTeamAccess(accessToken, bitbucketUser, "admin");
        this.findAndAddUserTeamAccess(accessToken, bitbucketUser, "contributor");
        this.findAndAddUserTeamAccess(accessToken, bitbucketUser, "member");
        return bitbucketUser;
    }

    private BitbucketUser getBitbucketUser(Token accessToken) {
        BitbucketUser bitbucketUser = this.getBitbucketUserV2(accessToken);
        if (bitbucketUser != null) {
            return bitbucketUser;
        }
        throw new BitbucketMissingPermissionException("Your Bitbucket credentials lack one required privilege scopes: [Account Read]");
    }

    private BitbucketUser getBitbucketUserV2(Token accessToken) {
        OAuthRequest request = new OAuthRequest(Verb.GET, "https://api.bitbucket.org/2.0/user");
        this.service.signRequest(accessToken, request);
        Response response = request.send();
        String json = response.getBody();
        Gson gson = new Gson();
        BitbucketUser bitbucketUser = (BitbucketUser)gson.fromJson(json, BitbucketUser.class);
        if (bitbucketUser == null || StringUtils.isEmpty((String)bitbucketUser.username)) {
            return null;
        }
        return bitbucketUser;
    }

    private void findAndAddUserTeamAccess(Token accessToken, BitbucketUser bitbucketUser, String role) {
        Gson gson = new Gson();
        String url = "https://api.bitbucket.org/2.0/teams/?role=" + role;
        try {
            BitBucketTeamsResponse bitBucketTeamsResponse;
            do {
                OAuthRequest request1 = new OAuthRequest(Verb.GET, url);
                this.service.signRequest(accessToken, request1);
                Response response1 = request1.send();
                String json1 = response1.getBody();
                LOGGER.finest("Response from bitbucket api " + url);
                LOGGER.finest(json1);
                bitBucketTeamsResponse = (BitBucketTeamsResponse)gson.fromJson(json1, BitBucketTeamsResponse.class);
                if (!CollectionUtils.isNotEmpty(bitBucketTeamsResponse.getTeamsList())) continue;
                for (BitbucketTeams team : bitBucketTeamsResponse.getTeamsList()) {
                    String authority = team.getUsername() + "::" + role;
                    bitbucketUser.addAuthority(authority);
                }
            } while ((url = bitBucketTeamsResponse.getNext()) != null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public UserDetails getUserByUsername(String username) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

