/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.security.GroupDetails;
import hudson.security.SecurityRealm;
import hudson.security.UserMayOrMayNotExistException;
import hudson.util.Secret;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import jenkins.model.Jenkins;
import jenkins.security.SecurityListener;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationManager;
import org.acegisecurity.BadCredentialsException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.BitbucketAuthenticationToken;
import org.jenkinsci.plugins.api.BitbucketApiService;
import org.jenkinsci.plugins.api.BitbucketGroup;
import org.jenkinsci.plugins.api.BitbucketUser;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Header;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.StaplerRequest;
import org.scribe.model.Token;
import org.springframework.dao.DataAccessException;

public class BitbucketSecurityRealm
extends SecurityRealm {
    private static final String STATE_ATTRIBUTE = BitbucketSecurityRealm.class.getName() + ".state";
    private static final String REFERER_ATTRIBUTE = BitbucketSecurityRealm.class.getName() + ".referer";
    private static final Logger LOGGER = Logger.getLogger(BitbucketSecurityRealm.class.getName());
    private String clientID;
    @Deprecated
    private String clientSecret;
    private Secret secretClientSecret;

    @DataBoundConstructor
    public BitbucketSecurityRealm(String clientID, String clientSecret, Secret secretClientSecret) {
        this.clientID = Util.fixEmptyAndTrim((String)clientID);
        this.clientSecret = Util.fixEmptyAndTrim((String)clientSecret);
        this.secretClientSecret = secretClientSecret;
    }

    public BitbucketSecurityRealm() {
        LOGGER.log(Level.FINE, "BitbucketSecurityRealm()");
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    @Deprecated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Deprecated
    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Secret getSecretClientSecret() {
        if (StringUtils.isNotEmpty((String)this.clientSecret)) {
            return Secret.fromString((String)this.clientSecret);
        }
        return this.secretClientSecret;
    }

    public void setSecretClientSecret(Secret secretClientSecret) {
        this.secretClientSecret = secretClientSecret;
    }

    public HttpResponse doCommenceLogin(StaplerRequest request, @Header(value="Referer") String referer) throws IOException {
        String state = RandomStringUtils.random((int)64, (String)"abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-._~");
        request.getSession().setAttribute(STATE_ATTRIBUTE, (Object)state);
        request.getSession().setAttribute(REFERER_ATTRIBUTE, (Object)referer);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            throw new RuntimeException("Jenkins is not started yet.");
        }
        String rootUrl = jenkins.getRootUrl();
        if (StringUtils.endsWith((String)rootUrl, (String)"/")) {
            rootUrl = StringUtils.left((String)rootUrl, (int)(StringUtils.length((String)rootUrl) - 1));
        }
        String callback = rootUrl + "/securityRealm/finishLogin";
        BitbucketApiService bitbucketApiService = new BitbucketApiService(this.clientID, this.getSecretClientSecret().getPlainText(), callback);
        return new HttpRedirect(bitbucketApiService.createAuthorizationCodeURL(null, state));
    }

    public HttpResponse doFinishLogin(StaplerRequest request) throws IOException {
        String code = request.getParameter("code");
        String state = request.getParameter("state");
        if (StringUtils.isBlank((String)code)) {
            LOGGER.log(Level.SEVERE, "doFinishLogin() code = null");
            return HttpResponses.redirectToContextRoot();
        }
        if (state == null || !StringUtils.equals((String)state, (String)this.getSessionAttribute(request, STATE_ATTRIBUTE))) {
            LOGGER.log(Level.SEVERE, "doFinishLogin() invalid state parameter");
            return HttpResponses.redirectToContextRoot();
        }
        String referer = this.getSessionAttribute(request, REFERER_ATTRIBUTE);
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        request.getSession(true);
        String rawClientSecret = this.getSecretClientSecret().getPlainText();
        Token accessToken = new BitbucketApiService(this.clientID, rawClientSecret).getTokenByAuthorizationCode(code, null);
        if (!accessToken.isEmpty()) {
            BitbucketUser userDetails;
            BitbucketAuthenticationToken auth = new BitbucketAuthenticationToken(accessToken, this.clientID, rawClientSecret);
            SecurityContextHolder.getContext().setAuthentication((Authentication)auth);
            User u = User.current();
            if (u != null) {
                u.setFullName(auth.getName());
            }
            if ((userDetails = auth.getBitbucketUser()) != null) {
                SecurityListener.fireAuthenticated((UserDetails)userDetails);
            }
        } else {
            LOGGER.log(Level.SEVERE, "doFinishLogin() accessToken = null");
        }
        if (referer != null) {
            return HttpResponses.redirectTo((String)referer);
        }
        return HttpResponses.redirectToContextRoot();
    }

    public SecurityRealm.SecurityComponents createSecurityComponents() {
        return new SecurityRealm.SecurityComponents(new AuthenticationManager(){

            public Authentication authenticate(Authentication authentication) throws AuthenticationException {
                if (authentication instanceof BitbucketAuthenticationToken) {
                    return authentication;
                }
                throw new BadCredentialsException("Unexpected authentication type: " + authentication);
            }
        }, new UserDetailsService(){

            public UserDetails loadUserByUsername(String username) throws UserMayOrMayNotExistException, DataAccessException {
                throw new UserMayOrMayNotExistException("Cannot verify users in this context");
            }
        });
    }

    public UserDetails loadUserByUsername(String username) {
        UserDetails result = null;
        Authentication token = SecurityContextHolder.getContext().getAuthentication();
        if (token == null) {
            throw new UsernameNotFoundException("BitbucketAuthenticationToken = null, no known user: " + username);
        }
        if (!(token instanceof BitbucketAuthenticationToken)) {
            throw new UserMayOrMayNotExistException("Unexpected authentication type: " + token);
        }
        result = new BitbucketApiService(this.clientID, this.getSecretClientSecret().getPlainText()).getUserByUsername(username);
        if (result == null) {
            throw new UsernameNotFoundException("User does not exist for login: " + username);
        }
        return result;
    }

    public GroupDetails loadGroupByGroupname(String groupName) {
        if (groupName.contains("::")) {
            return new BitbucketGroup(groupName);
        }
        throw new UsernameNotFoundException("Group does not exist:" + groupName);
    }

    public boolean allowsSignup() {
        return false;
    }

    public String getLoginUrl() {
        return "securityRealm/commenceLogin";
    }

    private String getSessionAttribute(StaplerRequest request, String attributeName) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return null;
        }
        return (String)session.getAttribute(attributeName);
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecurityRealm> {
        public String getHelpFile() {
            return "/plugin/bitbucket-oauth/help/help-security-realm.html";
        }

        public String getDisplayName() {
            return "Bitbucket OAuth Plugin";
        }

        public DescriptorImpl() {
        }

        public DescriptorImpl(Class<? extends SecurityRealm> clazz) {
            super(clazz);
        }
    }

    public static final class ConverterImpl
    implements Converter {
        public boolean canConvert(Class type) {
            return type == BitbucketSecurityRealm.class;
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            BitbucketSecurityRealm realm = (BitbucketSecurityRealm)((Object)source);
            writer.startNode("clientID");
            writer.setValue(realm.getClientID());
            writer.endNode();
            writer.startNode("secretClientSecret");
            writer.setValue(realm.getSecretClientSecret().getEncryptedValue());
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            String node = reader.getNodeName();
            reader.moveDown();
            BitbucketSecurityRealm realm = new BitbucketSecurityRealm();
            node = reader.getNodeName();
            String value = reader.getValue();
            this.setValue(realm, node, value);
            reader.moveUp();
            reader.moveDown();
            node = reader.getNodeName();
            value = reader.getValue();
            this.setValue(realm, node, value);
            reader.moveUp();
            if (reader.hasMoreChildren()) {
                reader.moveDown();
                node = reader.getNodeName();
                value = reader.getValue();
                this.setValue(realm, node, value);
                reader.moveUp();
            }
            return realm;
        }

        private void setValue(BitbucketSecurityRealm realm, String node, String value) {
            if (node.equalsIgnoreCase("clientid")) {
                realm.setClientID(value);
            } else if (node.equalsIgnoreCase("clientsecret")) {
                realm.setClientSecret(value);
            } else if (node.equalsIgnoreCase("secretclientsecret")) {
                realm.setSecretClientSecret(Secret.fromString((String)value));
            } else {
                throw new ConversionException("invalid node value = " + node);
            }
        }
    }
}

