/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PercentageAverageThreshold
extends Threshold {
    private final Double percentage;
    private Double average;

    @DataBoundConstructor
    public PercentageAverageThreshold(String testGroup, String testName, Double percentage) {
        super(testGroup, testName, Threshold.ThresholdTypes.tt_percentageAverage);
        this.percentage = percentage;
        this.average = null;
    }

    public PercentageAverageThreshold(Double percentage) throws ValidationException {
        super(Threshold.ThresholdTypes.tt_percentageAverage);
        if (percentage == null) {
            throw new ValidationException(Messages.PercentageAverageThreshold_MissingPercentageValue());
        }
        this.percentage = percentage;
        this.average = null;
    }

    @Override
    public boolean evaluate(List<? extends Run<?, ?>> builds) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException {
        return true;
    }

    @Override
    public boolean isValid(int value) throws NullPointerException, ValidationException {
        if (this.average == null) {
            return true;
        }
        double calculatedPercentage = Math.abs(((double)value - this.average) / this.average) * 100.0;
        if (this.percentage != null && calculatedPercentage > this.percentage) {
            throw new ValidationException(Messages.PercentageAverageThreshold_OutOfPercentageFromAverage(Integer.toString(value), Double.toString(this.percentage), Double.toString(this.average)));
        }
        return true;
    }

    @Override
    public boolean isValid(double value) throws NullPointerException, ValidationException {
        if (this.average == null) {
            return true;
        }
        double calculatedPercentage = Math.abs((value - this.average) / this.average) * 100.0;
        if (this.percentage != null && calculatedPercentage > this.percentage) {
            throw new ValidationException(Messages.PercentageAverageThreshold_OutOfPercentageFromAverage(Double.toString(value), Double.toString(this.percentage), Double.toString(this.average)));
        }
        return true;
    }

    @Override
    public void setAverageValue(Double average) {
        this.average = average;
    }

    public Double getPercentage() {
        return this.percentage;
    }

    public Double getAverageValue() {
        return this.average;
    }

    @Extension
    public static class DescriptorImpl
    extends ThresholdDescriptor {
        public String getDisplayName() {
            return Messages.PercentageAverageThreshold_PercentageFromAverage();
        }

        public FormValidation doCheckPercentage(@QueryParameter Double percentage) {
            if (percentage == null) {
                return FormValidation.error((String)Messages.PercentageAverageThreshold_PercentageCannotBeEmpty());
            }
            if (100.0 < percentage || percentage < 0.0) {
                return FormValidation.error((String)Messages.PercentageAverageThreshold_PercentageBetween0And100());
            }
            return FormValidation.ok();
        }
    }
}

