/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.thresholds;

import hudson.AbortException;
import hudson.Extension;
import hudson.model.Run;
import hudson.util.FormValidation;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.List;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.thresholds.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class DeltaThreshold
extends Threshold {
    private final Double delta;
    private Double previous;

    @DataBoundConstructor
    public DeltaThreshold(String testGroup, String testName, Double delta) {
        super(testGroup, testName, Threshold.ThresholdTypes.tt_delta);
        this.delta = delta;
        this.previous = null;
    }

    public DeltaThreshold(Double delta) throws ValidationException {
        super(Threshold.ThresholdTypes.tt_delta);
        if (delta == null) {
            throw new ValidationException(Messages.DeltaThreshold_MissingDeltaValue());
        }
        this.delta = delta;
        this.previous = null;
    }

    @Override
    public boolean evaluate(List<? extends Run<?, ?>> builds) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, AbortException, ParseException {
        return true;
    }

    @Override
    public boolean isValid(int value) throws NullPointerException, ValidationException {
        if (this.previous == null) {
            return true;
        }
        double calculatedDelta = Math.sqrt(((double)value - this.previous) * ((double)value - this.previous));
        if (this.delta != null && calculatedDelta > this.delta) {
            throw new ValidationException(Messages.DeltaThreshold_ValueOutOfDeltaFromPrevious(Integer.toString(value), Double.toString(this.delta), Double.toString(this.previous)));
        }
        return true;
    }

    @Override
    public boolean isValid(double value) throws NullPointerException, ValidationException {
        if (this.previous == null) {
            return true;
        }
        double calculatedDelta = Math.sqrt((value - this.previous) * (value - this.previous));
        if (this.delta != null && calculatedDelta > this.delta) {
            throw new ValidationException(Messages.DeltaThreshold_ValueOutOfDeltaFromPrevious(Double.toString(value), Double.toString(this.delta), Double.toString(this.previous)));
        }
        return true;
    }

    @Override
    public void setPreviousValue(Double previousValue) {
        this.previous = previousValue;
    }

    public Double getDelta() {
        return this.delta;
    }

    public Double getPrevious() {
        return this.previous;
    }

    @Extension
    public static class DescriptorImpl
    extends ThresholdDescriptor {
        public String getDisplayName() {
            return Messages.DeltaThreshold_DeltaFromLastBuild();
        }

        public FormValidation doCheckDelta(@QueryParameter Double delta) {
            if (delta == null) {
                return FormValidation.error((String)Messages.DeltaThreshold_DeltaCannotBeEmpty());
            }
            if (delta < 0.0) {
                return FormValidation.error((String)Messages.DeltaThreshold_DeltaAboveOrEqualTo0());
            }
            return FormValidation.ok();
        }
    }
}

