/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.InvalidClassException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.benchmark.condensed.BooleanCondensed;
import org.jenkinsci.plugins.benchmark.condensed.DoubleCondensed;
import org.jenkinsci.plugins.benchmark.condensed.IntegerCondensed;
import org.jenkinsci.plugins.benchmark.condensed.StringCondensed;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.Messages;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestProperty;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;
import org.jenkinsci.plugins.benchmark.utilities.TextToHTML;

public class TestValue
extends TestGroup {
    public static final String FAILED_STATE_COLOR = "#F37A7A";
    public static final String PASSED_STATE_COLOR = "#92D050";
    protected final ValueType type;
    protected String group;
    protected String unit;
    protected final ConcurrentHashMap<Integer, TestProperty> properties = new ConcurrentHashMap();

    TestValue(TestGroup parent, String group, String name, String description, String unit, ValueType type) {
        super(parent, name, description, TestGroup.ClassType.ct_result);
        this.type = type;
        this.unit = unit;
        this.group = group == null ? this.getParent().getFileSubGroupFullName() : group;
    }

    TestValue(TestGroup parent, String group, String name, String description, String unit, ValueType type, TestGroup.ClassType ctype) {
        super(parent, name, description, ctype);
        this.type = type;
        this.unit = unit;
        this.group = group == null ? this.getParent().getFileSubGroupFullName() : group;
    }

    public static void convertCondensedResultJsonObject(JsonObject object, TestGroup rootGroup, Map<Integer, TestGroup> fileList, Map<Integer, TestValue> entityList, ContentDetected detected) {
        Integer _hash = null;
        String _name = null;
        String _group = null;
        String _description = null;
        String _unit = null;
        Double _previous = null;
        Double _maximum = null;
        Double _minimum = null;
        Double _average = null;
        Double _std_deviation = null;
        Integer _passed = null;
        Integer _failed = null;
        TestGroup _file = rootGroup;
        ValueType _type = ValueType.rt_unknown;
        block38: for (Map.Entry enObject : object.entrySet()) {
            String key;
            switch (key = ((String)enObject.getKey()).toLowerCase()) {
                case "hash": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _hash = primitive.getAsInt();
                    break;
                }
                case "type": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block38;
                    _type = TestValue.checkType(primitive.getAsString());
                    break;
                }
                case "name": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block38;
                    _name = primitive.getAsString();
                    break;
                }
                case "group": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block38;
                    _group = primitive.getAsString();
                    break;
                }
                case "description": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block38;
                    _description = primitive.getAsString();
                    break;
                }
                case "unit": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block38;
                    _unit = primitive.getAsString();
                    detected.setUnitsDetected(true);
                    break;
                }
                case "passed": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _passed = primitive.getAsInt();
                    break;
                }
                case "failed": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _failed = primitive.getAsInt();
                    break;
                }
                case "file": {
                    TestGroup file;
                    JsonElement inObject = (JsonElement)enObject.getValue();
                    if (!inObject.isJsonPrimitive()) break;
                    JsonPrimitive primitive = inObject.getAsJsonPrimitive();
                    if (!primitive.isNumber() || (file = fileList.get(primitive.getAsInt())) == null) continue block38;
                    _file = file;
                    break;
                }
                case "previous": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _previous = primitive.getAsDouble();
                    break;
                }
                case "minimum": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _minimum = primitive.getAsDouble();
                    break;
                }
                case "maximum": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _maximum = primitive.getAsDouble();
                    break;
                }
                case "average": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _average = primitive.getAsDouble();
                    break;
                }
                case "std_deviation": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block38;
                    _std_deviation = primitive.getAsDouble();
                    break;
                }
            }
        }
        switch (_type) {
            case rt_integer: {
                IntegerCondensed int_result = new IntegerCondensed(_file, _group, _name, _description, _unit, _previous.intValue(), _minimum.intValue(), _maximum.intValue(), _average, _std_deviation, _passed, _failed);
                entityList.put(_hash, int_result);
                detected.setNumeralDetected(true);
                break;
            }
            case rt_double: {
                DoubleCondensed dbl_result = new DoubleCondensed(_file, _group, _name, _description, _unit, _previous, _minimum, _maximum, _average, _std_deviation, _passed, _failed);
                entityList.put(_hash, dbl_result);
                detected.setNumeralDetected(true);
                break;
            }
            case rt_string: {
                StringCondensed str_result = new StringCondensed(_file, _group, _name, _description, _unit, _passed, _failed);
                entityList.put(_hash, str_result);
                break;
            }
            case rt_boolean: {
                BooleanCondensed bool_result = new BooleanCondensed(_file, _group, _name, _description, _unit, _passed, _failed);
                entityList.put(_hash, bool_result);
                break;
            }
        }
        if (_group != null) {
            detected.setGroupDetected(true);
        }
    }

    public static void convertCondensedParameterJsonObject(JsonObject object, TestGroup rootGroup, Map<Integer, TestValue> entityList, ContentDetected detected) {
        Integer _hash = null;
        String _name = null;
        String _group = null;
        String _description = null;
        String _unit = null;
        TestGroup _file = rootGroup;
        ValueType _type = ValueType.rt_unknown;
        block22: for (Map.Entry enObject : object.entrySet()) {
            String key;
            switch (key = ((String)enObject.getKey()).toLowerCase()) {
                case "hash": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block22;
                    _hash = primitive.getAsInt();
                    break;
                }
                case "type": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block22;
                    _type = TestValue.checkType(primitive.getAsString());
                    break;
                }
                case "name": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block22;
                    _name = primitive.getAsString();
                    break;
                }
                case "group": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block22;
                    _group = primitive.getAsString();
                    break;
                }
                case "description": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block22;
                    _description = primitive.getAsString();
                    break;
                }
                case "unit": {
                    JsonElement value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive()) break;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (!primitive.isString()) continue block22;
                    _unit = primitive.getAsString();
                    break;
                }
            }
        }
        switch (_type) {
            case rt_integer: {
                IntegerValue int_result = new IntegerValue(_file, _group, _name, _description, _unit);
                entityList.put(_hash, int_result);
                break;
            }
            case rt_double: {
                DoubleValue dbl_result = new DoubleValue(_file, _group, _name, _description, _unit);
                entityList.put(_hash, dbl_result);
                break;
            }
            case rt_string: {
                StringValue str_result = new StringValue(_file, _group, _name, _description, _unit);
                entityList.put(_hash, str_result);
                break;
            }
            case rt_boolean: {
                BooleanValue bool_result = new BooleanValue(_file, _group, _name, _description, _unit);
                entityList.put(_hash, bool_result);
                break;
            }
        }
    }

    public static void convertResultJsonObject(int build, JsonObject object, TestGroup rootGroup, Map<Integer, TestGroup> fileList, Map<Integer, TestValue> entityList, Map<Integer, TestValue> paramList) {
        Integer _hash = null;
        Integer _id = null;
        Boolean _failedState = null;
        JsonPrimitive _value = null;
        HashMap<String, String> _messages = new HashMap<String, String>();
        ArrayList<TestValue> _parameters = new ArrayList<TestValue>();
        block44: for (Map.Entry enObject : object.entrySet()) {
            String key;
            switch (key = ((String)enObject.getKey()).toLowerCase()) {
                case "hash": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block44;
                    _hash = primitive.getAsInt();
                    break;
                }
                case "value": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    _value = enElement.getAsJsonPrimitive();
                    break;
                }
                case "id": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isNumber()) continue block44;
                    _id = primitive.getAsInt();
                    break;
                }
                case "failedstate": {
                    JsonElement enElement = (JsonElement)enObject.getValue();
                    if (!enElement.isJsonPrimitive()) break;
                    JsonPrimitive primitive = enElement.getAsJsonPrimitive();
                    if (!primitive.isBoolean()) continue block44;
                    _failedState = primitive.getAsBoolean();
                    break;
                }
                case "messages": {
                    JsonElement inElement = (JsonElement)enObject.getValue();
                    if (!inElement.isJsonArray()) break;
                    JsonArray inArray = inElement.getAsJsonArray();
                    for (JsonElement enArray : inArray) {
                        if (!enArray.isJsonObject()) continue;
                        String _title = "";
                        String _message = "";
                        JsonObject aObject = enArray.getAsJsonObject();
                        for (Map.Entry enSObject : aObject.entrySet()) {
                            JsonPrimitive primitive;
                            JsonElement enElement;
                            if (((String)enSObject.getKey()).equalsIgnoreCase("title")) {
                                enElement = (JsonElement)enSObject.getValue();
                                if (!enElement.isJsonPrimitive() || !(primitive = enElement.getAsJsonPrimitive()).isString()) continue;
                                _title = primitive.getAsString();
                                continue;
                            }
                            if (!((String)enSObject.getKey()).equalsIgnoreCase("message") || !(enElement = (JsonElement)enSObject.getValue()).isJsonPrimitive() || !(primitive = enElement.getAsJsonPrimitive()).isString()) continue;
                            _message = primitive.getAsString();
                        }
                        _messages.put(_title, _message);
                    }
                    continue block44;
                }
                case "parameters": {
                    JsonElement inElement = (JsonElement)enObject.getValue();
                    if (!inElement.isJsonArray()) break;
                    JsonArray inArray = inElement.getAsJsonArray();
                    for (JsonElement enArray : inArray) {
                        Object parameter;
                        JsonPrimitive primitive;
                        if (!enArray.isJsonPrimitive() || !(primitive = enArray.getAsJsonPrimitive()).isNumber() || (parameter = paramList.get(primitive.getAsInt())) == null) continue;
                        _parameters.add((TestValue)parameter);
                    }
                    continue block44;
                }
            }
        }
        TestValue res = entityList.get(_hash);
        if (res == null) {
            String _name = null;
            String _group = null;
            String _description = null;
            String _unit = null;
            ValueType _type = ValueType.rt_unknown;
            TestGroup _file = rootGroup;
            block48: for (Map.Entry enObject : object.entrySet()) {
                String key = ((String)enObject.getKey()).toLowerCase();
                switch (key) {
                    case "name": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block48;
                        _name = primitive.getAsString();
                        break;
                    }
                    case "group": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block48;
                        _group = primitive.getAsString();
                        break;
                    }
                    case "description": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block48;
                        _description = primitive.getAsString();
                        break;
                    }
                    case "unit": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block48;
                        _unit = primitive.getAsString();
                        break;
                    }
                    case "type": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block48;
                        _type = TestValue.checkType(primitive.getAsString());
                        break;
                    }
                    case "file": {
                        TestGroup file;
                        JsonPrimitive primitive;
                        JsonElement inObject = (JsonElement)enObject.getValue();
                        if (!inObject.isJsonPrimitive() || !(primitive = inObject.getAsJsonPrimitive()).isNumber() || (file = fileList.get(primitive.getAsInt())) == null) break;
                        _file = file;
                    }
                }
            }
            switch (_type) {
                case rt_boolean: {
                    BooleanValue bool_value = new BooleanValue(_file, null, _name, _description, _unit);
                    bool_value.setValue(build, _value.getAsBoolean());
                    bool_value.setGroup(_group);
                    entityList.put(_hash, bool_value);
                    if (paramList != null) {
                        _file.addGroup(bool_value);
                    }
                    res = bool_value;
                    break;
                }
                case rt_string: {
                    StringValue str_value = new StringValue(_file, null, _name, _description, _unit);
                    str_value.setValue(build, _value.getAsString());
                    str_value.setGroup(_group);
                    entityList.put(_hash, str_value);
                    if (paramList != null) {
                        _file.addGroup(str_value);
                    }
                    res = str_value;
                    break;
                }
                case rt_double: {
                    DoubleValue dbl_value = new DoubleValue(_file, null, _name, _description, _unit);
                    dbl_value.setValue(build, _value.getAsDouble());
                    dbl_value.setGroup(_group);
                    entityList.put(_hash, dbl_value);
                    if (paramList != null) {
                        _file.addGroup(dbl_value);
                    }
                    res = dbl_value;
                    break;
                }
                case rt_integer: {
                    IntegerValue int_value = new IntegerValue(_file, null, _name, _description, _unit);
                    int_value.setValue(build, _value.getAsInt());
                    int_value.setGroup(_group);
                    entityList.put(_hash, int_value);
                    if (paramList != null) {
                        _file.addGroup(int_value);
                    }
                    res = int_value;
                    break;
                }
            }
        }
        if (res != null) {
            if (_value != null) {
                ValueType type = res.getType();
                switch (type) {
                    case rt_boolean: {
                        if (!_value.isBoolean()) break;
                        TestValue value = (BooleanValue)res;
                        ((BooleanValue)value).setValue(build, _value.getAsBoolean());
                        break;
                    }
                    case rt_double: {
                        if (!_value.isNumber()) break;
                        TestValue value = (DoubleValue)res;
                        ((DoubleValue)value).setValue(build, _value.getAsDouble());
                        break;
                    }
                    case rt_integer: {
                        if (!_value.isNumber()) break;
                        TestValue value = (IntegerValue)res;
                        ((IntegerValue)value).setValue(build, _value.getAsInt());
                        break;
                    }
                    case rt_string: {
                        if (!_value.isString()) break;
                        TestValue value = (StringValue)res;
                        ((StringValue)value).setValue(build, _value.getAsString());
                        break;
                    }
                }
            }
            if (_failedState != null) {
                res.setFailedState(build, _failedState);
            }
            if (_id != null) {
                res.setId(build, _id);
            }
            if (_messages != null) {
                res.setMessages(build, _messages);
            }
            if (!_parameters.isEmpty()) {
                res.setParameters(build, _parameters);
            }
        }
    }

    public static void convertParameterJsonObject(int build, JsonObject object, TestGroup rootGroup, Map<Integer, TestValue> entityList) {
        Integer _hash = null;
        TestGroup _file = rootGroup;
        JsonPrimitive _value = null;
        for (Map.Entry enObject : object.entrySet()) {
            JsonElement enElement;
            String key = ((String)enObject.getKey()).toLowerCase();
            if (key.equals("hash")) {
                JsonPrimitive primitive;
                enElement = (JsonElement)enObject.getValue();
                if (!enElement.isJsonPrimitive() || !(primitive = enElement.getAsJsonPrimitive()).isNumber()) continue;
                _hash = primitive.getAsInt();
                continue;
            }
            if (!key.equals("value") || !(enElement = (JsonElement)enObject.getValue()).isJsonPrimitive()) continue;
            _value = enElement.getAsJsonPrimitive();
        }
        TestValue res = entityList.get(_hash);
        if (res == null) {
            String _name = null;
            String _group = null;
            String _description = null;
            String _unit = null;
            ValueType _type = ValueType.rt_unknown;
            block27: for (Map.Entry enObject : object.entrySet()) {
                String key;
                switch (key = ((String)enObject.getKey()).toLowerCase()) {
                    case "name": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block27;
                        _name = primitive.getAsString();
                        break;
                    }
                    case "group": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block27;
                        _group = primitive.getAsString();
                        break;
                    }
                    case "description": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block27;
                        _description = primitive.getAsString();
                        break;
                    }
                    case "unit": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block27;
                        _unit = primitive.getAsString();
                        break;
                    }
                    case "type": {
                        JsonElement value = (JsonElement)enObject.getValue();
                        if (!value.isJsonPrimitive()) break;
                        JsonPrimitive primitive = value.getAsJsonPrimitive();
                        if (!primitive.isString()) continue block27;
                        _type = TestValue.checkType(primitive.getAsString());
                        break;
                    }
                }
            }
            switch (_type) {
                case rt_boolean: {
                    BooleanValue bool_value = new BooleanValue(_file, null, _name, _description, _unit);
                    bool_value.setValue(build, _value.getAsBoolean());
                    bool_value.setGroup(_group);
                    entityList.put(_hash, bool_value);
                    res = bool_value;
                    break;
                }
                case rt_string: {
                    StringValue str_value = new StringValue(_file, null, _name, _description, _unit);
                    str_value.setValue(build, _value.getAsString());
                    str_value.setGroup(_group);
                    entityList.put(_hash, str_value);
                    res = str_value;
                    break;
                }
                case rt_double: {
                    DoubleValue dbl_value = new DoubleValue(_file, null, _name, _description, _unit);
                    dbl_value.setValue(build, _value.getAsDouble());
                    dbl_value.setGroup(_group);
                    entityList.put(_hash, dbl_value);
                    res = dbl_value;
                    break;
                }
                case rt_integer: {
                    IntegerValue int_value = new IntegerValue(_file, null, _name, _description, _unit);
                    int_value.setValue(build, _value.getAsInt());
                    int_value.setGroup(_group);
                    entityList.put(_hash, int_value);
                    res = int_value;
                    break;
                }
            }
        }
        if (res != null && _value != null) {
            ValueType type = res.getType();
            switch (type) {
                case rt_boolean: {
                    if (!_value.isBoolean()) break;
                    TestValue value = (BooleanValue)res;
                    ((BooleanValue)value).setValue(build, _value.getAsBoolean());
                    break;
                }
                case rt_double: {
                    if (!_value.isNumber()) break;
                    TestValue value = (DoubleValue)res;
                    ((DoubleValue)value).setValue(build, _value.getAsDouble());
                    break;
                }
                case rt_integer: {
                    if (!_value.isNumber()) break;
                    TestValue value = (IntegerValue)res;
                    ((IntegerValue)value).setValue(build, _value.getAsInt());
                    break;
                }
                case rt_string: {
                    if (!_value.isString()) break;
                    TestValue value = (StringValue)res;
                    ((StringValue)value).setValue(build, _value.getAsString());
                    break;
                }
            }
        }
    }

    public String getHTMLResult(TreeSet<Integer> builds, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        for (int build = builds.last().intValue(); build >= builds.first(); --build) {
            String value = this.getValueAsLocaleString(build, decimalSeparator);
            if (value.isEmpty()) {
                content.append("<td>-</td>");
                continue;
            }
            Boolean state = this.getFailedState(build);
            if (state == null) {
                content.append("<td>");
                content.append(value.toString());
                content.append("</td>");
                continue;
            }
            content.append("<td style=\"background-color:");
            content.append(this.getColor(state));
            content.append(";\">");
            content.append(value.toString());
            content.append("</td>");
        }
        return content.toString();
    }

    @Override
    public JsonObject getJsonObject(int hash) {
        Map<String, String> messages;
        JsonObject object = new JsonObject();
        if (this.getName() != null) {
            object.addProperty("hash", (Number)hash);
        }
        if (this.getId() != null) {
            object.addProperty("id", (Number)this.getId());
        }
        if (this.getFailedState() != null) {
            object.addProperty("failedState", this.getFailedState());
        }
        if ((messages = this.getMessages()) != null && messages.size() > 0) {
            JsonArray arrayMessages = new JsonArray();
            for (Map.Entry<String, String> message : this.getMessages().entrySet()) {
                JsonObject objectMessage = new JsonObject();
                objectMessage.addProperty("title", message.getKey());
                objectMessage.addProperty("message", message.getValue());
                arrayMessages.add((JsonElement)objectMessage);
            }
            object.add("messages", (JsonElement)arrayMessages);
        }
        if (this.ctype == TestGroup.ClassType.ct_result) {
            boolean detParameters = false;
            JsonArray arrayParameters = new JsonArray();
            List<TestGroup> parameters = this.getAllConnectedParameters();
            for (TestGroup parameter : parameters) {
                arrayParameters.add((Number)parameter.getGroupHash());
                detParameters = true;
            }
            if (detParameters) {
                object.add("parameters", (JsonElement)arrayParameters);
            }
        }
        return object;
    }

    public JsonObject getParameterJsonObject(int hash) {
        JsonObject object = new JsonObject();
        object.addProperty("hash", (Number)hash);
        if (this.getFileGroup() != null) {
            object.addProperty("file", (Number)this.getFileGroup().getGroupHash());
        }
        if (this.group != null && !this.group.isEmpty()) {
            object.addProperty("group", this.group);
        }
        object.addProperty("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.addProperty("description", this.description);
        }
        object.addProperty("type", TestValue.outputType(this.type));
        if (this.getUnit() != null && !this.getUnit().isEmpty()) {
            object.addProperty("unit", this.getUnit());
        }
        return object;
    }

    public String getHTMLDetails(Integer build, char decimalSeparator) {
        Map<String, String> messages;
        Integer id;
        Boolean failedState;
        String value;
        StringBuffer content = new StringBuffer();
        if (this.description != null && !this.description.isEmpty()) {
            content.append("<tr><td>");
            content.append(Messages.Description());
            content.append("</td><td>");
            content.append(this.description);
            content.append("</td></tr>");
        }
        if ((value = this.getValueAsLocaleString(build, decimalSeparator)).isEmpty()) {
            content.append("<tr><td>");
            content.append(Messages.Value());
            content.append("</td><td>");
            content.append(Messages.NotApplicableShort());
            content.append("</td></tr>");
        } else {
            content.append("<tr><td>");
            content.append(Messages.Value());
            content.append("</td><td>");
            content.append(value);
            content.append("</td></tr>");
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            content.append("<tr><td>");
            content.append(Messages.Unit());
            content.append("</td><td>");
            content.append(this.unit);
            content.append("</td></tr>");
        }
        if ((failedState = this.getFailedState(build)) != null) {
            if (failedState.booleanValue()) {
                content.append("<tr><td>");
                content.append(Messages.State());
                content.append("</td><td style=\"color:");
                content.append(this.getColor(failedState));
                content.append(";\"><b>");
                content.append(Messages.Failed());
                content.append("</b></td></tr>");
            } else {
                content.append("<tr><td>");
                content.append(Messages.State());
                content.append("</td><td style=\"color:");
                content.append(this.getColor(failedState));
                content.append(";\"><b>");
                content.append(Messages.Passed());
                content.append("</b></td></tr>");
            }
        }
        if ((id = this.getId(build)) != null) {
            content.append("<tr><td>");
            content.append(Messages.AttachedId());
            content.append("</td><td>");
            content.append(id.toString());
            content.append("</td></tr>");
        }
        if ((messages = this.getMessages(build)) != null && messages.size() != 0) {
            for (Map.Entry<String, String> entry : messages.entrySet()) {
                content.append("<tr><td colspan=\"2\">");
                content.append(entry.getKey());
                content.append(":<p>");
                content.append(TextToHTML.toHTML(entry.getValue()));
                content.append("<p></td></tr>");
            }
        }
        return content.toString();
    }

    public String getHTMLResult(Integer key, ContentDetected detected, TreeSet<Integer> builds, List<Integer> listNPassed, List<Integer> listNFailed, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        content.append("<tr><td>");
        if (detected.isFileDetected().booleanValue()) {
            if (this.getParent() == null) {
                content.append("</td><td>");
            } else {
                String name = this.getParent().getName();
                if (name.equalsIgnoreCase("__root__")) {
                    content.append("</td><td>");
                } else {
                    content.append(name);
                    content.append("</td><td>");
                }
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.getGroup() == null) {
                content.append("</td><td>");
            } else {
                content.append(this.getGroup());
                content.append("</td><td>");
            }
        }
        content.append(this.getName());
        content.append("</td><td>");
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit != null && !this.unit.isEmpty()) {
                content.append(this.unit);
                content.append("</td><td>");
            } else {
                content.append("-</td><td>");
            }
        }
        content.append(key.toString());
        int index = 0;
        for (int build = builds.last().intValue(); build >= builds.first(); --build) {
            String value = this.getValueAsLocaleString(build, decimalSeparator);
            if (value.isEmpty()) {
                content.append("</td><td>");
            } else {
                Boolean failedState = this.getFailedState(build);
                if (failedState == null) {
                    content.append("</td><td>");
                    if (!value.equals("__boolean__")) {
                        content.append(value);
                    }
                } else {
                    content.append("</td><td style=\"background-color:");
                    content.append(this.getColor(failedState));
                    content.append("\">");
                    if (!value.equals("__boolean__")) {
                        content.append(value);
                    }
                    if (failedState.booleanValue()) {
                        listNFailed.set(index, listNFailed.get(index) + 1);
                    } else {
                        listNPassed.set(index, listNPassed.get(index) + 1);
                    }
                }
            }
            ++index;
        }
        content.append("</td></tr>");
        return content.toString();
    }

    public String getCSVResult(TreeSet<Integer> builds, ContentDetected detected) {
        StringBuffer content = new StringBuffer();
        if (detected.isFileDetected().booleanValue()) {
            if (this.getParent() == null) {
                content.append(',');
            } else {
                String name = this.getParent().getName();
                if (name.equalsIgnoreCase("__root__")) {
                    content.append(',');
                } else {
                    content.append(name);
                    content.append(',');
                }
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.getGroup() == null) {
                content.append(',');
            } else {
                content.append(this.getGroup());
                content.append(',');
            }
        }
        content.append(this.getName());
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit == null) {
                content.append(",-");
            } else {
                content.append(',');
                content.append(this.unit);
            }
        }
        for (int build = builds.last().intValue(); build >= builds.first(); --build) {
            String value = this.getValueAsString(build);
            if (value == null || value.isEmpty()) {
                content.append(",-");
                continue;
            }
            content.append(',');
            content.append(value);
        }
        return content.toString();
    }

    public String getCSVResultState(Integer key, ContentDetected detected, TreeSet<Integer> builds) {
        StringBuffer content = new StringBuffer();
        if (detected.isFileDetected().booleanValue()) {
            if (this.getParent() == null) {
                content.append(',');
            } else {
                String name = this.getParent().getName();
                if (name.equalsIgnoreCase("__root__")) {
                    content.append(',');
                } else {
                    content.append(name);
                    content.append(',');
                }
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.getGroup() == null) {
                content.append(',');
            } else {
                content.append(this.getGroup());
                content.append(',');
            }
        }
        content.append(this.getName());
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit != null && !this.unit.isEmpty()) {
                content.append(',');
                content.append(this.unit);
            } else {
                content.append(",-");
            }
        }
        for (int build = builds.last().intValue(); build >= builds.first(); --build) {
            Boolean state = this.getFailedState(build);
            if (state == null) {
                content.append(",-");
                continue;
            }
            if (!state.booleanValue()) {
                content.append(',');
                content.append(Messages.Passed());
                continue;
            }
            content.append(',');
            content.append(Messages.Failed());
        }
        return content.toString();
    }

    public String getHTMLParameters(Integer build, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        List<TestValue> parameters = this.getParameters(build);
        if (parameters != null && parameters.size() != 0) {
            Integer i = 1;
            for (TestValue parameter : parameters) {
                content.append(parameter.getHTMLParameter(i, build, decimalSeparator));
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return content.toString();
    }

    public String getHTMLParameter(Integer number, Integer build, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        content.append("<tr><td><b>");
        content.append(Messages.ParameterNumber(number.toString()));
        content.append("</b></td><td></td></tr><tr><td>");
        content.append(Messages.Name());
        content.append("</td><td>");
        content.append(this.getName());
        content.append("</td></tr>");
        if (this.description != null && !this.description.isEmpty()) {
            content.append("<tr><td>");
            content.append(Messages.Description());
            content.append("</td><td>");
            content.append(this.description);
            content.append("</td></tr>");
        }
        content.append("<tr><td>");
        content.append(Messages.Value());
        content.append("</td><td>");
        String value = this.getValueAsLocaleString(build, decimalSeparator);
        if (value.isEmpty()) {
            content.append(Messages.NotApplicableShort());
        } else {
            content.append(value);
        }
        content.append("</td></tr>");
        if (this.unit != null && !this.unit.isEmpty()) {
            content.append("<tr><td>");
            content.append(Messages.Unit());
            content.append("</td><td>");
            content.append(this.unit);
            content.append("</td></tr>");
        }
        return content.toString();
    }

    public String getHTMLCondensed(Integer key, ContentDetected detected, char decimalSeparator) {
        return "";
    }

    public String getHTMLCondensedDetail(ContentDetected detected, char decimalSeparator) {
        return "";
    }

    public String getCSVCondensed(ContentDetected detected) {
        return "";
    }

    public JsonObject getCondensedJsonObject(int build, int hash) {
        return null;
    }

    public Boolean isNumeral() {
        switch (this.type) {
            case rt_integer: 
            case rt_double: {
                return true;
            }
        }
        return false;
    }

    public void checkThresholdStatus(Double previous, Double average) {
    }

    public void setId(Integer id) {
        this.setId(0, id);
    }

    public void setId(int build, Integer id) {
        if (id == null) {
            return;
        }
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.setId(id);
            this.properties.put(build, properties);
        } else {
            properties.setId(id);
        }
    }

    public void setFailedState(Boolean failed) {
        this.setFailedState(0, failed);
    }

    public void setFailedState(int build, Boolean failed) {
        if (failed == null) {
            return;
        }
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.setFailedState(failed);
            this.properties.put(build, properties);
        } else if (this.getFailedState() == null) {
            properties.setFailedState(failed);
        } else if (!this.getFailedState().booleanValue() && failed.booleanValue()) {
            properties.setFailedState(failed);
        }
    }

    public void setMessage(String title, String message) {
        this.setMessage(0, title, message);
    }

    public void setMessage(int build, String title, String message) {
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.addMessage(title, message);
            this.properties.put(build, properties);
        } else {
            properties.addMessage(title, message);
        }
    }

    public void setMessages(Map<String, String> messages) {
        this.setMessages(0, messages);
    }

    public void setMessages(int build, Map<String, String> messages) {
        if (messages == null || messages.size() == 0) {
            return;
        }
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.addMessages(messages);
            this.properties.put(build, properties);
        } else {
            properties.addMessages(messages);
        }
    }

    public void setParameter(TestValue parameter) {
        this.setParameter(0, parameter);
    }

    public void setParameter(int build, TestValue parameter) {
        if (parameter == null) {
            return;
        }
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.addParameter(parameter);
            this.properties.put(build, properties);
        } else {
            properties.addParameter(parameter);
        }
    }

    public void setParameters(List<TestValue> parameters) {
        this.setParameters(0, parameters);
    }

    public void setParameters(int build, List<TestValue> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        TestProperty properties = this.properties.get(build);
        if (properties == null) {
            properties = new TestProperty();
            properties.addParameters(parameters);
            this.properties.put(build, properties);
        } else {
            properties.addParameters(parameters);
        }
    }

    public void setGroup() {
        this.group = this.getParent().getFileSubGroupFullName();
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public ValueType getType() {
        return this.type;
    }

    public String getGroup() {
        return this.group;
    }

    public String getUnit() {
        return this.unit;
    }

    public ConcurrentHashMap<Integer, TestProperty> getProperties() {
        return this.properties;
    }

    public String getValueAsString(int build) {
        return "";
    }

    public String getValueAsLocaleString(int build, char decimalSeparator) {
        return "";
    }

    public Boolean getFailedState() {
        TestProperty property = this.properties.get(0);
        if (property == null) {
            return null;
        }
        return property.getFailedState();
    }

    public Boolean getFailedState(int build) {
        TestProperty property = this.properties.get(build);
        if (property == null) {
            return null;
        }
        return property.getFailedState();
    }

    public Integer getId() {
        TestProperty property = this.properties.get(0);
        if (property == null) {
            return null;
        }
        return property.getId();
    }

    public Integer getId(int build) {
        TestProperty property = this.properties.get(build);
        if (property == null) {
            return null;
        }
        return property.getId();
    }

    public Map<String, String> getMessages() {
        TestProperty property = this.properties.get(0);
        if (property == null) {
            return null;
        }
        return property.getMessages();
    }

    public Map<String, String> getMessages(int build) {
        TestProperty property = this.properties.get(build);
        if (property == null) {
            return null;
        }
        return property.getMessages();
    }

    public List<TestValue> getParameters() {
        TestProperty property = this.properties.get(0);
        if (property == null) {
            return null;
        }
        return property.getParameters();
    }

    public List<TestValue> getParameters(int build) {
        TestProperty property = this.properties.get(build);
        if (property == null) {
            return null;
        }
        return property.getParameters();
    }

    protected String getColor(Boolean failedState) {
        if (failedState.booleanValue()) {
            return FAILED_STATE_COLOR;
        }
        return PASSED_STATE_COLOR;
    }

    public int getNumberOfProperties() {
        return this.properties.size();
    }

    protected static ValueType checkType(String type) {
        switch (type = type.toLowerCase()) {
            case "double": {
                return ValueType.rt_double;
            }
            case "boolean": {
                return ValueType.rt_boolean;
            }
            case "integer": {
                return ValueType.rt_integer;
            }
            case "string": {
                return ValueType.rt_string;
            }
        }
        return ValueType.rt_unknown;
    }

    protected static String outputType(ValueType type) {
        switch (type) {
            case rt_double: {
                return "double";
            }
            case rt_boolean: {
                return "boolean";
            }
            case rt_integer: {
                return "integer";
            }
            case rt_string: {
                return "string";
            }
        }
        return "unknown";
    }

    public JsonArray getDataAsJsonArray(TreeSet<Integer> buildNumbers) throws InvalidClassException {
        throw new InvalidClassException(Messages.TestValue_TestValueNotNumeral());
    }

    public static enum ValueType {
        rt_unknown,
        rt_boolean,
        rt_integer,
        rt_double,
        rt_string;

    }
}

