/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jenkinsci.plugins.benchmark.results.Messages;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;

public class TestGroup {
    protected final TestGroup parent;
    protected final String name;
    protected final String description;
    protected final List<TestGroup> groups;
    protected final List<Threshold> thresholds;
    protected final int groupHash;
    protected ClassType ctype;

    public TestGroup(TestGroup parent, String name) {
        this.parent = parent;
        this.name = name;
        this.description = "";
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = ClassType.ct_group;
    }

    public TestGroup(TestGroup parent, String name, String description) {
        this.parent = parent;
        this.name = name;
        this.description = description == null ? "" : description;
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = ClassType.ct_group;
    }

    public TestGroup(TestGroup parent, String name, ClassType type) {
        this.parent = parent;
        this.name = name;
        this.description = "";
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = type;
    }

    public TestGroup(TestGroup parent, String name, String description, ClassType type) {
        this.parent = parent;
        this.name = name;
        this.description = description == null ? "" : description;
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = type;
    }

    public TestGroup(TestGroup parent, String name, boolean array) {
        this.parent = parent;
        this.name = name;
        this.description = "";
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = ClassType.ct_array;
    }

    public TestGroup(TestGroup parent, String name, String description, boolean array) {
        this.parent = parent;
        this.name = name;
        this.description = description == null ? "" : description;
        this.groups = new ArrayList<TestGroup>();
        this.thresholds = new ArrayList<Threshold>();
        this.groupHash = this.getFullName().hashCode();
        this.ctype = ClassType.ct_array;
    }

    public static void convertCondensedFileJsonObject(JsonObject object, TestGroup rootGroup, Map<Integer, TestGroup> entityList, ContentDetected detected) {
        TestGroup grp;
        Integer _hash = null;
        String _name = null;
        String _description = null;
        for (Object enObject : object.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)enObject.getKey()).equalsIgnoreCase("hash")) continue;
            JsonElement enElement = (JsonElement)enObject.getValue();
            if (!enElement.isJsonPrimitive() || !(primitive = enElement.getAsJsonPrimitive()).isNumber()) break;
            _hash = primitive.getAsInt();
            break;
        }
        if ((grp = entityList.get(_hash)) == null) {
            for (Map.Entry enObject : object.entrySet()) {
                JsonPrimitive primitive;
                JsonElement value;
                if (((String)enObject.getKey()).equalsIgnoreCase("name")) {
                    value = (JsonElement)enObject.getValue();
                    if (!value.isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                    _name = primitive.getAsString();
                    continue;
                }
                if (!((String)enObject.getKey()).equalsIgnoreCase("description") || !(value = (JsonElement)enObject.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                _description = primitive.getAsString();
            }
            TestGroup group = new TestGroup(rootGroup, _name, _description, ClassType.ct_fileGrp);
            rootGroup.addGroup(group);
            entityList.put(_hash, group);
            detected.setFileDetected(true);
        }
    }

    public boolean isParameterGrp() {
        int nParameters = 0;
        for (TestGroup group : this.groups) {
            if (group.getClassType() != ClassType.ct_parameter && group.getClassType() != ClassType.ct_parameterGrp) continue;
            ++nParameters;
        }
        if (nParameters == this.groups.size() && this.thresholds.size() == 0) {
            this.ctype = ClassType.ct_parameterGrp;
            return true;
        }
        return false;
    }

    public boolean isThresholdGrp() {
        if (this.groups.size() == 0 && this.thresholds.size() != 0) {
            this.ctype = ClassType.ct_thresholdGrp;
            return true;
        }
        return false;
    }

    public JsonObject getJsonObject(int hash) {
        JsonObject object = new JsonObject();
        if (this.getName() != null) {
            object.addProperty("hash", (Number)hash);
        }
        if (this.getName() != null) {
            object.addProperty("name", this.getName());
        }
        if (this.getDescription() != null) {
            object.addProperty("description", this.getDescription());
        }
        return object;
    }

    public void addGroup(TestGroup testGroup) {
        this.groups.add(testGroup);
    }

    public TestGroup getGroup(int index) throws ArrayIndexOutOfBoundsException {
        if (index > this.groups.size()) {
            throw new ArrayIndexOutOfBoundsException(Messages.TestGroup_SelectedIndexOutOfBound());
        }
        return this.groups.get(index);
    }

    public int getNumberOfGroups() {
        return this.groups.size();
    }

    public List<TestGroup> getTestGroups() {
        return this.groups;
    }

    public List<TestGroup> getConnectedParameters() {
        ArrayList<TestGroup> list = new ArrayList<TestGroup>();
        for (TestGroup group : this.groups) {
            if (group.getClassType() == ClassType.ct_parameter) {
                list.add(group);
                continue;
            }
            if (group.getClassType() != ClassType.ct_parameterGrp) continue;
            list.addAll(group.getConnectedParameters());
        }
        return list;
    }

    public List<TestGroup> getConnectedParentParameters() {
        ArrayList<TestGroup> list = new ArrayList<TestGroup>();
        if (this.parent != null) {
            list.addAll(this.parent.getAllConnectedParameters());
        }
        return list;
    }

    public List<TestGroup> getAllConnectedParameters() {
        ArrayList<TestGroup> list = new ArrayList<TestGroup>();
        list.addAll(this.getConnectedParameters());
        list.addAll(this.getConnectedParentParameters());
        return list;
    }

    public void addThreshold(Threshold threshold) {
        this.thresholds.add(threshold);
    }

    public Threshold getThreshold(int index) throws ArrayIndexOutOfBoundsException {
        if (index > this.thresholds.size()) {
            throw new ArrayIndexOutOfBoundsException(Messages.TestGroup_SelectedIndexOutOfBound());
        }
        return this.thresholds.get(index);
    }

    public int getNumberOfThresholds() {
        return this.thresholds.size();
    }

    public List<Threshold> getConnectedThresholds() {
        ArrayList<Threshold> list = new ArrayList<Threshold>();
        list.addAll(this.thresholds);
        for (TestGroup group : this.groups) {
            if (group.getClassType() != ClassType.ct_thresholdGrp) continue;
            list.addAll(group.getConnectedThresholds());
        }
        return list;
    }

    public List<Threshold> getConnectedParentThresholds() {
        ArrayList<Threshold> list = new ArrayList<Threshold>();
        if (this.parent != null) {
            list.addAll(this.parent.getConnectedThresholds());
            list.addAll(this.parent.getConnectedParentThresholds());
        }
        return list;
    }

    public List<Threshold> getAllConnectedThresholds() {
        ArrayList<Threshold> list = new ArrayList<Threshold>();
        list.addAll(this.getConnectedThresholds());
        list.addAll(this.getConnectedParentThresholds());
        return list;
    }

    public TestGroup getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public ClassType getClassType() {
        return this.ctype;
    }

    public Integer getGroupHash() {
        return this.groupHash;
    }

    public Integer getFileHash() {
        if (this.getClassType() == ClassType.ct_fileGrp) {
            return this.getGroupHash();
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getFileHash();
    }

    public boolean isArray() {
        return this.ctype == ClassType.ct_array;
    }

    public String getFullName() {
        if (this.name.equalsIgnoreCase("__root__")) {
            return "";
        }
        if (this.name.equalsIgnoreCase("__first__")) {
            if (this.parent != null) {
                return this.parent.getFullName();
            }
            return "";
        }
        String fullName = this.parent.getFullName();
        if (this.getClassType() == ClassType.ct_fileGrp) {
            if (fullName.length() > 0) {
                return fullName + "." + this.description;
            }
            return this.description;
        }
        if (fullName.length() > 0) {
            return fullName + "." + this.name;
        }
        return this.name;
    }

    public String getFileSubGroupFullName() {
        if (this.name.equalsIgnoreCase("__root__") || this.name.equalsIgnoreCase("__first__")) {
            return "";
        }
        if (this.parent.getClassType() == ClassType.ct_fileGrp) {
            return this.name;
        }
        String fullName = this.parent.getFileSubGroupFullName();
        if (fullName.length() > 0) {
            return fullName + "." + this.name;
        }
        return this.name;
    }

    public List<String> getDescriptions() {
        if (this.parent == null) {
            ArrayList<String> descriptions = new ArrayList<String>();
            descriptions.add(this.description);
            return descriptions;
        }
        List<String> list = this.parent.getDescriptions();
        list.add(this.description);
        return list;
    }

    protected TestGroup getFileGroup() {
        if (this.name.equalsIgnoreCase("__root__") || this.name.equalsIgnoreCase("__first__")) {
            return null;
        }
        if (this.parent.getClassType() == ClassType.ct_fileGrp) {
            return this.parent;
        }
        return this.parent.getFileGroup();
    }

    public static enum ClassType {
        ct_group,
        ct_array,
        ct_result,
        ct_parameter,
        ct_parameterGrp,
        ct_thresholdGrp,
        ct_fileGrp;

    }
}

