/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.results;

import com.google.gson.JsonObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestProperty;
import org.jenkinsci.plugins.benchmark.results.TestValue;

public class StringValue
extends TestValue {
    private final ConcurrentHashMap<Integer, String> values = new ConcurrentHashMap();

    public StringValue(TestGroup parent, String group, String name) {
        super(parent, group, name, null, null, TestValue.ValueType.rt_string);
    }

    public StringValue(TestGroup parent, String group, String name, String unit) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_string);
    }

    public StringValue(TestGroup parent, String group, String name, String description, String unit) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_string);
    }

    public StringValue(TestGroup parent, String name, String unit, TestGroup.ClassType ctype) {
        super(parent, null, name, null, unit, TestValue.ValueType.rt_string, ctype);
    }

    public StringValue(TestGroup parent, String group, String name, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, null, unit, TestValue.ValueType.rt_string, ctype);
    }

    public StringValue(TestGroup parent, String group, String name, String description, String unit, TestGroup.ClassType ctype) {
        super(parent, group, name, description, unit, TestValue.ValueType.rt_string, ctype);
    }

    @Override
    public JsonObject getCondensedJsonObject(int build, int hash) {
        Integer _fileHash;
        int failed = 0;
        int passed = 0;
        for (TestProperty property : this.properties.values()) {
            Boolean failedState = property.getFailedState();
            if (failedState == null) continue;
            if (failedState.booleanValue()) {
                ++failed;
                continue;
            }
            ++passed;
        }
        JsonObject object = new JsonObject();
        object.addProperty("hash", (Number)hash);
        if (this.getFileGroup() != null) {
            object.addProperty("file", (Number)this.getFileGroup().getGroupHash());
        }
        if (this.group != null && !this.group.isEmpty()) {
            object.addProperty("group", this.group);
        }
        object.addProperty("name", this.name);
        if (this.description != null && !this.description.isEmpty()) {
            object.addProperty("description", this.description);
        }
        if (this.unit != null && !this.unit.isEmpty()) {
            object.addProperty("unit", this.unit);
        }
        object.addProperty("type", StringValue.outputType(this.type));
        if (this.ctype == TestGroup.ClassType.ct_result && (_fileHash = this.getFileHash()) != null) {
            object.addProperty("file", (Number)_fileHash);
        }
        object.addProperty("failed", (Number)failed);
        object.addProperty("passed", (Number)passed);
        return object;
    }

    @Override
    public JsonObject getJsonObject(int hash) {
        JsonObject object = super.getJsonObject(hash);
        object.addProperty("value", this.getValue());
        return object;
    }

    @Override
    public String getValueAsString(int build) {
        String value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return value;
    }

    @Override
    public String getValueAsLocaleString(int build, char decimalSeparator) {
        String value = this.getValue(build);
        if (value == null) {
            return "";
        }
        return value;
    }

    public void setValue(String value) {
        this.values.put(0, value);
    }

    public void setValue(int build, String value) {
        this.values.put(build, value);
    }

    public Map<Integer, String> getValues() {
        return this.values;
    }

    public String getValue() {
        return this.values.get(0);
    }

    public String getValue(int build) {
        return this.values.get(build);
    }
}

