/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlFailures;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MapXmlParameter {
    private Integer id = null;
    private String name = null;
    private String description = null;
    private String unit = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private TestValue parameter;

    MapXmlParameter(TestGroup parent, String key, Node nContent, Node nSchema, MapXmlFailures failures, boolean truncateStrings) throws ValidationException {
        TestValue par;
        DoubleValue par2;
        double dblValue;
        String attrName;
        Node nSNode;
        Node nSNode2;
        Object message;
        int nItem;
        NamedNodeMap attributes;
        ParameterTags type;
        block30: for (Node nSNode3 = nSchema.getFirstChild(); nSNode3 != null; nSNode3 = nSNode3.getNextSibling()) {
            if (nSNode3.getNodeType() != 1 || !nSNode3.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode3);
            String attrName2 = this.getNameTag(nSNode3);
            switch (type) {
                case pt_id: {
                    Node node;
                    int i;
                    if (this.id != null) continue block30;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        try {
                            this.id = Integer.parseInt(node.getTextContent());
                            continue block30;
                        }
                        catch (Exception e) {
                            throw new ValidationException(Messages.IncorrectIntegerForId(parent.getFullName()));
                        }
                    }
                    continue block30;
                }
                case pt_name: {
                    Node node;
                    int i;
                    if (this.name != null) continue block30;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.name = node.getNodeValue();
                        this.name = this.name.replaceAll(" ", "_");
                        continue block30;
                    }
                    continue block30;
                }
                case pt_description: {
                    Node node;
                    int i;
                    if (this.description != null) continue block30;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.description = node.getNodeValue();
                        if (!truncateStrings || this.description.length() <= 512) continue block30;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        continue block30;
                    }
                    continue block30;
                }
                case pt_unit: {
                    Node node;
                    int i;
                    if (this.unit != null) continue block30;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        this.unit = node.getNodeValue();
                        continue block30;
                    }
                    continue block30;
                }
                case pt_message: {
                    Node node;
                    int i;
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (i = 0; i < nItem; ++i) {
                        node = attributes.item(i);
                        if (!attrName2.equals(node.getNodeName())) continue;
                        if (truncateStrings) {
                            message = node.getNodeValue();
                            if (((String)message).length() > 512) {
                                message = ((String)message).substring(0, 512);
                                message = (String)message + "...";
                            }
                            this.messages.put(attrName2, (String)message);
                            continue block30;
                        }
                        this.messages.put(attrName2, node.getNodeValue());
                        continue block30;
                    }
                    continue block30;
                }
            }
        }
        Node nSequence = null;
        for (nSNode2 = nSchema.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
            if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("sequence")) continue;
            nSequence = nSNode2;
            break;
        }
        if (nSequence != null) {
            block37: for (nSNode2 = nSequence.getFirstChild(); nSNode2 != null; nSNode2 = nSNode2.getNextSibling()) {
                if (nSNode2.getNodeType() != 1 || !nSNode2.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode2);
                String attrName3 = this.getNameTag(nSNode2);
                switch (type) {
                    case pt_id: {
                        Node nCNode;
                        if (this.id != null) continue block37;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            try {
                                this.id = Integer.parseInt(nCNode.getTextContent());
                                continue;
                            }
                            catch (Exception e) {
                                throw new ValidationException(Messages.IncorrectIntegerForId(parent.getFullName()));
                            }
                        }
                        continue block37;
                    }
                    case pt_name: {
                        Node nCNode;
                        if (this.name != null) continue block37;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.name = nCNode.getTextContent();
                            this.name = this.name.replaceAll(" ", "_");
                            continue block37;
                        }
                        continue block37;
                    }
                    case pt_description: {
                        Node nCNode;
                        if (this.description != null) continue block37;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.description = nCNode.getTextContent();
                            if (!truncateStrings || this.description.length() <= 512) continue block37;
                            this.description = this.description.substring(0, 512);
                            this.description = this.description + "...";
                            continue block37;
                        }
                        continue block37;
                    }
                    case pt_unit: {
                        Node nCNode;
                        if (this.unit != null) continue block37;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            this.unit = nCNode.getTextContent();
                            continue block37;
                        }
                        continue block37;
                    }
                    case pt_message: {
                        Node nCNode;
                        for (nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            if (!attrName3.equals(nCNode.getNodeName())) continue;
                            if (truncateStrings) {
                                message = nCNode.getTextContent();
                                if (((String)message).length() > 512) {
                                    message = ((String)message).substring(0, 512);
                                    message = (String)message + "...";
                                }
                                this.messages.put(attrName3, (String)message);
                                continue block37;
                            }
                            this.messages.put(attrName3, nCNode.getTextContent());
                            continue block37;
                        }
                        continue block37;
                    }
                }
            }
        }
        boolean parameterDetected = false;
        for (nSNode = nSchema.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
            if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("attribute")) continue;
            type = this.getTypeTag(nSNode);
            attrName = this.getNameTag(nSNode);
            block19 : switch (type) {
                case pt_value: {
                    attributes = nContent.getAttributes();
                    nItem = attributes.getLength();
                    for (int i = 0; i < nItem; ++i) {
                        Node node = attributes.item(i);
                        if (!attrName.equals(node.getNodeName())) continue;
                        if (this.name == null) {
                            this.name = Objects.requireNonNullElse(key, attrName);
                        }
                        try {
                            dblValue = Double.parseDouble(node.getNodeValue());
                            par2 = new DoubleValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                            par2.setValue(dblValue);
                            this.parameter = par2;
                            parameterDetected = true;
                        }
                        catch (Exception e) {
                            par = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                            ((StringValue)par).setValue(node.getNodeValue());
                            this.parameter = par;
                            parameterDetected = true;
                        }
                        break block19;
                    }
                    break;
                }
            }
            if (parameterDetected) break;
        }
        if (parameterDetected) {
            this.parameter.setMessages(this.messages);
            return;
        }
        if (nSequence != null) {
            for (nSNode = nSequence.getFirstChild(); nSNode != null; nSNode = nSNode.getNextSibling()) {
                if (nSNode.getNodeType() != 1 || !nSNode.getLocalName().equalsIgnoreCase("element")) continue;
                type = this.getTypeTag(nSNode);
                attrName = this.getNameTag(nSNode);
                block22 : switch (type) {
                    case pt_value: {
                        for (Node nCNode = nContent.getFirstChild(); nCNode != null; nCNode = nCNode.getNextSibling()) {
                            String text;
                            if (!attrName.equals(nCNode.getLocalName())) continue;
                            if (this.name == null) {
                                this.name = Objects.requireNonNullElse(key, attrName);
                            }
                            if ((text = nCNode.getTextContent()).length() == 0) {
                                StringValue par3 = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                                par3.setValue(attrName);
                                this.parameter = par3;
                                parameterDetected = true;
                                break block22;
                            }
                            if (text.equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                                boolean boolValue = Boolean.parseBoolean(text);
                                par = new BooleanValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                                ((BooleanValue)par).setValue(boolValue);
                                this.parameter = par;
                                parameterDetected = true;
                                break block22;
                            }
                            try {
                                dblValue = Double.parseDouble(text);
                                par2 = new DoubleValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                                par2.setValue(dblValue);
                                this.parameter = par2;
                                parameterDetected = true;
                            }
                            catch (Exception e) {
                                par = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                                ((StringValue)par).setValue(text);
                                par.setFailedState(failures.isFailure(text));
                                this.parameter = par;
                                parameterDetected = true;
                            }
                            break block22;
                        }
                        break;
                    }
                }
                if (parameterDetected) break;
            }
            if (parameterDetected) {
                this.parameter.setMessages(this.messages);
                return;
            }
        }
        if (key.equals(nContent.getNodeName())) {
            String text;
            if (this.name == null) {
                this.name = key;
            }
            if ((text = nContent.getTextContent()).length() == 0) {
                StringValue par4 = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                par4.setValue(key);
                par4.setFailedState(failures.isFailure(key, true));
                this.parameter = par4;
                parameterDetected = true;
            } else if (text.equalsIgnoreCase("true") && text.equalsIgnoreCase("false")) {
                boolean boolValue = Boolean.parseBoolean(text);
                BooleanValue par5 = new BooleanValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                par5.setValue(boolValue);
                par5.setFailedState(failures.isFailure(boolValue));
                this.parameter = par5;
                parameterDetected = true;
            } else {
                try {
                    double dblValue2 = Double.parseDouble(text);
                    DoubleValue par6 = new DoubleValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                    par6.setValue(dblValue2);
                    this.parameter = par6;
                    parameterDetected = true;
                }
                catch (Exception e) {
                    StringValue par7 = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                    par7.setValue(text);
                    par7.setFailedState(failures.isFailure(text));
                    this.parameter = par7;
                    parameterDetected = true;
                }
            }
        }
        if (parameterDetected) {
            this.parameter.setMessages(this.messages);
        }
    }

    private String getNameTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("name")) continue;
            return attributes.item(i).getNodeValue();
        }
        return null;
    }

    private ParameterTags getTypeTag(Node nSchema) {
        NamedNodeMap attributes = nSchema.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String value;
            String name = attributes.item(i).getNodeName();
            if (!name.equalsIgnoreCase("type")) continue;
            switch (value = attributes.item(i).getNodeValue().toLowerCase()) {
                case "jbs:id": {
                    return ParameterTags.pt_id;
                }
                case "jbs:name": {
                    return ParameterTags.pt_name;
                }
                case "jbs:description": {
                    return ParameterTags.pt_description;
                }
                case "jbs:unit": {
                    return ParameterTags.pt_unit;
                }
                case "jbs:value": {
                    return ParameterTags.pt_value;
                }
                case "jbs:message": {
                    return ParameterTags.pt_message;
                }
            }
            return ParameterTags.pt_unknown;
        }
        return ParameterTags.pt_empty;
    }

    public TestValue getParameter() {
        return this.parameter;
    }

    private static enum ParameterTags {
        pt_empty,
        pt_unknown,
        pt_id,
        pt_name,
        pt_description,
        pt_unit,
        pt_value,
        pt_message;

    }
}

