/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.jenkinsci.plugins.benchmark.condensed.DoubleCondensed;
import org.jenkinsci.plugins.benchmark.condensed.IntegerCondensed;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.Messages;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.NumeralValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestProperty;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;

public class MapperBase {
    protected final TestGroup rootGroup;
    protected final Map<Integer, TestGroup> groups = new HashMap<Integer, TestGroup>();
    protected final Map<Integer, TestGroup> files = new ConcurrentHashMap<Integer, TestGroup>();
    protected final Map<Integer, TestValue> results = new ConcurrentHashMap<Integer, TestValue>();
    protected final Map<Integer, TestValue> parameters = new ConcurrentHashMap<Integer, TestValue>();
    protected final char decimalSeparator;
    protected final boolean truncateStrings;
    protected boolean hasNumericResult = false;
    protected boolean hasHistoryThreshold = false;
    private Integer build;
    protected ContentDetected detected;
    protected final TreeSet<Integer> builds;

    public MapperBase(Integer build, Boolean truncateStrings) {
        this.rootGroup = new TestGroup(null, "__root__", "");
        this.builds = new TreeSet();
        this.detected = new ContentDetected();
        this.truncateStrings = truncateStrings;
        this.build = build;
        DecimalFormat format = (DecimalFormat)DecimalFormat.getInstance();
        DecimalFormatSymbols symbols = format.getDecimalFormatSymbols();
        this.decimalSeparator = symbols.getDecimalSeparator();
    }

    public void mergeWith(MapperBase mapper) throws ValidationException {
        if (mapper != null && mapper.results.size() != 0) {
            String strV;
            StringValue strBaseValue;
            StringValue strValue;
            Boolean boolV;
            BooleanValue boolBaseValue;
            BooleanValue boolValue;
            Integer intV;
            IntegerValue intBaseValue;
            IntegerValue intValue;
            Double dblV;
            DoubleValue dblBaseValue;
            DoubleValue dblValue;
            TestValue value;
            for (Map.Entry<Integer, TestValue> baseResult : mapper.getResults().entrySet()) {
                boolean detectedResult = false;
                for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
                    if (result.getKey().intValue() != baseResult.getKey().intValue()) continue;
                    value = result.getValue();
                    switch (value.getType()) {
                        case rt_double: {
                            dblValue = (DoubleValue)value;
                            dblBaseValue = (DoubleValue)baseResult.getValue();
                            dblV = dblValue.getValues().get(0);
                            dblValue.getValues().clear();
                            dblValue.getValues().put(this.build, dblV);
                            dblValue.getValues().putAll(dblBaseValue.getValues());
                            if (dblValue.getProperties().size() > 0) {
                                TestProperty dblProperty = dblValue.getProperties().get(0);
                                dblValue.getProperties().clear();
                                dblValue.getProperties().put(this.build, dblProperty);
                            }
                            dblValue.getProperties().putAll(dblBaseValue.getProperties());
                            break;
                        }
                        case rt_integer: {
                            intValue = (IntegerValue)value;
                            intBaseValue = (IntegerValue)baseResult.getValue();
                            intV = intValue.getValues().get(0);
                            intValue.getValues().clear();
                            intValue.getValues().put(this.build, intV);
                            intValue.getValues().putAll(intBaseValue.getValues());
                            if (intValue.getProperties().size() > 0) {
                                TestProperty intProperty = intValue.getProperties().get(0);
                                intValue.getProperties().clear();
                                intValue.getProperties().put(this.build, intProperty);
                            }
                            intValue.getProperties().putAll(intBaseValue.getProperties());
                            break;
                        }
                        case rt_boolean: {
                            boolValue = (BooleanValue)value;
                            boolBaseValue = (BooleanValue)baseResult.getValue();
                            boolV = boolValue.getValues().get(0);
                            boolValue.getValues().clear();
                            boolValue.getValues().put(this.build, boolV);
                            boolValue.getValues().putAll(boolBaseValue.getValues());
                            if (boolValue.getProperties().size() > 0) {
                                TestProperty boolProperty = boolValue.getProperties().get(0);
                                boolValue.getProperties().clear();
                                boolValue.getProperties().put(this.build, boolProperty);
                            }
                            boolValue.getProperties().putAll(boolBaseValue.getProperties());
                            break;
                        }
                        case rt_string: {
                            strValue = (StringValue)value;
                            strBaseValue = (StringValue)baseResult.getValue();
                            strV = strValue.getValues().get(0);
                            strValue.getValues().clear();
                            strValue.getValues().put(this.build, strV);
                            strValue.getValues().putAll(strBaseValue.getValues());
                            if (strValue.getProperties().size() > 0) {
                                TestProperty strProperty = strValue.getProperties().get(0);
                                strValue.getProperties().clear();
                                strValue.getProperties().put(this.build, strProperty);
                            }
                            strValue.getProperties().putAll(strBaseValue.getProperties());
                            break;
                        }
                    }
                    detectedResult = true;
                    break;
                }
                if (detectedResult) continue;
                this.results.put(baseResult.getKey(), baseResult.getValue());
            }
            for (Map.Entry<Integer, TestValue> baseParam : mapper.getParameters().entrySet()) {
                boolean detectedParam = false;
                for (Map.Entry<Integer, TestValue> param : this.parameters.entrySet()) {
                    if (param.getKey().intValue() != baseParam.getKey().intValue()) continue;
                    value = param.getValue();
                    switch (value.getType()) {
                        case rt_double: {
                            dblValue = (DoubleValue)value;
                            dblBaseValue = (DoubleValue)baseParam.getValue();
                            dblV = dblValue.getValues().get(0);
                            dblValue.getValues().clear();
                            dblValue.getValues().put(this.build, dblV);
                            dblValue.getValues().putAll(dblBaseValue.getValues());
                            break;
                        }
                        case rt_integer: {
                            intValue = (IntegerValue)value;
                            intBaseValue = (IntegerValue)baseParam.getValue();
                            intV = intValue.getValues().get(0);
                            intValue.getValues().clear();
                            intValue.getValues().put(this.build, intV);
                            intValue.getValues().putAll(intBaseValue.getValues());
                            break;
                        }
                        case rt_boolean: {
                            boolValue = (BooleanValue)value;
                            boolBaseValue = (BooleanValue)baseParam.getValue();
                            boolV = boolValue.getValues().get(0);
                            boolValue.getValues().clear();
                            boolValue.getValues().put(this.build, boolV);
                            boolValue.getValues().putAll(boolBaseValue.getValues());
                            break;
                        }
                        case rt_string: {
                            strValue = (StringValue)value;
                            strBaseValue = (StringValue)baseParam.getValue();
                            strV = strValue.getValues().get(0);
                            strValue.getValues().clear();
                            strValue.getValues().put(this.build, strV);
                            strValue.getValues().putAll(strBaseValue.getValues());
                            break;
                        }
                    }
                    detectedParam = true;
                    break;
                }
                if (detectedParam) continue;
                this.parameters.put(baseParam.getKey(), baseParam.getValue());
            }
            for (Map.Entry<Integer, TestGroup> baseFile : mapper.getFiles().entrySet()) {
                boolean detectedFile = false;
                for (Map.Entry<Integer, TestGroup> file : this.files.entrySet()) {
                    if (file.getKey().intValue() != baseFile.getKey().intValue()) continue;
                    detectedFile = true;
                    break;
                }
                if (detectedFile) continue;
                this.files.put(baseFile.getKey(), baseFile.getValue());
            }
        }
    }

    public void addAllThresholds(List<? extends Threshold> thresholds) {
        for (Threshold threshold : thresholds) {
            this.addThreshold(threshold);
        }
    }

    private void addThreshold(Threshold threshold) {
        Object extName = "";
        if (threshold.getTestGroup().isEmpty()) {
            if (threshold.getTestName().isEmpty()) {
                for (TestValue result : this.results.values()) {
                    result.addThreshold(threshold);
                    this.checkThresholdType(threshold);
                }
            } else {
                for (TestValue result : this.results.values()) {
                    if (!result.getName().equals(threshold.getTestName())) continue;
                    result.addThreshold(threshold);
                    this.checkThresholdType(threshold);
                }
            }
        } else {
            extName = threshold.getTestGroup();
            if (!threshold.getTestName().isEmpty()) {
                extName = (String)extName + "." + threshold.getTestName();
            }
            Integer hash = ((String)extName).hashCode();
            for (Map.Entry<Integer, TestGroup> group : this.groups.entrySet()) {
                TestGroup grp = group.getValue();
                if (grp.getClassType() == TestGroup.ClassType.ct_fileGrp) continue;
                Integer grpHash = grp.getFileSubGroupFullName().hashCode();
                if (hash.intValue() != grpHash.intValue()) continue;
                grp.addThreshold(threshold);
                this.checkThresholdType(threshold);
            }
        }
    }

    public boolean checkThresholds(MapperBase base) {
        boolean failed = false;
        for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
            Boolean state;
            if (base != null && base.results.size() != 0) {
                NumeralValue value;
                if (result.getValue().getType() == TestValue.ValueType.rt_double) {
                    for (Map.Entry<Integer, TestValue> baseResult : base.getResults().entrySet()) {
                        if (result.getKey().intValue() != baseResult.getKey().intValue()) continue;
                        value = (DoubleCondensed)baseResult.getValue();
                        result.getValue().checkThresholdStatus(((DoubleCondensed)value).getPrevious(), ((DoubleCondensed)value).getAverage());
                        break;
                    }
                } else if (result.getValue().getType() == TestValue.ValueType.rt_integer) {
                    for (Map.Entry<Integer, TestValue> baseResult : base.getResults().entrySet()) {
                        if (result.getKey().intValue() != baseResult.getKey().intValue()) continue;
                        value = (IntegerCondensed)baseResult.getValue();
                        result.getValue().checkThresholdStatus(((IntegerCondensed)value).getPrevious().doubleValue(), ((IntegerCondensed)value).getAverage());
                        break;
                    }
                }
            } else {
                result.getValue().checkThresholdStatus(null, null);
            }
            if ((state = result.getValue().getFailedState()) == null || !state.booleanValue()) continue;
            failed = true;
        }
        return failed;
    }

    public void importFromFile(String inputFile) throws NullPointerException, IOException, JsonIOException, JsonSyntaxException {
        File oFile = new File(inputFile);
        if (oFile.exists()) {
            this.importFromFile(oFile, this.detected);
        }
    }

    public void importFromFile(File inputFile, ContentDetected detected) throws NullPointerException, IOException, JsonIOException, JsonSyntaxException {
        Integer build = null;
        JsonParser parser = new JsonParser();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8);){
            JsonElement jsonContent = parser.parse((Reader)reader);
            if (jsonContent.isJsonObject()) {
                JsonElement element;
                JsonObject jsonObject = jsonContent.getAsJsonObject();
                for (Map.Entry enContent : jsonObject.entrySet()) {
                    JsonPrimitive primitive;
                    if (!((String)enContent.getKey()).equalsIgnoreCase("build")) continue;
                    element = (JsonElement)enContent.getValue();
                    if (!element.isJsonPrimitive() || !(primitive = element.getAsJsonPrimitive()).isNumber()) break;
                    this.build = build = Integer.valueOf(primitive.getAsInt());
                    this.builds.add(build);
                    break;
                }
                if (build != null) {
                    JsonObject aObject;
                    JsonArray array;
                    for (Map.Entry enContent : jsonObject.entrySet()) {
                        if (!((String)enContent.getKey()).equalsIgnoreCase("parameters") || !(element = (JsonElement)enContent.getValue()).isJsonArray()) continue;
                        array = element.getAsJsonArray();
                        for (JsonElement aElement : array) {
                            if (!aElement.isJsonObject()) continue;
                            aObject = aElement.getAsJsonObject();
                            TestValue.convertParameterJsonObject(build, aObject, this.rootGroup, this.parameters);
                        }
                    }
                    for (Map.Entry enContent : jsonObject.entrySet()) {
                        if (!((String)enContent.getKey()).equalsIgnoreCase("results") || !(element = (JsonElement)enContent.getValue()).isJsonArray()) continue;
                        array = element.getAsJsonArray();
                        for (JsonElement aElement : array) {
                            if (!aElement.isJsonObject()) continue;
                            aObject = aElement.getAsJsonObject();
                            TestValue.convertResultJsonObject(build, aObject, this.rootGroup, this.files, this.results, this.parameters);
                        }
                    }
                }
            }
        }
    }

    public boolean exportToFile(String outputFile, String job, int build) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
            JsonObject rootObject = new JsonObject();
            rootObject.addProperty("job", job);
            rootObject.addProperty("build", (Number)build);
            if (this.results.size() > 0) {
                JsonArray resultArray = new JsonArray();
                for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
                    resultArray.add((JsonElement)result.getValue().getJsonObject(result.getKey()));
                }
                rootObject.add("results", (JsonElement)resultArray);
            }
            if (this.parameters.size() > 0) {
                JsonArray parameterArray = new JsonArray();
                for (Map.Entry<Integer, TestValue> parameter : this.parameters.entrySet()) {
                    parameterArray.add((JsonElement)parameter.getValue().getJsonObject(parameter.getKey()));
                }
                rootObject.add("parameters", (JsonElement)parameterArray);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)rootObject, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String getHTMLTable() {
        Integer n;
        Integer nFailed2;
        if (this.results.size() == 0) {
            return "";
        }
        int nBuilds = this.builds.last() - this.builds.first() + 1;
        ArrayList<Integer> listNFailed = new ArrayList<Integer>(Collections.nCopies(nBuilds, 0));
        ArrayList<Integer> listNPassed = new ArrayList<Integer>(Collections.nCopies(nBuilds, 0));
        StringBuffer body = new StringBuffer();
        body.append("<tbody>");
        for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
            body.append(result.getValue().getHTMLResult(result.getKey(), this.detected, this.builds, listNPassed, listNFailed, this.decimalSeparator));
        }
        body.append("</tbody>");
        StringBuffer header_top = new StringBuffer();
        StringBuffer header_bot = new StringBuffer();
        header_top.append("<thead><tr>");
        header_bot.append("<tfoot><tr>");
        if (this.detected.isFileDetected().booleanValue()) {
            header_top.append("<th rowspan=\"3\">");
            header_top.append(Messages.MapperBase_Location());
            header_top.append("</th>");
            header_bot.append("<th rowspan=\"3\">");
            header_bot.append(Messages.MapperBase_Location());
            header_bot.append("</th>");
        }
        if (this.detected.isGroupDetected().booleanValue()) {
            header_top.append("<th rowspan=\"3\">");
            header_top.append(Messages.MapperBase_Group());
            header_top.append("</th>");
            header_bot.append("<th rowspan=\"3\">");
            header_bot.append(Messages.MapperBase_Group());
            header_bot.append("</th>");
        }
        if (this.detected.isUnitsDetected().booleanValue()) {
            header_top.append("<th rowspan=\"3\">");
            header_top.append(Messages.MapperBase_Result());
            header_top.append("</th>");
        }
        header_top.append("<th>");
        header_top.append(Messages.MapperBase_Passed());
        header_top.append("</th><th rowspan=\"3\">");
        header_top.append(Messages.MapperBase_ResultKey());
        for (Integer nPassed : listNPassed) {
            header_top.append("</th><th style=\"background-color:");
            header_top.append("#92D050");
            header_top.append(";\">");
            header_top.append(nPassed.toString());
        }
        header_top.append("</th></tr><tr><th>");
        header_top.append(Messages.MapperBase_Failed());
        for (Integer nFailed2 : listNFailed) {
            header_top.append("</th><th style=\"background-color:");
            header_top.append("#F37A7A");
            header_top.append(";\">");
            header_top.append(nFailed2.toString());
        }
        header_top.append("</th></tr><tr><th>");
        if (this.detected.isUnitsDetected().booleanValue()) {
            header_top.append(Messages.MapperBase_Unit());
        } else {
            header_top.append(Messages.MapperBase_Result());
        }
        Integer build = this.builds.last();
        while (build >= this.builds.first()) {
            header_top.append("</th><th>");
            header_top.append(build.toString());
            nFailed2 = build;
            n = build = Integer.valueOf(build - 1);
        }
        header_top.append("</th></tr></thead>");
        if (this.detected.isUnitsDetected().booleanValue()) {
            header_bot.append("<th rowspan=\"3\">");
            header_bot.append(Messages.MapperBase_Result());
            header_bot.append("</th><th>");
            header_bot.append(Messages.MapperBase_Unit());
        } else {
            header_bot.append("<th>");
            header_bot.append(Messages.MapperBase_Result());
        }
        header_bot.append("</th><th rowspan=\"3\">");
        header_bot.append(Messages.MapperBase_ResultKey());
        build = this.builds.last();
        while (build >= this.builds.first()) {
            header_bot.append("</th><th>");
            header_bot.append(build.toString());
            nFailed2 = build;
            n = build = Integer.valueOf(build - 1);
        }
        header_bot.append("</th></tr><tr><th>");
        header_bot.append(Messages.MapperBase_Passed());
        for (Integer nPassed : listNPassed) {
            header_bot.append("</th><th style=\"background-color:");
            header_bot.append("#92D050");
            header_bot.append(";\">");
            header_bot.append(nPassed.toString());
        }
        header_bot.append("</th></tr><tr><th>");
        header_bot.append(Messages.MapperBase_Failed());
        for (Integer nFailed2 : listNFailed) {
            header_bot.append("</th><th style=\"background-color:");
            header_bot.append("#F37A7A");
            header_bot.append(";\">");
            header_bot.append(nFailed2.toString());
        }
        header_bot.append("</th></tr></tfoot>");
        header_top.append(header_bot);
        header_top.append(body);
        return header_top.toString();
    }

    public String getCSVTableHeader() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer content = new StringBuffer();
        if (this.detected.isFileDetected().booleanValue()) {
            content.append(Messages.MapperBase_Location());
            content.append(',');
        }
        if (this.detected.isGroupDetected().booleanValue()) {
            content.append(Messages.MapperBase_Group());
            content.append(',');
        }
        content.append(Messages.MapperBase_Result());
        Integer build = this.builds.last();
        while (build >= this.builds.first()) {
            content.append(',');
            content.append(build.toString());
            Integer n = build;
            Integer n2 = build = Integer.valueOf(build - 1);
        }
        return content.toString();
    }

    public String getCSVTableBody() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer content = new StringBuffer();
        for (TestValue result : this.results.values()) {
            content.append(result.getCSVResult(this.builds, this.detected));
            content.append("\n");
        }
        return content.toString();
    }

    public String getCSVTableStateBody() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer content = new StringBuffer();
        for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
            content.append(result.getValue().getCSVResultState(result.getKey(), this.detected, this.builds));
            content.append("\n");
        }
        return content.toString();
    }

    public String getHTMLCondensedTable() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer header = new StringBuffer();
        header.append("<th>");
        if (this.detected.isFileDetected().booleanValue()) {
            header.append(Messages.MapperBase_Location());
            header.append("</th><th>");
        }
        if (this.detected.isGroupDetected().booleanValue()) {
            header.append(Messages.MapperBase_Group());
            header.append("</th><th>");
        }
        header.append(Messages.MapperBase_Result());
        header.append("</th><th>");
        if (this.detected.isUnitsDetected().booleanValue()) {
            header.append(Messages.MapperBase_Unit());
            header.append("</th><th>");
        }
        header.append(Messages.MapperBase_ResultKey());
        header.append("</th><th>");
        if (this.detected.isNumeralDetected().booleanValue()) {
            header.append(Messages.MapperBase_Minimum());
            header.append("</th><th>");
            header.append(Messages.MapperBase_Maximum());
            header.append("</th><th>");
            header.append(Messages.MapperBase_Average());
            header.append("</th><th>");
            header.append(Messages.MapperBase_StdDeviation());
            header.append("</th><th>");
        }
        header.append(Messages.MapperBase_Passed());
        header.append("</th><th>");
        header.append(Messages.MapperBase_Failed());
        header.append("</th>");
        StringBuffer content = new StringBuffer();
        content.append("<thead><tr>");
        content.append(header);
        content.append("</tr></thead><tfoot><tr>");
        content.append(header);
        content.append("</tr></tfoot><tbody>");
        for (Map.Entry<Integer, TestValue> result : this.results.entrySet()) {
            content.append(result.getValue().getHTMLCondensed(result.getKey(), this.detected, this.decimalSeparator));
        }
        content.append("</tbody>");
        return content.toString();
    }

    public String getCSVCondensedTableHeader() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer content = new StringBuffer();
        if (this.detected.isFileDetected().booleanValue()) {
            content.append(Messages.MapperBase_Location());
            content.append(',');
        }
        if (this.detected.isGroupDetected().booleanValue()) {
            content.append(Messages.MapperBase_Group());
            content.append(',');
        }
        content.append(Messages.MapperBase_Result());
        if (this.detected.isUnitsDetected().booleanValue()) {
            content.append(',');
            content.append(Messages.MapperBase_Unit());
        }
        if (this.detected.isNumeralDetected().booleanValue()) {
            content.append(',');
            content.append(Messages.MapperBase_Minimum());
            content.append(',');
            content.append(Messages.MapperBase_Maximum());
            content.append(',');
            content.append(Messages.MapperBase_Average());
            content.append(',');
            content.append(Messages.MapperBase_StdDeviation());
        }
        content.append(',');
        content.append(Messages.MapperBase_Failed());
        content.append(',');
        content.append(Messages.MapperBase_Passed());
        return content.toString();
    }

    public String getCSVCondensedTableBody() {
        if (this.results.size() == 0) {
            return "";
        }
        StringBuffer content = new StringBuffer();
        for (TestValue result : this.results.values()) {
            content.append(result.getCSVCondensed(this.detected));
            content.append("\n");
        }
        return content.toString();
    }

    public boolean importCondensedFromFile(String inputFilename) throws NullPointerException, IOException, JsonIOException, JsonSyntaxException, ValidationException {
        File inputFile = new File(inputFilename);
        if (inputFile.exists()) {
            this.importCondensedFromFile(inputFile);
            return true;
        }
        return false;
    }

    public void importCondensedFromFile(File inputFile) throws NullPointerException, IOException, JsonIOException, JsonSyntaxException, ValidationException {
        Integer build = null;
        JsonParser parser = new JsonParser();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(inputFile), StandardCharsets.UTF_8);){
            JsonElement jsonContent = parser.parse((Reader)reader);
            if (jsonContent.isJsonObject()) {
                JsonElement element;
                JsonObject jsonObject = jsonContent.getAsJsonObject();
                for (Map.Entry enContent : jsonObject.entrySet()) {
                    JsonPrimitive primitive;
                    if (!((String)enContent.getKey()).equalsIgnoreCase("build")) continue;
                    element = (JsonElement)enContent.getValue();
                    if (!element.isJsonPrimitive() || !(primitive = element.getAsJsonPrimitive()).isNumber()) break;
                    build = primitive.getAsInt();
                    break;
                }
                if (build != null) {
                    JsonObject aObject;
                    JsonArray array;
                    for (Map.Entry enContent : jsonObject.entrySet()) {
                        if (!((String)enContent.getKey()).equalsIgnoreCase("files") || !(element = (JsonElement)enContent.getValue()).isJsonArray()) continue;
                        array = element.getAsJsonArray();
                        for (JsonElement aElement : array) {
                            if (!aElement.isJsonObject()) continue;
                            aObject = aElement.getAsJsonObject();
                            TestGroup.convertCondensedFileJsonObject(aObject, this.rootGroup, this.files, this.detected);
                        }
                    }
                    for (Map.Entry enContent : jsonObject.entrySet()) {
                        if (!((String)enContent.getKey()).equalsIgnoreCase("parameters") || !(element = (JsonElement)enContent.getValue()).isJsonArray()) continue;
                        array = element.getAsJsonArray();
                        for (JsonElement aElement : array) {
                            if (!aElement.isJsonObject()) continue;
                            aObject = aElement.getAsJsonObject();
                            TestValue.convertCondensedParameterJsonObject(aObject, this.rootGroup, this.parameters, this.detected);
                        }
                    }
                    for (Map.Entry enContent : jsonObject.entrySet()) {
                        if (!((String)enContent.getKey()).equalsIgnoreCase("results") || !(element = (JsonElement)enContent.getValue()).isJsonArray()) continue;
                        array = element.getAsJsonArray();
                        for (JsonElement aElement : array) {
                            if (!aElement.isJsonObject()) continue;
                            aObject = aElement.getAsJsonObject();
                            TestValue.convertCondensedResultJsonObject(aObject, this.rootGroup, this.files, this.results, this.detected);
                        }
                    }
                }
            }
        }
    }

    public boolean exportCondensedToFile(String outputFile, String job, int build) {
        try {
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), StandardCharsets.UTF_8);
            JsonObject rootObject = new JsonObject();
            rootObject.addProperty("job", job);
            rootObject.addProperty("build", (Number)build);
            if (this.results.size() > 0) {
                JsonArray resultArray = new JsonArray();
                for (Map.Entry<Integer, TestValue> entry : this.results.entrySet()) {
                    resultArray.add((JsonElement)entry.getValue().getCondensedJsonObject(build, entry.getKey()));
                }
                rootObject.add("results", (JsonElement)resultArray);
            }
            if (this.parameters.size() > 0) {
                JsonArray parameterArray = new JsonArray();
                for (Map.Entry<Integer, TestValue> entry : this.parameters.entrySet()) {
                    parameterArray.add((JsonElement)entry.getValue().getParameterJsonObject(entry.getKey()));
                }
                rootObject.add("parameters", (JsonElement)parameterArray);
            }
            boolean detFiles = false;
            JsonArray fileArray = new JsonArray();
            for (Map.Entry<Integer, TestGroup> group : this.groups.entrySet()) {
                if (group.getValue().getClassType() != TestGroup.ClassType.ct_fileGrp) continue;
                fileArray.add((JsonElement)group.getValue().getJsonObject(group.getKey()));
                detFiles = true;
            }
            if (detFiles) {
                rootObject.add("files", (JsonElement)fileArray);
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((JsonElement)rootObject, (Appendable)writer);
            writer.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void checkResult(TestValue result) {
        switch (result.getType()) {
            case rt_double: 
            case rt_integer: {
                this.hasNumericResult = true;
                break;
            }
        }
    }

    protected void checkThresholdType(Threshold threshold) {
        switch (threshold.getType()) {
            case tt_delta: 
            case tt_percentage: 
            case tt_deltaAverage: 
            case tt_percentageAverage: {
                this.hasHistoryThreshold = true;
                break;
            }
        }
    }

    public boolean requiresHistory() {
        return this.hasNumericResult && this.hasHistoryThreshold;
    }

    public void logKeyData(TaskListener listener, Integer numberOfAddedThresholds) {
        listener.getLogger().println(Messages.MapperBase_NumberOfResults() + this.getResults().size());
        listener.getLogger().println(Messages.MapperBase_NumberOfParameters() + this.getParameters().size());
        listener.getLogger().println(Messages.MapperBase_NumberOfAddedThresholds() + numberOfAddedThresholds);
        if (this.hasNumericResult) {
            listener.getLogger().println(Messages.MapperBase_ResultsContainsNumerals());
        } else {
            listener.getLogger().println(Messages.MapperBase_ResultsDoesNotContainNumerals());
        }
        if (this.truncateStrings) {
            listener.getLogger().println(Messages.MapperBase_StringsAreTruncated());
        } else {
            listener.getLogger().println(Messages.MapperBase_StringsAreNotTruncated());
        }
    }

    public void setBuild(Integer build) {
        this.build = build;
    }

    public TestGroup getRootGroup() {
        return this.rootGroup;
    }

    public int getNumberOfResults() {
        return this.results.size();
    }

    public Map<Integer, TestValue> getResults() {
        return this.results;
    }

    public int getNumberOfParameters() {
        return this.parameters.size();
    }

    public Map<Integer, TestValue> getParameters() {
        return this.parameters;
    }

    public int getNumberOfFiles() {
        return this.files.size();
    }

    public Map<Integer, TestGroup> getFiles() {
        return this.files;
    }

    public int getNumberOfGroups() {
        return this.groups.size();
    }

    public Map<Integer, TestGroup> getGroups() {
        return this.groups;
    }

    public TreeSet<Integer> getBuilds() {
        return this.builds;
    }

    public ContentDetected getDetected() {
        return this.detected;
    }

    public char getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public Integer getBuild() {
        return this.build;
    }
}

