/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonFailures;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonGroup;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonParameter;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonParameterFull;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonResult;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonResultFull;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonThreshold;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;

public class MapJsonToPlugin
extends MapperBase {
    public MapJsonToPlugin(Integer build, File content, JsonElement schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        JsonElement jContent;
        try {
            jContent = this.getJSON(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapJsonToPlugin_FileFormatNotRecognisedAsJson(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, jContent, schema);
    }

    public MapJsonToPlugin(Integer build, FilePath content, JsonElement schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        JsonElement jContent;
        try {
            jContent = this.getJSON(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapJsonToPlugin_FileFormatNotRecognisedAsJson(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, jContent, schema);
    }

    public MapJsonToPlugin(Integer build, Map<String, FilePath> content, JsonElement schema, boolean truncateStrings, TaskListener listener) throws IOException, ValidationException {
        super(build, truncateStrings);
        listener.getLogger().println(Messages.MapJsonToPlugin_ListOfFilesDetected());
        int files_processed = 0;
        for (Map.Entry<String, FilePath> entry : content.entrySet()) {
            JsonElement jContent;
            String relativePath = this.FilePathToString(entry.getValue());
            try {
                jContent = this.getJSON(entry.getValue());
            }
            catch (Exception e) {
                listener.getLogger().println("   - " + Messages.MapJsonToPlugin_PrintFailedToIdentifyFile(relativePath));
                continue;
            }
            try {
                TestGroup group = new TestGroup(this.rootGroup, entry.getKey(), relativePath, TestGroup.ClassType.ct_fileGrp);
                this.files.put(group.getGroupHash(), group);
                this.groups.put(group.getGroupHash(), group);
                this.rootGroup.addGroup(group);
                this.InitiateLoading(group, jContent, schema);
                listener.getLogger().println("   - " + relativePath);
                ++files_processed;
            }
            catch (Exception e) {
                listener.getLogger().println("   - " + Messages.MapJsonToPlugin_PrintFailedToLoadFile(relativePath));
            }
        }
        if (files_processed == 0) {
            throw new ValidationException(Messages.MapJsonToPlugin_NoValidFileFound());
        }
    }

    public MapJsonToPlugin(Integer build, FilePath content, String schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        JsonElement jContent;
        JsonElement jSchema;
        try {
            jSchema = this.getJSON(schema);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapJsonToPlugin_SchemaNotRecognisedAsJson());
        }
        try {
            jContent = this.getJSON(content);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapJsonToPlugin_FileFormatNotRecognisedAsJson(content.getName()));
        }
        this.InitiateLoading(this.rootGroup, jContent, jSchema);
    }

    public MapJsonToPlugin(Integer build, Map<String, FilePath> content, String schema, boolean truncateStrings) throws IOException, ValidationException {
        super(build, truncateStrings);
        JsonElement jSchema;
        try {
            jSchema = this.getJSON(schema);
        }
        catch (Exception e) {
            throw new IOException(Messages.MapJsonToPlugin_SchemaNotRecognisedAsJson());
        }
        for (Map.Entry<String, FilePath> entry : content.entrySet()) {
            JsonElement jContent;
            try {
                jContent = this.getJSON(entry.getValue());
            }
            catch (Exception e) {
                throw new IOException(Messages.MapJsonToPlugin_FileFormatNotRecognisedAsJson(entry.getValue().getName()));
            }
            String relativePath = null;
            Object nextChunk = null;
            for (FilePath path = entry.getValue(); path != null && !path.getName().equalsIgnoreCase("workspace"); path = path.getParent()) {
                if (relativePath == null) {
                    if (nextChunk != null) {
                        relativePath = nextChunk;
                    }
                } else {
                    relativePath = nextChunk + "/" + relativePath;
                }
                nextChunk = path.getName();
            }
            TestGroup group = new TestGroup(this.rootGroup, entry.getKey(), relativePath, TestGroup.ClassType.ct_fileGrp);
            this.files.put(group.getGroupHash(), group);
            this.groups.put(group.getGroupHash(), group);
            this.rootGroup.addGroup(group);
            this.InitiateLoading(group, jContent, jSchema);
        }
    }

    private JsonElement getJSON(File jsonFile) throws IOException, InterruptedException, JsonIOException, JsonSyntaxException {
        JsonElement content = null;
        JsonParser parser = new JsonParser();
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);){
            content = parser.parse((Reader)reader);
        }
        return content;
    }

    private JsonElement getJSON(FilePath jsonFile) throws IOException, InterruptedException, JsonIOException, JsonSyntaxException {
        JsonElement content = null;
        JsonParser parser = new JsonParser();
        try (InputStreamReader reader = new InputStreamReader(jsonFile.read(), StandardCharsets.UTF_8);){
            content = parser.parse((Reader)reader);
        }
        return content;
    }

    private JsonElement getJSON(String sContent) throws JsonIOException, JsonSyntaxException {
        JsonParser parser = new JsonParser();
        JsonElement content = parser.parse(sContent);
        return content;
    }

    private void InitiateLoading(TestGroup group, JsonElement eContent, JsonElement eSchema) throws ValidationException {
        this.ProcessBlock(group, "__first__", eContent, eSchema, null);
    }

    private void ProcessBlock(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures oldFailures) throws ValidationException {
        if (eSchema.isJsonObject()) {
            JsonObject oSchema = eSchema.getAsJsonObject();
            MapJsonFailures failures = new MapJsonFailures(parent, eSchema, oldFailures);
            GroupTags type = this.getGroupTag(oSchema);
            block0 : switch (type) {
                case gt_result: {
                    boolean detResult = false;
                    for (Map.Entry entry : oSchema.entrySet()) {
                        if (!((String)entry.getKey()).equals("properties")) continue;
                        this.ProcessResult(parent, key, eContent, (JsonElement)entry.getValue(), failures);
                        detResult = true;
                        break;
                    }
                    if (detResult) break;
                    this.ProcessResultFull(parent, key, eContent, eSchema, failures, false);
                    break;
                }
                case gt_booleankey: {
                    this.ProcessResultFull(parent, key, eContent, eSchema, failures, true);
                    break;
                }
                case gt_threshold: {
                    for (Map.Entry entry : oSchema.entrySet()) {
                        if (!((String)entry.getKey()).equals("properties")) continue;
                        this.ProcessThreshold(parent, key, eContent, (JsonElement)entry.getValue(), failures);
                        break block0;
                    }
                    break;
                }
                case gt_parameter: {
                    boolean detParameter = false;
                    for (Map.Entry entry : oSchema.entrySet()) {
                        if (!((String)entry.getKey()).equals("properties")) continue;
                        this.ProcessParameter(parent, key, eContent, (JsonElement)entry.getValue(), failures);
                        detParameter = true;
                        break;
                    }
                    if (detParameter) break;
                    this.ProcessParameterFull(parent, key, eContent, eSchema, failures);
                    break;
                }
                case gt_object: {
                    for (Map.Entry entry : oSchema.entrySet()) {
                        if (!((String)entry.getKey()).equals("properties")) continue;
                        this.ProcessObject(parent, key, eContent, (JsonElement)entry.getValue(), failures);
                        break block0;
                    }
                    break;
                }
                case gt_array: {
                    for (Map.Entry entry : oSchema.entrySet()) {
                        if (!((String)entry.getKey()).equals("items")) continue;
                        this.ProcessArray(parent, key, eContent, (JsonElement)entry.getValue(), failures);
                        break block0;
                    }
                    break;
                }
            }
        }
    }

    private void ProcessThreshold(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        if (eContent.isJsonObject()) {
            JsonObject oSchema;
            MapJsonThreshold content;
            Threshold threshold;
            JsonObject oContent = eContent.getAsJsonObject();
            if (eSchema.isJsonObject() && (threshold = (content = new MapJsonThreshold(parent, key, oContent, oSchema = eSchema.getAsJsonObject())).getThreshold()) != null) {
                parent.addThreshold(threshold);
                this.checkThresholdType(threshold);
            }
        }
    }

    private void ProcessParameterFull(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        MapJsonParameterFull content = new MapJsonParameterFull(key, eContent);
        TestValue parameter = content.get(parent);
        if (parameter != null) {
            parent.addGroup(parameter);
            this.groups.put(parameter.getGroupHash(), parameter);
            this.parameters.put(parameter.getGroupHash(), parameter);
        }
    }

    private void ProcessParameter(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        if (eContent.isJsonObject()) {
            JsonObject oSchema;
            MapJsonParameter content;
            TestValue parameter;
            JsonObject oContent = eContent.getAsJsonObject();
            if (eSchema.isJsonObject() && (parameter = (content = new MapJsonParameter(parent, key, oContent, oSchema = eSchema.getAsJsonObject(), failures, this.truncateStrings)).getParameter()) != null) {
                parent.addGroup(parameter);
                this.groups.put(parameter.getGroupHash(), parameter);
                if (parameter.getClassType() == TestGroup.ClassType.ct_parameter) {
                    this.parameters.put(parameter.getGroupHash(), parameter);
                }
            }
        }
    }

    private void ProcessResultFull(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures, boolean booleankey) throws ValidationException {
        TestValue result = null;
        if (booleankey) {
            StringValue res = new StringValue(parent, null, key);
            res.setValue(key);
            res.setFailedState(failures.isFailure(key, true));
            result = res;
        } else {
            MapJsonResultFull content = new MapJsonResultFull(key, eContent);
            result = content.get(parent, failures);
        }
        if (result != null) {
            parent.addGroup(result);
            this.checkResult(result);
            this.groups.put(result.getGroupHash(), result);
            this.results.put(result.getGroupHash(), result);
        }
    }

    private void ProcessResult(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        if (eContent.isJsonObject()) {
            JsonObject oSchema;
            MapJsonResult content;
            TestValue result;
            JsonObject oContent = eContent.getAsJsonObject();
            if (eSchema.isJsonObject() && (result = (content = new MapJsonResult(parent, key, oContent, oSchema = eSchema.getAsJsonObject(), failures, this.truncateStrings)).getResult()) != null) {
                parent.addGroup(result);
                this.checkResult(result);
                this.groups.put(result.getGroupHash(), result);
                this.results.put(result.getGroupHash(), result);
                for (Map.Entry enSchema : oSchema.entrySet()) {
                    String kSchema = (String)enSchema.getKey();
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!kSchema.equals(enContent.getKey())) continue;
                        this.ProcessBlock(result, kSchema, (JsonElement)enContent.getValue(), (JsonElement)enSchema.getValue(), failures);
                    }
                }
            }
        }
    }

    private void ProcessObject(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        if (eContent.isJsonObject()) {
            JsonObject oSchema;
            MapJsonGroup content;
            TestGroup group;
            JsonObject oContent = eContent.getAsJsonObject();
            if (eSchema.isJsonObject() && (group = (content = new MapJsonGroup(parent, key, oContent, oSchema = eSchema.getAsJsonObject(), failures, this.truncateStrings)).getGroup()) != null) {
                parent.addGroup(group);
                this.groups.put(group.getGroupHash(), group);
                for (Map.Entry enSchema : oSchema.entrySet()) {
                    String kSchema = (String)enSchema.getKey();
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!kSchema.equals(enContent.getKey())) continue;
                        this.ProcessBlock(group, kSchema, (JsonElement)enContent.getValue(), (JsonElement)enSchema.getValue(), failures);
                    }
                }
                group.isParameterGrp();
                group.isThresholdGrp();
            }
        }
    }

    private void ProcessArray(TestGroup parent, String key, JsonElement eContent, JsonElement eSchema, MapJsonFailures failures) throws ValidationException {
        if (eContent.isJsonArray()) {
            TestGroup group;
            JsonArray aContent = eContent.getAsJsonArray();
            if (eSchema.isJsonObject() && (group = new TestGroup(parent, key, "Array", true)) != null) {
                parent.addGroup(group);
                this.groups.put(group.getGroupHash(), group);
                int index = 0;
                for (JsonElement enContent : aContent) {
                    String kSchema = Integer.toString(index);
                    if (enContent.isJsonObject()) {
                        this.ProcessBlock(group, kSchema, (JsonElement)enContent.getAsJsonObject(), eSchema, failures);
                    }
                    ++index;
                }
                group.isParameterGrp();
                group.isThresholdGrp();
            }
        }
    }

    private String FilePathToString(FilePath path) {
        String relativePath = null;
        String nextChunk = null;
        while (path != null && !path.getName().equalsIgnoreCase("workspace")) {
            if (relativePath == null) {
                if (nextChunk != null) {
                    relativePath = nextChunk;
                }
            } else {
                relativePath = nextChunk + "/" + (String)relativePath;
            }
            nextChunk = path.getName();
            path = path.getParent();
        }
        if (nextChunk != null) {
            relativePath = nextChunk + "/" + relativePath;
        }
        return relativePath;
    }

    private GroupTags getGroupTag(JsonObject oSchema) {
        String type = "";
        for (Map.Entry entrySchema : oSchema.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)entrySchema.getKey()).equals("type") || !(primitive = ((JsonElement)entrySchema.getValue()).getAsJsonPrimitive()).isString()) continue;
            type = primitive.getAsString();
            break;
        }
        type = type.toLowerCase();
        switch (type) {
            case "object": {
                return GroupTags.gt_object;
            }
            case "array": {
                return GroupTags.gt_array;
            }
            case "resultfull": {
                return GroupTags.gt_result;
            }
            case "result": {
                return GroupTags.gt_result;
            }
            case "booleankey": {
                return GroupTags.gt_booleankey;
            }
            case "threshold": {
                return GroupTags.gt_threshold;
            }
            case "parameterfull": {
                return GroupTags.gt_parameter;
            }
            case "parameter": {
                return GroupTags.gt_parameter;
            }
        }
        return GroupTags.gt_unknown;
    }

    static enum GroupTags {
        gt_unknown,
        gt_object,
        gt_array,
        gt_result,
        gt_booleankey,
        gt_threshold,
        gt_parameter;

    }
}

