/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.Messages;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.thresholds.AbsoluteThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.DeltaAverageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.DeltaThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.PercentageAverageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.PercentageThreshold;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;

public class MapJsonThreshold {
    private Double minimum;
    private Double maximum;
    private Double delta;
    private Double percentage;
    private Threshold threshold;

    MapJsonThreshold(TestGroup parent, String key, JsonObject oContent, JsonObject oSchema) throws ValidationException {
        ThresholdTags type = ThresholdTags.tt_unknown;
        block20: for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getThresholdTag(iSchemaObj);
            block0 : switch (type) {
                case tt_minimum: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.minimum != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isNumber()) {
                            this.minimum = primitive.getAsDouble();
                            break block0;
                        }
                        throw new ValidationException(Messages.MapJsonThreshold_WrongFormatForMinimum());
                    }
                    continue block20;
                }
                case tt_maximum: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.maximum != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isNumber()) {
                            this.maximum = primitive.getAsDouble();
                            break block0;
                        }
                        throw new ValidationException(Messages.MapJsonThreshold_WrongFormatForMaximum());
                    }
                    continue block20;
                }
                case tt_delta: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.delta != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isNumber()) {
                            this.delta = primitive.getAsDouble();
                            break block0;
                        }
                        throw new ValidationException(Messages.MapJsonThreshold_WrongFormatForDelta());
                    }
                    continue block20;
                }
                case tt_percentage: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.percentage != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                        primitive = value.getAsJsonPrimitive();
                        if (primitive.isNumber()) {
                            this.percentage = primitive.getAsDouble();
                            break block0;
                        }
                        throw new ValidationException(Messages.MapJsonThreshold_WrongFormatForPercentage());
                    }
                    break;
                }
            }
        }
        boolean thresholdDetected = false;
        for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getThresholdTag(iSchemaObj);
            if (type == ThresholdTags.tt_method) {
                for (Map.Entry enContent : oContent.entrySet()) {
                    String method;
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                    switch (method = primitive.getAsString().toLowerCase()) {
                        case "absolute": {
                            Threshold thres = new AbsoluteThreshold(this.minimum, this.maximum);
                            this.threshold = thres;
                            thresholdDetected = true;
                            break;
                        }
                        case "percentage": {
                            Threshold thres = new PercentageThreshold(this.percentage);
                            this.threshold = thres;
                            thresholdDetected = true;
                            break;
                        }
                        case "delta": {
                            Threshold thres = new DeltaThreshold(this.delta);
                            this.threshold = thres;
                            thresholdDetected = true;
                            break;
                        }
                        case "percentageaverage": {
                            Threshold thres = new PercentageAverageThreshold(this.percentage);
                            this.threshold = thres;
                            thresholdDetected = true;
                            break;
                        }
                        case "deltaaverage": {
                            Threshold thres = new DeltaAverageThreshold(this.delta);
                            this.threshold = thres;
                            thresholdDetected = true;
                            break;
                        }
                    }
                    break;
                }
            }
            if (!thresholdDetected) continue;
            break;
        }
    }

    private ThresholdTags getThresholdTag(JsonObject schemaObj) {
        String type = "";
        for (Map.Entry entrySchema : schemaObj.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)entrySchema.getKey()).equals("type") || !(primitive = ((JsonElement)entrySchema.getValue()).getAsJsonPrimitive()).isString()) continue;
            type = primitive.getAsString();
            break;
        }
        type = type.toLowerCase();
        switch (type) {
            case "method": {
                return ThresholdTags.tt_method;
            }
            case "minimum": {
                return ThresholdTags.tt_minimum;
            }
            case "maximum": {
                return ThresholdTags.tt_maximum;
            }
            case "delta": {
                return ThresholdTags.tt_delta;
            }
            case "percentage": {
                return ThresholdTags.tt_percentage;
            }
        }
        return ThresholdTags.tt_unknown;
    }

    public Threshold getThreshold() {
        return this.threshold;
    }

    static enum ThresholdTags {
        tt_unknown,
        tt_method,
        tt_minimum,
        tt_maximum,
        tt_delta,
        tt_percentage;

    }
}

