/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonFailures;
import org.jenkinsci.plugins.benchmark.results.BooleanValue;
import org.jenkinsci.plugins.benchmark.results.DoubleValue;
import org.jenkinsci.plugins.benchmark.results.StringValue;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.results.TestValue;

public class MapJsonParameter {
    private Integer id = null;
    private String name = null;
    private String description = null;
    private String unit = null;
    private Map<String, String> messages = new HashMap<String, String>();
    private TestValue parameter;

    MapJsonParameter(TestGroup parent, String key, JsonObject oContent, JsonObject oSchema, MapJsonFailures failures, boolean truncateStrings) {
        ParameterTags type = ParameterTags.pt_unknown;
        block7: for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getParameterTag(iSchemaObj);
            block0 : switch (type) {
                case pt_id: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.id != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isNumber()) continue;
                        this.id = primitive.getAsInt();
                        break block0;
                    }
                    continue block7;
                }
                case pt_name: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.name != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.name = primitive.getAsString();
                        this.name = this.name.replaceAll(" ", "_");
                        break block0;
                    }
                    continue block7;
                }
                case pt_description: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.description != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.description = primitive.getAsString();
                        if (!truncateStrings || this.description.length() <= 512) continue block7;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        break block0;
                    }
                    continue block7;
                }
                case pt_unit: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.unit != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.unit = primitive.getAsString();
                        break block0;
                    }
                    continue block7;
                }
                case pt_message: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        if (truncateStrings) {
                            Object message = primitive.getAsString();
                            if (((String)message).length() > 512) {
                                message = ((String)message).substring(0, 512);
                                message = (String)message + "...";
                            }
                            this.messages.put(schemaKey, (String)message);
                            break block0;
                        }
                        this.messages.put(schemaKey, primitive.getAsString());
                        break block0;
                    }
                    break;
                }
            }
        }
        boolean parameterDetected = false;
        for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getParameterTag(iSchemaObj);
            if (type == ParameterTags.pt_value) {
                for (Map.Entry enContent : oContent.entrySet()) {
                    TestValue res;
                    JsonElement value;
                    if (!schemaKey.equals(enContent.getKey())) continue;
                    if (this.name == null) {
                        this.name = Objects.requireNonNullElse(key, schemaKey);
                    }
                    if (!(value = (JsonElement)enContent.getValue()).isJsonPrimitive()) continue;
                    JsonPrimitive primitive = value.getAsJsonPrimitive();
                    if (primitive.isBoolean()) {
                        res = new BooleanValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                        ((BooleanValue)res).setValue(primitive.getAsBoolean());
                        this.parameter = res;
                        parameterDetected = true;
                        break;
                    }
                    if (primitive.isString()) {
                        res = new StringValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                        ((StringValue)res).setValue(primitive.getAsString());
                        this.parameter = res;
                        parameterDetected = true;
                        break;
                    }
                    if (!primitive.isNumber()) continue;
                    res = new DoubleValue(parent, null, this.name, this.description, this.unit, TestGroup.ClassType.ct_parameter);
                    ((DoubleValue)res).setValue(primitive.getAsDouble());
                    this.parameter = res;
                    parameterDetected = true;
                    break;
                }
            }
            if (!parameterDetected) continue;
            break;
        }
        if (parameterDetected) {
            this.parameter.setMessages(this.messages);
        }
    }

    private ParameterTags getParameterTag(JsonObject schemaObj) {
        String type = "";
        for (Map.Entry entrySchema : schemaObj.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)entrySchema.getKey()).equals("type") || !(primitive = ((JsonElement)entrySchema.getValue()).getAsJsonPrimitive()).isString()) continue;
            type = primitive.getAsString();
            break;
        }
        type = type.toLowerCase();
        switch (type) {
            case "id": {
                return ParameterTags.pt_id;
            }
            case "name": {
                return ParameterTags.pt_name;
            }
            case "description": {
                return ParameterTags.pt_description;
            }
            case "unit": {
                return ParameterTags.pt_unit;
            }
            case "value": {
                return ParameterTags.pt_value;
            }
            case "message": {
                return ParameterTags.pt_message;
            }
        }
        return ParameterTags.pt_unknown;
    }

    public TestValue getParameter() {
        return this.parameter;
    }

    private static enum ParameterTags {
        pt_unknown,
        pt_id,
        pt_name,
        pt_description,
        pt_unit,
        pt_value,
        pt_message;

    }
}

