/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonFailures;
import org.jenkinsci.plugins.benchmark.results.TestGroup;

public class MapJsonGroup {
    private String name = null;
    private String description = null;
    private TestGroup group = null;

    MapJsonGroup(TestGroup parent, String key, JsonObject oContent, JsonObject oSchema, MapJsonFailures failures, boolean truncateStrings) {
        GroupTags type = GroupTags.gt_unknown;
        block4: for (Map.Entry enSchema : oSchema.entrySet()) {
            String schemaKey = (String)enSchema.getKey();
            JsonElement schemaValue = (JsonElement)enSchema.getValue();
            if (!schemaValue.isJsonObject()) continue;
            JsonObject iSchemaObj = schemaValue.getAsJsonObject();
            type = this.getGroupTag(iSchemaObj);
            block0 : switch (type) {
                case gt_name: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.name != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.name = primitive.getAsString();
                        this.name = this.name.replaceAll(" ", "_");
                        break block0;
                    }
                    continue block4;
                }
                case gt_description: {
                    JsonPrimitive primitive;
                    JsonElement value;
                    if (this.description != null) break;
                    for (Map.Entry enContent : oContent.entrySet()) {
                        if (!schemaKey.equals(enContent.getKey()) || !(value = (JsonElement)enContent.getValue()).isJsonPrimitive() || !(primitive = value.getAsJsonPrimitive()).isString()) continue;
                        this.description = primitive.getAsString();
                        if (!truncateStrings || this.description.length() <= 512) break block0;
                        this.description = this.description.substring(0, 512);
                        this.description = this.description + "...";
                        break block0;
                    }
                    break;
                }
            }
        }
        if (this.name == null) {
            this.name = key;
        }
        this.group = new TestGroup(parent, this.name, this.description);
    }

    private GroupTags getGroupTag(JsonObject schemaObj) {
        String type = "";
        for (Map.Entry entrySchema : schemaObj.entrySet()) {
            JsonPrimitive primitive;
            if (!((String)entrySchema.getKey()).equals("type") || !(primitive = ((JsonElement)entrySchema.getValue()).getAsJsonPrimitive()).isString()) continue;
            type = primitive.getAsString();
            break;
        }
        if ((type = type.toLowerCase()).equals("name")) {
            return GroupTags.gt_name;
        }
        if (type.equals("description")) {
            return GroupTags.gt_description;
        }
        return GroupTags.gt_unknown;
    }

    public TestGroup getGroup() {
        return this.group;
    }

    private static enum GroupTags {
        gt_unknown,
        gt_name,
        gt_description;

    }
}

