/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.JsonToPlugin.MapJsonToPlugin;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.parsers.Messages;
import org.jenkinsci.plugins.benchmark.parsers.XmlToPlugin.MapXmlToPlugin;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FormatSelector {
    MapperBase mapper;

    public FormatSelector(Run<?, ?> run, FilePath filePath, String searchFilePattern, String schema, boolean truncateStrings, TaskListener listener) throws InterruptedException, ValidationException, IOException {
        if (schema == null || schema.length() == 0) {
            throw new IOException(Messages.FormatSelector_SchemaIsEmpty());
        }
        if (searchFilePattern == null || searchFilePattern.length() == 0) {
            throw new IOException(Messages.FormatSelector_FileSearchPatternIsEmpty());
        }
        JsonElement jSchema = null;
        Document xSchema = null;
        try {
            jSchema = FormatSelector.getJSON(schema);
        }
        catch (Exception e) {
            try {
                xSchema = FormatSelector.getXML(schema);
            }
            catch (Exception e2) {
                throw new IOException(Messages.FormatSelector_NoCompatibleSchemaFromatRecognised());
            }
        }
        if (!filePath.isDirectory()) {
            listener.getLogger().println(Messages.FormatSelector_WorkspaceNotDetected());
            throw new IOException(Messages.FormatSelector_WorkspaceNotDetected());
        }
        int buildNumber = run.getNumber();
        if (jSchema != null) {
            Map<String, FilePath> files;
            try {
                listener.getLogger().println(Messages.FormatSelector_FilePattern(searchFilePattern));
                files = FormatSelector.IdentifyFiles(filePath, searchFilePattern, "json");
            }
            catch (Exception e) {
                throw new ValidationException(Messages.FormatSelector_FilePatternCannotBeParsed(searchFilePattern));
            }
            if (files.size() == 0) {
                throw new IOException(Messages.FormatSelector_NoJsonDetectedInFilePattern(searchFilePattern));
            }
            MapJsonToPlugin plugin = null;
            if (files.size() == 1) {
                Iterator<Map.Entry<String, FilePath>> iterator = files.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, FilePath> file = iterator.next();
                    plugin = new MapJsonToPlugin((Integer)buildNumber, file.getValue(), jSchema, truncateStrings);
                }
            } else {
                plugin = new MapJsonToPlugin(buildNumber, files, jSchema, truncateStrings, listener);
            }
            this.mapper = plugin;
            return;
        }
        if (xSchema != null) {
            Map<String, FilePath> files;
            try {
                listener.getLogger().println(Messages.FormatSelector_FilePattern(searchFilePattern));
                files = FormatSelector.IdentifyFiles(filePath, searchFilePattern, "xml");
            }
            catch (Exception e) {
                throw new ValidationException(Messages.FormatSelector_FilePatternCannotBeParsed(searchFilePattern));
            }
            if (files.size() == 0) {
                throw new IOException(Messages.FormatSelector_NoXmlDetectedInFilePattern(searchFilePattern));
            }
            MapXmlToPlugin plugin = null;
            if (files.size() == 1) {
                Iterator<Map.Entry<String, FilePath>> iterator = files.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry<String, FilePath> file = iterator.next();
                    plugin = new MapXmlToPlugin((Integer)buildNumber, file.getValue(), xSchema, truncateStrings);
                }
            } else {
                plugin = new MapXmlToPlugin(buildNumber, files, xSchema, truncateStrings, listener);
            }
            this.mapper = plugin;
        }
    }

    public static void checkFormat(String schema) throws IOException {
        try {
            FormatSelector.getJSON(schema);
        }
        catch (Exception e) {
            try {
                FormatSelector.getXML(schema);
            }
            catch (Exception e2) {
                throw new IOException(Messages.FormatSelector_NoCompatibleSchemaFromatRecognised());
            }
        }
    }

    public static Map<String, FilePath> IdentifyFiles(FilePath fileBase, String searchFilePattern, String extension) throws IOException, InterruptedException {
        String[] individuals = searchFilePattern.split("\\;|\\,");
        ArrayList<String[]> listOfLists = new ArrayList<String[]>();
        ArrayList<String[]> listChunks = new ArrayList<String[]>();
        for (String individual : individuals) {
            String[] chunks = individual.split("\\\\|\\/");
            if (FormatSelector.isFileWithExtension(individual, "list")) {
                listOfLists.add(chunks);
                continue;
            }
            listChunks.add(chunks);
        }
        Map<String, FilePath> listFiles = FormatSelector.processChunks(fileBase, "", "", 0, listOfLists, "list");
        for (Map.Entry<String, FilePath> entry : listFiles.entrySet()) {
            String[] addIndividuals;
            InputStream inputStream = entry.getValue().read();
            String content = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            inputStream.close();
            for (String individual : addIndividuals = content.split("\\;|\\,|\\r?\\n")) {
                if (individual.isEmpty()) continue;
                String[] chunks = individual.split("\\\\|\\/");
                listChunks.add(chunks);
            }
        }
        return FormatSelector.processChunks(fileBase, "", "", 0, listChunks, extension);
    }

    private static Map<String, FilePath> processChunks(FilePath fileBase, String shortName, String pathName, int index, List<String[]> listChunks, String extension) throws IOException, InterruptedException {
        int numOriginal = listChunks.size();
        HashMap<String, FilePath> result = new HashMap<String, FilePath>();
        for (String[] individual : listChunks) {
            if (individual.length < index + 1) continue;
            ArrayList<String[]> list = new ArrayList<String[]>();
            String marker = individual[index];
            for (String[] individual_2 : listChunks) {
                if (individual_2.length <= index || !marker.equals(individual_2[index])) continue;
                list.add(individual_2);
            }
            if (list.size() == 0) break;
            if (marker.contains("*")) {
                String[] pieces = marker.split("\\*");
                FilePath path = new FilePath(fileBase, pathName);
                List files = path.list();
                for (FilePath file : files) {
                    boolean detectedField = false;
                    String name = file.getName();
                    Object nextShortName = shortName;
                    String nextPathName = pathName + "\\" + name;
                    int baseIndex = 0;
                    for (String piece : pieces) {
                        int newIndex = name.indexOf(piece, baseIndex);
                        if (newIndex == -1) {
                            nextShortName = null;
                            break;
                        }
                        if (baseIndex != newIndex) {
                            detectedField = true;
                        }
                        baseIndex = newIndex + piece.length();
                    }
                    if (nextShortName != null && baseIndex < name.length()) {
                        detectedField = true;
                    }
                    if (detectedField) {
                        nextShortName = ((String)nextShortName).length() == 0 ? name : (String)nextShortName + "\\" + name;
                    }
                    if (nextShortName == null) continue;
                    for (String[] individual_2 : list) {
                        String[] newIndividual = (String[])individual_2.clone();
                        newIndividual[index] = file.getName();
                    }
                    FilePath nextFile = new FilePath(fileBase, nextPathName);
                    if (nextFile.isDirectory()) {
                        result.putAll(FormatSelector.processChunks(fileBase, (String)nextShortName, nextPathName, index + 1, list, extension));
                        continue;
                    }
                    if (!file.exists() || !FormatSelector.isFileWithExtension(nextFile, extension)) continue;
                    result.put((String)nextShortName, nextFile);
                }
                continue;
            }
            Object nextShortName = shortName;
            if (numOriginal != list.size()) {
                nextShortName = ((String)nextShortName).length() == 0 ? (String)nextShortName + marker : (String)nextShortName + "\\" + marker;
            }
            Object nextPathName = "";
            nextPathName = pathName.length() == 0 ? marker : pathName + "\\" + marker;
            FilePath file = new FilePath(fileBase, (String)nextPathName);
            if (file.isDirectory()) {
                result.putAll(FormatSelector.processChunks(fileBase, (String)nextShortName, (String)nextPathName, index + 1, list, extension));
                continue;
            }
            if (!file.exists() || !FormatSelector.isFileWithExtension(file, extension)) continue;
            result.put((String)nextShortName, file);
        }
        return result;
    }

    private static boolean isFileWithExtension(String file, String extension) {
        try {
            return extension.equalsIgnoreCase(file.substring(file.lastIndexOf(".") + 1));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isFileWithExtension(FilePath file, String extension) {
        String name = file.getName();
        try {
            return extension.equalsIgnoreCase(name.substring(name.lastIndexOf(".") + 1));
        }
        catch (Exception e) {
            return false;
        }
    }

    private static JsonElement getJSON(String sContent) throws JsonIOException, JsonSyntaxException {
        JsonParser parser = new JsonParser();
        JsonElement content = parser.parse(sContent);
        return content;
    }

    private static Document getXML(String xmlContent) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", Boolean.TRUE);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", Boolean.FALSE);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", Boolean.FALSE);
        factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
        factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        factory.setExpandEntityReferences(false);
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new StringReader(xmlContent)));
    }

    public MapperBase getMapper() {
        return this.mapper;
    }
}

