/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.core;

import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.benchmark.core.BenchmarkProjectAction;
import org.jenkinsci.plugins.benchmark.core.BenchmarkResultAction;
import org.jenkinsci.plugins.benchmark.core.Messages;
import org.jenkinsci.plugins.benchmark.exceptions.ValidationException;
import org.jenkinsci.plugins.benchmark.parsers.FormatSelector;
import org.jenkinsci.plugins.benchmark.parsers.JUnitJenkins;
import org.jenkinsci.plugins.benchmark.parsers.MapperBase;
import org.jenkinsci.plugins.benchmark.schemas.Schema;
import org.jenkinsci.plugins.benchmark.thresholds.Threshold;
import org.jenkinsci.plugins.benchmark.thresholds.ThresholdDescriptor;
import org.jenkinsci.plugins.benchmark.utilities.ResetMemoryTask;
import org.jenkinsci.plugins.benchmark.utilities.RunnableJenkinsReader;
import org.jenkinsci.plugins.benchmark.utilities.RunnableReader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class BenchmarkPublisher
extends Recorder
implements SimpleBuildStep {
    private static final Map<String, Schema> schemaResources = new HashMap<String, Schema>();
    public static final int TIME_DELAY_MS = 120000;
    private static final Logger log;
    private final String inputLocation;
    private final String schemaSelection;
    private final Boolean truncateStrings;
    private final String altInputSchema;
    private final String altInputSchemaLocation;
    private List<? extends Threshold> altThresholds;
    private transient MapperBase map;
    private transient Timer timer;
    private transient Integer selectedResult;
    private transient Integer selectedBuild;

    @DataBoundConstructor
    public BenchmarkPublisher(String inputLocation, String schemaSelection, Boolean truncateStrings, String altInputSchema, String altInputSchemaLocation) {
        this.inputLocation = inputLocation;
        this.schemaSelection = schemaSelection;
        this.truncateStrings = truncateStrings;
        this.altInputSchema = altInputSchema;
        this.altInputSchemaLocation = altInputSchemaLocation;
        this.altThresholds = new ArrayList<Threshold>();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        boolean failed;
        block13: {
            Job project = run.getParent();
            run.addAction((Action)new BenchmarkProjectAction(project, this));
            run.addAction((Action)new BenchmarkResultAction(project, this));
            failed = false;
            taskListener.getLogger().println(Messages.BenchmarkPublisher_CollectionOfResultsStarted());
            try {
                String schemaText;
                Integer buildNumber = run.getNumber();
                String projectName = run.getParent().getName();
                if (this.inputLocation == null || this.inputLocation.isEmpty()) {
                    MapperBase mapper = this.getRawResults(run);
                    if (mapper != null) {
                        String oFilename = run.getParent().getRootDir().getAbsolutePath() + File.separator + "BenchmarkCondensed.json";
                        mapper.exportCondensedToFile(oFilename, projectName, buildNumber);
                    }
                    break block13;
                }
                if (this.schemaSelection.contains("customSchema")) {
                    if (this.altInputSchema == null || this.altInputSchema.isEmpty()) {
                        if (this.altInputSchemaLocation == null || this.altInputSchemaLocation.isEmpty()) {
                            taskListener.getLogger().println(Messages.BenchmarkPublisher_CustomSchemaEmpty());
                            throw new IOException(Messages.BenchmarkPublisher_CustomSchemaEmpty());
                        }
                        File file = new File(this.altInputSchemaLocation);
                        FilePath newFilePath = new FilePath(file);
                        if (!newFilePath.exists()) {
                            taskListener.getLogger().println(Messages.BenchmarkPublisher_CustomSchemaFileNotDetected());
                            throw new IOException(Messages.BenchmarkPublisher_CustomSchemaFileNotDetected());
                        }
                        InputStream inputStream = newFilePath.read();
                        schemaText = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        inputStream.close();
                    } else {
                        schemaText = this.altInputSchema;
                    }
                } else {
                    Schema schema = schemaResources.get(this.schemaSelection);
                    if (schema == null) {
                        taskListener.getLogger().println(Messages.BenchmarkPublisher_SelectedSchemaDoesNotExist());
                        throw new IOException(Messages.BenchmarkPublisher_SelectedSchemaDoesNotExist());
                    }
                    Object schemaAddress = schema.getLocation();
                    schemaAddress = this.inputLocation.contains(".xml") ? (String)schemaAddress + ".xml" : (String)schemaAddress + ".json";
                    ClassLoader classLoader = ((Object)((Object)this)).getClass().getClassLoader();
                    InputStream fileStream = classLoader.getResource((String)schemaAddress).openStream();
                    schemaText = IOUtils.toString((InputStream)fileStream, (Charset)StandardCharsets.UTF_8);
                    fileStream.close();
                }
                FormatSelector selector = new FormatSelector(run, filePath, this.inputLocation, schemaText, this.truncateStrings, taskListener);
                MapperBase mapper = selector.getMapper();
                if (this.altThresholds.size() > 0) {
                    mapper.addAllThresholds(this.altThresholds);
                }
                MapperBase base = this.getRawResults(run);
                failed = mapper.checkThresholds(base);
                mapper.logKeyData(taskListener, this.altThresholds.size());
                String outputFilename = run.getRootDir().getAbsolutePath() + File.separator + "BenchmarkResult.json";
                mapper.exportToFile(outputFilename, projectName, buildNumber);
                mapper.mergeWith(base);
                String oFilename = run.getParent().getRootDir().getAbsolutePath() + File.separator + "BenchmarkCondensed.json";
                mapper.exportCondensedToFile(oFilename, projectName, buildNumber);
            }
            catch (ValidationException e) {
                taskListener.getLogger().println(e.getMessage());
                taskListener.getLogger().println(Messages.BenchmarkPublisher_ErrorDetectedDuringPostBuild());
                run.setResult(Result.FAILURE);
                return;
            }
        }
        if (failed) {
            taskListener.getLogger().println(Messages.BenchmarkPublisher_CollectionSuccessButValidationFailure());
            run.setResult(Result.UNSTABLE);
            return;
        }
        taskListener.getLogger().println(Messages.BenchmarkPublisher_PluginSuccessfull());
    }

    public Boolean hasResults(Run run) throws NullPointerException, FileNotFoundException, JsonIOException, JsonSyntaxException {
        String condensedFilename = run.getParent().getRootDir().getAbsolutePath() + File.separator + "BenchmarkCondensed.json";
        File oFile = new File(condensedFilename);
        return oFile.exists();
    }

    public MapperBase getRawResults(Run<?, ?> run) throws NullPointerException, InterruptedException, ValidationException, IOException, JsonIOException, JsonSyntaxException {
        Run startRun;
        Job project = run.getParent();
        if (this.inputLocation == null || this.inputLocation.isEmpty()) {
            Run startRun2;
            JUnitJenkins mapper = new JUnitJenkins((Integer)run.getNumber(), (boolean)this.truncateStrings);
            StringBuffer condensedFilename = new StringBuffer();
            condensedFilename.append(run.getParent().getRootDir().getAbsolutePath());
            condensedFilename.append(File.separator);
            condensedFilename.append("BenchmarkCondensed.json");
            mapper.importCondensedFromFile(condensedFilename.toString());
            while (run != null && run.getNumber() != mapper.getBuild().intValue()) {
                StringBuffer rawFilename = new StringBuffer();
                rawFilename.append(run.getRootDir().getAbsolutePath());
                rawFilename.append(File.separator);
                rawFilename.append("junitResult.xml");
                mapper.importFromFile((Integer)run.getNumber(), rawFilename.toString());
                run = run.getPreviousBuild();
            }
            if (run == null) {
                return mapper;
            }
            int cores = Runtime.getRuntime().availableProcessors() - 1;
            if (cores < 1) {
                cores = 1;
            }
            Run firstRun = project.getFirstBuild();
            int numberOfRuns = run.getNumber() - firstRun.getNumber();
            int runsPerSegment = 4;
            if (numberOfRuns > cores * 4) {
                runsPerSegment = numberOfRuns / cores;
            }
            ExecutorService server = Executors.newFixedThreadPool(cores);
            Run endRun = startRun2 = run;
            do {
                for (int i = 0; i < runsPerSegment && endRun != null; endRun = endRun.getPreviousBuild(), ++i) {
                }
                server.execute(new RunnableJenkinsReader(startRun2, endRun, mapper));
            } while ((startRun2 = endRun) != null);
            server.shutdown();
            server.awaitTermination(5L, TimeUnit.MINUTES);
            return mapper;
        }
        MapperBase mapper = new MapperBase(run.getNumber(), this.truncateStrings);
        StringBuffer condensedFilename = new StringBuffer(run.getParent().getRootDir().getAbsolutePath());
        condensedFilename.append(File.separator);
        condensedFilename.append("BenchmarkCondensed.json");
        if (!mapper.importCondensedFromFile(condensedFilename.toString())) {
            return null;
        }
        while (run != null && run.getNumber() != mapper.getBuild().intValue()) {
            run = run.getPreviousBuild();
        }
        if (run == null) {
            return mapper;
        }
        int cores = Runtime.getRuntime().availableProcessors() - 1;
        if (cores < 1) {
            cores = 1;
        }
        Run firstRun = project.getFirstBuild();
        int numberOfRuns = run.getNumber() - firstRun.getNumber();
        int runsPerSegment = 4;
        if (numberOfRuns > cores * 4) {
            runsPerSegment = numberOfRuns / cores;
        }
        ExecutorService server = Executors.newFixedThreadPool(cores);
        Run endRun = startRun = run;
        do {
            for (int i = 0; i < runsPerSegment && endRun != null; endRun = endRun.getPreviousBuild(), ++i) {
            }
            server.execute(new RunnableReader(startRun, endRun, mapper));
        } while ((startRun = endRun) != null);
        server.shutdown();
        server.awaitTermination(5L, TimeUnit.MINUTES);
        return mapper;
    }

    public void fillAllResults(Job project) {
        try {
            this.resetClock();
            Run run = project.getLastBuild();
            if (run != null) {
                MapperBase base = this.getMapper(run);
                base.setBuild(run.getNumber());
            }
        }
        catch (Exception e) {
            log.info(Messages.BenchmarkPublisher_ResultCollectionErrorDetected());
            log.info(Messages.BenchmarkPublisher_ResultCollectionErrorMessage(e.getMessage()));
        }
    }

    public void resetClock() {
        Timer timer = this.getTimer();
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer();
        this.setTimer(timer);
        ResetMemoryTask task = new ResetMemoryTask(this);
        timer.schedule((TimerTask)task, 120000L);
    }

    public void resetMemory() {
        this.map = null;
        Timer timer = this.getTimer();
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        System.gc();
    }

    @DataBoundSetter
    public void setThresholds(List<? extends Threshold> thresholds) {
        this.altThresholds = thresholds;
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public void setSelectedResult(Integer selectedResult) {
        this.selectedResult = selectedResult;
    }

    public void setSelectedBuild(Integer selectedBuild) {
        this.selectedBuild = selectedBuild;
    }

    public void setMapper(MapperBase mapper) {
        this.map = mapper;
    }

    public String getInputLocation() {
        return this.inputLocation;
    }

    public String getSchemaSelection() {
        return this.schemaSelection;
    }

    public Boolean getTruncateStrings() {
        return this.truncateStrings;
    }

    public String getAltInputSchema() {
        return this.altInputSchema;
    }

    public String getAltInputSchemaLocation() {
        return this.altInputSchemaLocation;
    }

    public List<? extends Threshold> getThresholds() {
        return this.altThresholds;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Integer getSelectedResult() {
        return this.selectedResult;
    }

    public Integer getSelectedBuild() {
        return this.selectedBuild;
    }

    public MapperBase getMapper() {
        return this.map;
    }

    public MapperBase getMapper(Run run) throws NullPointerException, InterruptedException, ValidationException, IOException, JsonIOException, JsonSyntaxException {
        MapperBase base = this.map;
        if (base == null || run.getNumber() != base.getBuild().intValue()) {
            this.map = base = this.getRawResults(run);
        }
        return base;
    }

    static {
        schemaResources.put("defaultSchema", new Schema(Messages.BenchmarkPublisher_Default(), "schemas/default", Messages.BenchmarkPublisher_DefaultSchemaDescription(), 6));
        schemaResources.put("simplestSchema", new Schema(Messages.BenchmarkPublisher_Simplest(), "schemas/simplest", Messages.BenchmarkPublisher_SimplestSchemaDescription(), 6));
        log = Logger.getLogger(BenchmarkPublisher.class.getName());
    }

    @Extension
    @Symbol(value={"benchmark"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.BenchmarkPublisher_DisplayName();
        }

        public List<ThresholdDescriptor> getThresholdDescriptors() {
            return ThresholdDescriptor.all();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }

        public ListBoxModel doFillSchemaSelectionItems() {
            ListBoxModel items = new ListBoxModel();
            for (Map.Entry<String, Schema> schema : schemaResources.entrySet()) {
                items.add(schema.getValue().getDisplayName(), schema.getKey());
            }
            items.add(Messages.BenchmarkPublisher_Custom(), "customSchema");
            return items;
        }

        public FormValidation doCheckAltInputSchema(@QueryParameter String altInputSchema) {
            if (altInputSchema == null || altInputSchema.isEmpty()) {
                return FormValidation.ok();
            }
            try {
                FormatSelector.checkFormat(altInputSchema);
                return FormValidation.ok();
            }
            catch (Exception e) {
                return FormValidation.error((String)Messages.BenchmarkPublisher_ContentDoesNotComplyWithFormat());
            }
        }
    }
}

