/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.benchmark.condensed;

import org.jenkinsci.plugins.benchmark.results.IntegerValue;
import org.jenkinsci.plugins.benchmark.results.Messages;
import org.jenkinsci.plugins.benchmark.results.TestGroup;
import org.jenkinsci.plugins.benchmark.utilities.ContentDetected;

public class IntegerCondensed
extends IntegerValue {
    private final Integer previous;
    private final Integer minimum;
    private final Integer maximum;
    private final Double average;
    private final Double std_deviation;
    private final int passed;
    private final int failed;

    public IntegerCondensed(TestGroup parent, String group, String name, String description, String unit, Integer previous, Integer minimum, Integer maximum, Double average, Double std_deviation, int passed, int failed) {
        super(parent, group, name, description, unit);
        this.previous = previous;
        this.minimum = minimum;
        this.maximum = maximum;
        this.average = average;
        this.std_deviation = std_deviation;
        this.passed = passed;
        this.failed = failed;
    }

    @Override
    public String getHTMLCondensed(Integer key, ContentDetected detected, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        content.append("<tr><td>");
        if (detected.isFileDetected().booleanValue()) {
            if (this.parent == null) {
                content.append("</td><td>");
            } else {
                content.append(this.parent.getName());
                content.append("</td><td>");
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.group == null) {
                content.append("</td><td>");
            } else {
                content.append(this.group);
                content.append("</td><td>");
            }
        }
        content.append(this.getName());
        content.append("</td><td>");
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit == null) {
                content.append("-</td><td>");
            } else {
                content.append(this.unit);
                content.append("</td><td>");
            }
        }
        content.append(key.toString());
        content.append("</td><td>");
        if (this.average != null) {
            content.append(this.minimum.toString().replace('.', decimalSeparator));
            content.append("</td><td>");
            content.append(this.maximum.toString().replace('.', decimalSeparator));
            content.append("</td><td>");
            content.append(String.format("%f", this.average));
            content.append("</td><td>");
            content.append(String.format("%f", this.std_deviation));
            content.append("</td><td>");
        }
        content.append(Integer.toString(this.passed));
        content.append("</td><td>");
        content.append(Integer.toString(this.failed));
        content.append("</td></tr>");
        return content.toString();
    }

    @Override
    public String getHTMLCondensedDetail(ContentDetected detected, char decimalSeparator) {
        StringBuffer content = new StringBuffer();
        if (this.average != null) {
            content.append("<tr><td>");
            content.append(Messages.Minimum());
            content.append("</td><td>");
            content.append(Integer.toString(this.minimum));
            content.append("</td></tr><tr><td>");
            content.append(Messages.Maximum());
            content.append("</td><td>");
            content.append(Integer.toString(this.maximum));
            content.append("</td></tr><tr><td>");
            content.append(Messages.MeanAverage());
            content.append("</td><td>");
            content.append(String.format("%6g", this.average));
            content.append("</td></tr><tr><td>");
            content.append(Messages.StdDeviation());
            content.append("</td><td>");
            content.append(String.format("%6g", this.std_deviation));
            content.append("</td></tr>");
        }
        content.append("<tr><td>");
        content.append(Messages.NumberOFPassedTests());
        content.append("</td><td>");
        content.append(Integer.toString(this.passed));
        content.append("</td></tr><tr><td>");
        content.append(Messages.NumberOfFailedTests());
        content.append("</td><td>");
        content.append(Integer.toString(this.failed));
        content.append("</td></tr>");
        return content.toString();
    }

    @Override
    public String getCSVCondensed(ContentDetected detected) {
        StringBuffer content = new StringBuffer();
        if (detected.isFileDetected().booleanValue()) {
            if (this.parent == null) {
                content.append(',');
            } else {
                content.append(this.parent.getName());
                content.append(',');
            }
        }
        if (detected.isGroupDetected().booleanValue()) {
            if (this.group == null) {
                content.append(',');
            } else {
                content.append(this.group);
                content.append(',');
            }
        }
        content.append(this.getName());
        if (detected.isUnitsDetected().booleanValue()) {
            if (this.unit == null) {
                content.append(",-");
            } else {
                content.append(',');
                content.append(this.unit);
            }
        }
        if (this.average != null) {
            content.append(',');
            content.append(this.minimum.toString());
            content.append(',');
            content.append(this.maximum.toString());
            content.append(',');
            content.append(this.average.toString());
            content.append(',');
            content.append(this.std_deviation.toString());
        }
        content.append(',');
        content.append(Integer.toString(this.passed));
        content.append(',');
        content.append(Integer.toString(this.failed));
        return content.toString();
    }

    public Integer getPrevious() {
        return this.previous;
    }

    public Double getAverage() {
        return this.average;
    }

    public Double getStdDeviation() {
        return this.std_deviation;
    }

    @Override
    public Double getMinimum() {
        return this.minimum.doubleValue();
    }

    @Override
    public Double getMaximum() {
        return this.maximum.doubleValue();
    }

    public int getPassed() {
        return this.passed;
    }

    public int getFailed() {
        return this.failed;
    }
}

