/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat.workflow;

import hudson.AbortException;
import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import jenkins.plugins.bearychat.BearyChatNotifier;
import jenkins.plugins.bearychat.BearyChatService;
import jenkins.plugins.bearychat.Messages;
import jenkins.plugins.bearychat.StandardBearyChatService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class BearyChatSendStep
extends AbstractStepImpl {
    private String message;
    private String notification;
    private String title;
    private String url;
    private String attachmentText;
    private String color;
    private String channel;
    private String webhook;
    private boolean failOnError;

    public String getMessage() {
        return this.message;
    }

    public String getAttachmentText() {
        return this.attachmentText;
    }

    @DataBoundSetter
    public void setAttachmentText(String text) {
        this.attachmentText = Util.fixEmpty((String)text);
    }

    public String getTitle() {
        return this.title;
    }

    public String getNotification() {
        return this.notification;
    }

    @DataBoundSetter
    public void setNotification(String notification) {
        this.notification = notification;
    }

    @DataBoundSetter
    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    @DataBoundSetter
    public void setUrl(String url) {
        this.url = url;
    }

    public String getColor() {
        return this.color;
    }

    @DataBoundSetter
    public void setColor(String color) {
        this.color = Util.fixEmpty((String)color);
    }

    public String getWebhook() {
        return this.webhook;
    }

    @DataBoundSetter
    public void setWebhook(String webhook) {
        this.webhook = Util.fixEmpty((String)webhook);
    }

    public String getChannel() {
        return this.channel;
    }

    @DataBoundSetter
    public void setChannel(String channel) {
        this.channel = Util.fixEmpty((String)channel);
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @DataBoundConstructor
    public BearyChatSendStep(@Nonnull String message) {
        this.message = message;
    }

    public static class BearyChatSendStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        transient BearyChatSendStep step;
        @StepContextParameter
        transient TaskListener listener;

        protected JSONObject buildData(String message, String title, String attachmenText, String notification, String url, String color) {
            JSONObject data = new JSONObject();
            JSONObject attachment = new JSONObject();
            JSONArray attachments = new JSONArray();
            if (title != null) {
                attachment.put("title", (Object)title);
            }
            if (attachmenText != null) {
                attachment.put("text", (Object)attachmenText);
            }
            if (color != null) {
                attachment.put("color", (Object)color);
            }
            if (url != null) {
                attachment.put("url", (Object)url);
            }
            attachments.add((Object)attachment);
            if (message != null) {
                data.put("text", (Object)message);
            }
            if (notification != null) {
                data.put("fallback", (Object)notification);
            }
            data.put("attachments", (Object)attachments);
            return data;
        }

        protected Void run() throws Exception {
            Jenkins jenkins;
            try {
                jenkins = Jenkins.getInstance();
            }
            catch (NullPointerException ne) {
                this.listener.error(Messages.NotificationFailedWithException(ne));
                return null;
            }
            if (jenkins == null) {
                return null;
            }
            BearyChatNotifier.DescriptorImpl bearychatDesc = (BearyChatNotifier.DescriptorImpl)jenkins.getDescriptorByType(BearyChatNotifier.DescriptorImpl.class);
            String webhook = this.step.getWebhook() != null ? this.step.getWebhook() : bearychatDesc.getWebhook();
            String channel = this.step.getChannel() != null ? this.step.getChannel() : bearychatDesc.getChannel();
            String color = this.step.getColor() != null ? this.step.getColor() : "#808080";
            String message = this.step.getMessage();
            String url = this.step.getUrl();
            String title = this.step.getTitle();
            String notifition = this.step.getNotification();
            String attachmentText = this.step.getAttachmentText();
            Boolean failOnError = this.step.isFailOnError();
            JSONObject data = this.buildData(message, title, attachmentText, notifition, url, color);
            this.listener.getLogger().println(Messages.BearyChatSendStepConfig(webhook, channel));
            BearyChatService bearychatService = this.getBearyChatService(webhook, channel);
            boolean publishSuccess = bearychatService.publish(data);
            if (!publishSuccess && failOnError.booleanValue()) {
                throw new AbortException(Messages.NotificationFailed());
            }
            if (!publishSuccess) {
                this.listener.error(Messages.NotificationFailed());
            }
            return null;
        }

        BearyChatService getBearyChatService(String webhook, String channel) {
            return new StandardBearyChatService(webhook, channel);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(BearyChatSendStepExecution.class);
        }

        public String getFunctionName() {
            return "bearychatSend";
        }

        public String getDisplayName() {
            return Messages.BearyChatSendStepDisplayName();
        }
    }
}

