/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.bearychat;

import hudson.EnvVars;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Cause;
import hudson.model.Hudson;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogSet;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.bearychat.ActiveNotifier;
import jenkins.plugins.bearychat.BearyChatNotifier;
import jenkins.plugins.bearychat.Messages;
import org.apache.commons.lang.StringUtils;

public class Helper {
    private static final Logger logger = Logger.getLogger(ActiveNotifier.class.getName());
    private static final String STATUS_STARTING = Messages.JobStatusStarting();
    private static final String STATUS_BACK_TO_NORMAL = Messages.JobStatusBackToNormal();
    private static final String STATUS_STILL_FAILING = Messages.JobStatusStillFailing();
    private static final String STATUS_SUCCESS = Messages.JobStatusSuccess();
    private static final String STATUS_FAILURE = Messages.JobStatusFailure();
    private static final String STATUS_ABORTED = Messages.JobStatusAborted();
    private static final String STATUS_NOT_BUILT = Messages.JobStatusNotBuilt();
    private static final String STATUS_UNSTABLE = Messages.JobStatusUnstable();
    private static final String STATUS_UNKNOWN = Messages.JobStatusUnknown();
    private static final int MAX_COMMIT_MESSAGES = 5;
    public static final String COLOR_GREEN = "#008800";
    public static final String COLOR_RED = "#FF0000";
    public static final String COLOR_YELLOW = "#FFFF00";
    public static final String COLOR_BLUE = "#0080FF";
    public static final String COLOR_GREY = "#808080";

    public static String escape(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        return string;
    }

    public static String getStatusByBuild(AbstractBuild build) {
        AbstractBuild lastNonAbortedBuild;
        if (build.isBuilding()) {
            return STATUS_STARTING;
        }
        Result result = build.getResult();
        AbstractBuild previousBuild = null;
        try {
            previousBuild = build.getProject().getLastBuild().getPreviousBuild();
        }
        catch (NullPointerException e) {
            logger.info("get previous build failure");
            return STATUS_UNKNOWN;
        }
        catch (Exception e) {
            logger.info("get previous build failure");
            return STATUS_UNKNOWN;
        }
        Run previousSuccessfulBuild = build.getPreviousSuccessfulBuild();
        boolean buildHasSucceededBefore = previousSuccessfulBuild != null;
        for (lastNonAbortedBuild = previousBuild; lastNonAbortedBuild != null && lastNonAbortedBuild.getResult() == Result.ABORTED; lastNonAbortedBuild = lastNonAbortedBuild.getPreviousBuild()) {
        }
        Result previousResult = lastNonAbortedBuild == null ? Result.SUCCESS : lastNonAbortedBuild.getResult();
        if (result == Result.SUCCESS && (previousResult == Result.FAILURE || previousResult == Result.UNSTABLE) && buildHasSucceededBefore) {
            return STATUS_BACK_TO_NORMAL;
        }
        if (result == Result.FAILURE && previousResult == Result.FAILURE) {
            return STATUS_STILL_FAILING;
        }
        if (result == Result.SUCCESS) {
            return STATUS_SUCCESS;
        }
        if (result == Result.FAILURE) {
            return STATUS_FAILURE;
        }
        if (result == Result.ABORTED) {
            return STATUS_ABORTED;
        }
        if (result == Result.NOT_BUILT) {
            return STATUS_NOT_BUILT;
        }
        if (result == Result.UNSTABLE) {
            return STATUS_UNSTABLE;
        }
        return STATUS_UNKNOWN;
    }

    public static String getCommitMessages(AbstractBuild build) {
        ChangeLogSet changeSet = build.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            logger.info("Entry " + o);
            entries.add(entry);
        }
        if (entries.isEmpty()) {
            logger.info("Empty change...");
            Cause.UpstreamCause c = (Cause.UpstreamCause)build.getCause(Cause.UpstreamCause.class);
            if (c == null) {
                return "No Commit Changes.";
            }
            String upProjectName = c.getUpstreamProject();
            int buildNumber = c.getUpstreamBuild();
            AbstractProject project = null;
            try {
                project = (AbstractProject)Hudson.getInstance().getItemByFullName(upProjectName, AbstractProject.class);
            }
            catch (NullPointerException e) {
                logger.info("get project failure");
            }
            if (project == null) {
                return "No Commit Changes.";
            }
            AbstractBuild upBuild = project.getBuildByNumber(buildNumber);
            return Helper.getCommitMessages(upBuild);
        }
        StringBuffer commits = new StringBuffer();
        for (int i = 0; i < 5 && i < entries.size(); ++i) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)entries.get(i);
            StringBuffer commit = new StringBuffer();
            commit.append(entry.getMsg());
            commit.append(" [").append(entry.getAuthor().getDisplayName()).append("]");
            commits.append("- ").append(commit.toString()).append("\n");
        }
        if (entries.size() > 5) {
            int left = entries.size() - 5;
            commits.append(left).append(" more...");
        }
        return commits.toString();
    }

    public static String getChanges(BearyChatNotifier notifier, AbstractBuild r) {
        StringBuffer result = new StringBuffer();
        if (!r.hasChangeSetComputed()) {
            logger.info("No change set computed...");
            return null;
        }
        ChangeLogSet changeSet = r.getChangeSet();
        LinkedList<ChangeLogSet.Entry> entries = new LinkedList<ChangeLogSet.Entry>();
        HashSet files = new HashSet();
        for (Object o : changeSet.getItems()) {
            ChangeLogSet.Entry entry = (ChangeLogSet.Entry)o;
            logger.info("Entry " + o);
            entries.add(entry);
            files.addAll(entry.getAffectedFiles());
        }
        if (entries.isEmpty()) {
            logger.info("Empty change...");
            return null;
        }
        HashSet<String> authors = new HashSet<String>();
        for (ChangeLogSet.Entry entry : entries) {
            authors.add(entry.getAuthor().getDisplayName());
        }
        result.append("Started by changes from ");
        result.append(StringUtils.join(authors, (String)", "));
        result.append(" (");
        result.append(files.size());
        result.append(" file(s) changed)");
        return result.toString();
    }

    public static String getCustomStartMessage(BearyChatNotifier notifier, AbstractBuild build) {
        String customStartMessage = notifier.getCustomStartMessage();
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO));
            customStartMessage = envVars.expand(customStartMessage);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return customStartMessage;
    }

    public static String getCustomEndMessage(BearyChatNotifier notifier, AbstractBuild build) {
        String customEndMessage = notifier.getCustomEndMessage();
        EnvVars envVars = null;
        try {
            envVars = build.getEnvironment((TaskListener)new LogTaskListener(logger, Level.INFO));
            customEndMessage = envVars.expand(customEndMessage);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return customEndMessage;
    }

    public static String getBuildColor(AbstractBuild build) {
        Result result = build.getResult();
        String color = result == Result.SUCCESS ? COLOR_BLUE : (result == Result.FAILURE ? COLOR_RED : (result == Result.UNSTABLE ? COLOR_YELLOW : COLOR_GREY));
        return color;
    }

    public static String createBackToNormalDurationString(AbstractBuild build) {
        long backToNormalDuration = 0L;
        try {
            Run previousSuccessfulBuild = build.getPreviousSuccessfulBuild();
            long previousSuccessStartTime = previousSuccessfulBuild.getStartTimeInMillis();
            long previousSuccessDuration = previousSuccessfulBuild.getDuration();
            long previousSuccessEndTime = previousSuccessStartTime + previousSuccessDuration;
            long buildStartTime = build.getStartTimeInMillis();
            long buildDuration = build.getDuration();
            long buildEndTime = buildStartTime + buildDuration;
            backToNormalDuration = buildEndTime - previousSuccessEndTime;
            return Util.getTimeSpanString((long)backToNormalDuration);
        }
        catch (NullPointerException e) {
            return Util.getTimeSpanString((long)backToNormalDuration);
        }
        catch (Exception e) {
            return Util.getTimeSpanString((long)backToNormalDuration);
        }
    }

    public static String getBuildStatusMessage(BearyChatNotifier notifier, AbstractBuild build) {
        StringBuffer result = new StringBuffer();
        result.append(Helper.escape(Helper.getStatusByBuild(build)));
        result.append(" " + Messages.JobDurationAfter() + " ");
        if (result.toString().contains(STATUS_BACK_TO_NORMAL)) {
            result.append(Helper.createBackToNormalDurationString(build));
        } else {
            result.append(build.getDurationString());
        }
        return result.toString();
    }
}

