/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.dsl;

import com.jenkinsci.plugins.badge.action.BadgeAction;
import com.jenkinsci.plugins.badge.annotations.OptionalParam;
import com.jenkinsci.plugins.badge.annotations.Param;
import com.jenkinsci.plugins.badge.dsl.AbstractTaskListenerDescriptor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import java.io.Serializable;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AddShortTextStep
extends Step {
    private final ShortText shortText;

    @DataBoundConstructor
    public AddShortTextStep(@Param(name="text", description="The text to add fot this badge") String text) {
        this.shortText = new ShortText(text);
    }

    public String getText() {
        return this.shortText.getText();
    }

    public String getColor() {
        return this.shortText.getColor();
    }

    @DataBoundSetter
    @OptionalParam(description="The color for this short text")
    public void setColor(String color) {
        this.shortText.setColor(color);
    }

    public String getBackground() {
        return this.shortText.getBackground();
    }

    @DataBoundSetter
    @OptionalParam(description="The background-color for this short text")
    public void setBackground(String background) {
        this.shortText.setBackground(background);
    }

    public Integer getBorder() {
        return this.shortText.getBorder();
    }

    @DataBoundSetter
    @OptionalParam(description="The border width for this short text")
    public void setBorder(Integer border) {
        this.shortText.setBorder(border);
    }

    public String getBorderColor() {
        return this.shortText.getBorderColor();
    }

    @DataBoundSetter
    @OptionalParam(description="The order color for this short text")
    public void setBorderColor(String borderColor) {
        this.shortText.setBorderColor(borderColor);
    }

    @DataBoundSetter
    @OptionalParam(description="The link for this short text")
    public void setLink(String link) {
        this.shortText.setLink(link);
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.shortText, context);
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient ShortText shortText;
        private static final long serialVersionUID = 1L;

        Execution(ShortText shortText, StepContext context) {
            super(context);
            this.shortText = shortText;
        }

        protected Void run() throws Exception {
            ((Run)this.getContext().get(Run.class)).addAction((Action)BadgeAction.createShortText(this.shortText.getText(), this.shortText.getColor(), this.shortText.getBackground(), this.shortText.getBorderString(), this.shortText.getBorderColor(), this.shortText.link));
            return null;
        }
    }

    private static class ShortText
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String text;
        private String color;
        private String background;
        private Integer border;
        private String borderColor;
        private String link;

        public ShortText(String text) {
            this.text = text;
        }

        private String getText() {
            return this.text;
        }

        private String getColor() {
            return this.color;
        }

        public void setColor(String color) {
            this.color = color;
        }

        private String getBackground() {
            return this.background;
        }

        public void setBackground(String background) {
            this.background = background;
        }

        private Integer getBorder() {
            return this.border;
        }

        public void setBorder(Integer border) {
            this.border = border;
        }

        private String getBorderColor() {
            return this.borderColor;
        }

        public void setBorderColor(String borderColor) {
            this.borderColor = borderColor;
        }

        private String getBorderString() {
            return this.border == null ? null : this.border + "px";
        }

        public String getLink() {
            return this.link;
        }

        public void setLink(String link) {
            this.link = link;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractTaskListenerDescriptor {
        public String getFunctionName() {
            return "addShortText";
        }

        public String getDisplayName() {
            return "Add Short Text";
        }
    }
}

