/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge.action;

import com.jenkinsci.plugins.badge.action.AbstractAction;
import org.apache.commons.lang.StringEscapeUtils;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=2)
public class BadgeSummaryAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private final String iconPath;
    private String summaryText = "";

    public BadgeSummaryAction(String iconPath) {
        this.iconPath = iconPath;
    }

    public String getUrlName() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getIconFileName() {
        return null;
    }

    @Exported
    public String getIconPath() {
        return this.iconPath;
    }

    @Exported
    public String getText() {
        return this.summaryText;
    }

    @Whitelisted
    public void appendText(String text) {
        this.appendText(text, false);
    }

    @Whitelisted
    public void appendText(String text, boolean escapeHtml) {
        if (escapeHtml) {
            text = StringEscapeUtils.escapeHtml((String)text);
        }
        this.summaryText = this.summaryText + text;
    }

    @Whitelisted
    public void appendText(String text, boolean escapeHtml, boolean bold, boolean italic, String color) {
        if (bold) {
            this.summaryText = this.summaryText + "<b>";
        }
        if (italic) {
            this.summaryText = this.summaryText + "<i>";
        }
        if (color != null) {
            this.summaryText = this.summaryText + "<font color=\"" + color + "\">";
        }
        if (escapeHtml) {
            text = StringEscapeUtils.escapeHtml((String)text);
        }
        this.summaryText = this.summaryText + text;
        if (color != null) {
            this.summaryText = this.summaryText + "</font>";
        }
        if (italic) {
            this.summaryText = this.summaryText + "</i>";
        }
        if (bold) {
            this.summaryText = this.summaryText + "</b>";
        }
    }
}

