/*
 * Decompiled with CFR 0.152.
 */
package com.jenkinsci.plugins.badge;

import com.jenkinsci.plugins.badge.action.BadgeAction;
import com.jenkinsci.plugins.badge.action.BadgeSummaryAction;
import hudson.Plugin;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BadgePlugin
extends Plugin {
    public void doRemoveBadges(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.removeActions(BadgeAction.class, req, rsp);
    }

    public void doRemoveSummaries(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.removeActions(BadgeSummaryAction.class, req, rsp);
    }

    private void removeActions(Class type, StaplerRequest req, StaplerResponse rsp) throws IOException {
        ((Job)req.findAncestorObject(Job.class)).checkPermission(Run.UPDATE);
        Run run = (Run)req.findAncestorObject(Run.class);
        if (run != null) {
            List actions = run.getAllActions();
            List groovyActions = run.getActions(type);
            for (Action action : groovyActions) {
                actions.remove(action);
            }
            run.save();
            rsp.sendRedirect(req.getRequestURI().substring(0, req.getRequestURI().indexOf("parent/parent")));
        }
    }

    public void doRemoveBadge(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.removeAction(BadgeAction.class, req, rsp);
    }

    public void doRemoveSummary(StaplerRequest req, StaplerResponse rsp) throws IOException {
        this.removeAction(BadgeSummaryAction.class, req, rsp);
    }

    private void removeAction(Class type, StaplerRequest req, StaplerResponse rsp) throws IOException {
        int idx;
        String index = req.getParameter("index");
        if (index == null) {
            throw new IOException("Missing parameter 'index'.");
        }
        try {
            idx = Integer.parseInt(index);
        }
        catch (NumberFormatException e) {
            throw new IOException("Invalid index: " + index);
        }
        ((Job)req.findAncestorObject(Job.class)).checkPermission(Run.UPDATE);
        Run run = (Run)req.findAncestorObject(Run.class);
        if (run != null) {
            List actions = run.getAllActions();
            List groovyActions = run.getActions(type);
            if (idx < 0 || idx >= groovyActions.size()) {
                throw new IOException("Index out of range: " + idx);
            }
            actions.remove(groovyActions.get(idx));
            run.save();
            rsp.sendRedirect(req.getRequestURI().substring(0, req.getRequestURI().indexOf("parent/parent")));
        }
    }
}

