/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.webdav;

import hudson.FilePath;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.entity.AbstractHttpEntity;

public class FilePathEntity
extends AbstractHttpEntity {
    protected final FilePath filePath;

    public FilePathEntity(FilePath filePath, String contentType) {
        if (filePath == null) {
            throw new IllegalArgumentException("FilePath may not be null");
        }
        this.filePath = filePath;
        this.setContentType(contentType);
    }

    public boolean isRepeatable() {
        return true;
    }

    public long getContentLength() {
        try {
            return this.filePath.length();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public InputStream getContent() throws IOException, IllegalStateException {
        try {
            return this.filePath.read();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream outstream) throws IOException {
        InputStream instream;
        if (outstream == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        try {
            instream = this.filePath.read();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        try {
            int l;
            byte[] tmp = new byte[4096];
            while ((l = instream.read(tmp)) != -1) {
                outstream.write(tmp, 0, l);
            }
            outstream.flush();
        }
        finally {
            instream.close();
        }
    }

    public boolean isStreaming() {
        return false;
    }
}

