/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog.pipeline;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.nulabinc.backlog4j.PullRequest;
import com.nulabinc.backlog4j.ResponseList;
import com.nulabinc.backlog4j.api.option.PullRequestQueryParams;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.model.queue.Tasks;
import hudson.plugins.backlog.BacklogProjectProperty;
import hudson.plugins.backlog.Messages;
import hudson.plugins.backlog.api.v2.BacklogClientFactory;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitStatus;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.plugins.git.extensions.GitSCMExtension;
import hudson.plugins.git.extensions.GitSCMExtensionDescriptor;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCM;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.jenkinsci.plugins.gitclient.FetchCommand;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class BacklogPullRequestSCMSource
extends AbstractGitSCMSource {
    private static final String DEFAULT_INCLUDES = "*";
    private static final String DEFAULT_EXCLUDES = "";
    public static final Logger LOGGER = Logger.getLogger(BacklogPullRequestSCMSource.class.getName());
    private final String remote;
    private final String credentialsId;
    private final String includes;
    private final String excludes;
    private final boolean ignoreOnPushNotifications;
    private final String url;
    private final Secret apiKey;
    private final BacklogProjectProperty bpp;
    @CheckForNull
    private GitRepositoryBrowser browser;
    @CheckForNull
    private String gitTool;
    private List<GitSCMExtension> extensions;

    @DataBoundConstructor
    public BacklogPullRequestSCMSource(String id, String remote, String credentialsId, String includes, String excludes, boolean ignoreOnPushNotifications, String url, String apiKey) {
        super(id);
        this.remote = remote;
        this.credentialsId = credentialsId;
        this.includes = includes;
        this.excludes = excludes;
        this.ignoreOnPushNotifications = ignoreOnPushNotifications;
        this.url = url;
        this.apiKey = Secret.fromString((String)apiKey);
        this.bpp = new BacklogProjectProperty(url, DEFAULT_EXCLUDES, DEFAULT_EXCLUDES, apiKey);
    }

    public boolean isIgnoreOnPushNotifications() {
        return this.ignoreOnPushNotifications;
    }

    public GitRepositoryBrowser getBrowser() {
        return this.browser;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setBrowser(GitRepositoryBrowser browser) {
        this.browser = browser;
    }

    public String getGitTool() {
        return this.gitTool;
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setGitTool(String gitTool) {
        this.gitTool = Util.fixEmptyAndTrim((String)gitTool);
    }

    public List<GitSCMExtension> getExtensions() {
        if (this.extensions == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<GitSCMExtension>(this.extensions));
    }

    @DataBoundSetter
    @Restricted(value={NoExternalUse.class})
    public void setExtensions(List<GitSCMExtension> extensions) {
        this.extensions = Util.fixNull(extensions);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getRemote() {
        return this.remote;
    }

    public String getIncludes() {
        return this.includes;
    }

    public String getExcludes() {
        return this.excludes;
    }

    public String getUrl() {
        return this.url;
    }

    public Secret getApiKey() {
        return this.apiKey;
    }

    public BacklogProjectProperty getBpp() {
        return this.bpp;
    }

    protected List<RefSpec> getRefSpecs() {
        return Arrays.asList(new RefSpec("+refs/pull/*:refs/remotes/" + this.getRemoteName() + "/*"));
    }

    @CheckForNull
    protected SCMRevision retrieve(final @NonNull SCMHead head, @NonNull TaskListener listener) throws IOException, InterruptedException {
        return this.doRetrieve(new Retriever<SCMRevision>(){

            @Override
            public SCMRevision run(GitClient client, String remoteName) throws IOException, InterruptedException {
                for (Branch b : client.getRemoteBranches()) {
                    String branchName = StringUtils.removeEnd((String)StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/")), (String)"/head");
                    if (!branchName.equals(head.getName())) continue;
                    return new AbstractGitSCMSource.SCMRevisionImpl(head, b.getSHA1String());
                }
                return null;
            }
        }, listener, false);
    }

    protected void retrieve(final @CheckForNull SCMSourceCriteria criteria, final @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, final @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.doRetrieve(new Retriever<Void>(){

            @Override
            public Void run(GitClient client, String remoteName) throws IOException, InterruptedException {
                final Repository repository = client.getRepository();
                listener.getLogger().println("Getting remote branches...");
                ResponseList pullRequests = BacklogPullRequestSCMSource.this.getOpenPullRequests();
                try (RevWalk walk = new RevWalk(repository);){
                    walk.setRetainBody(false);
                    for (Branch b : client.getRemoteBranches()) {
                        BacklogPullRequestSCMSource.this.checkInterrupt();
                        if (!b.getName().startsWith(remoteName + "/")) continue;
                        final String branchName = StringUtils.removeEnd((String)StringUtils.removeStart((String)b.getName(), (String)(remoteName + "/")), (String)"/head");
                        listener.getLogger().println("Checking branch " + branchName);
                        if (BacklogPullRequestSCMSource.this.isExcluded(branchName) || !BacklogPullRequestSCMSource.this.isPullRequestOpen((ResponseList<PullRequest>)pullRequests, branchName)) continue;
                        if (criteria != null) {
                            RevTree tree;
                            RevCommit commit = walk.parseCommit((AnyObjectId)b.getSHA1());
                            final long lastModified = TimeUnit.SECONDS.toMillis(commit.getCommitTime());
                            SCMProbe probe = new SCMProbe(tree = commit.getTree()){
                                final /* synthetic */ RevTree val$tree;
                                {
                                    this.val$tree = revTree;
                                }

                                public void close() throws IOException {
                                }

                                public String name() {
                                    return branchName;
                                }

                                public long lastModified() {
                                    return lastModified;
                                }

                                @NonNull
                                @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"}, justification="TreeWalk.forPath can return null, compiler generated code for try with resources handles it")
                                public SCMProbeStat stat(@NonNull String path) throws IOException {
                                    try (TreeWalk tw = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)this.val$tree);){
                                        if (tw == null) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                            return sCMProbeStat;
                                        }
                                        FileMode fileMode = tw.getFileMode(0);
                                        if (fileMode == FileMode.MISSING) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.NONEXISTENT);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.EXECUTABLE_FILE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.REGULAR_FILE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.REGULAR_FILE);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.SYMLINK) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.LINK);
                                            return sCMProbeStat;
                                        }
                                        if (fileMode == FileMode.TREE) {
                                            SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.DIRECTORY);
                                            return sCMProbeStat;
                                        }
                                        SCMProbeStat sCMProbeStat = SCMProbeStat.fromType((SCMFile.Type)SCMFile.Type.OTHER);
                                        return sCMProbeStat;
                                    }
                                }
                            };
                            if (criteria.isHead((SCMSourceCriteria.Probe)probe, listener)) {
                                listener.getLogger().println("Met criteria");
                            } else {
                                listener.getLogger().println("Does not meet criteria");
                                continue;
                            }
                        }
                        SCMHead head = new SCMHead(branchName);
                        AbstractGitSCMSource.SCMRevisionImpl hash = new AbstractGitSCMSource.SCMRevisionImpl(head, b.getSHA1String());
                        observer.observe(head, (SCMRevision)hash);
                        if (observer.isObserving()) continue;
                        Void void_ = null;
                        return void_;
                    }
                }
                listener.getLogger().println("Done.");
                return null;
            }
        }, listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T doRetrieve(Retriever<T> retriever, @NonNull TaskListener listener, boolean prune) throws IOException, InterruptedException {
        String cacheEntry = this.getCacheEntry();
        Lock cacheLock = BacklogPullRequestSCMSource.getCacheLock((String)cacheEntry);
        cacheLock.lock();
        try {
            File cacheDir = BacklogPullRequestSCMSource.getCacheDir((String)cacheEntry);
            Git git = Git.with((TaskListener)listener, (EnvVars)new EnvVars(EnvVars.masterEnvVars)).in(cacheDir);
            GitTool tool = this.resolveGitTool();
            if (tool != null) {
                git.using(tool.getGitExe());
            }
            GitClient client = git.getClient();
            client.addDefaultCredentials((StandardCredentials)this.getCredentials());
            if (!client.hasGitRepo()) {
                listener.getLogger().println("Creating git repository in " + cacheDir);
                client.init();
            }
            String remoteName = this.getRemoteName();
            listener.getLogger().println("Setting " + remoteName + " to " + this.getRemote());
            client.setRemoteUrl(remoteName, this.getRemote());
            listener.getLogger().println((prune ? "Fetching & pruning " : "Fetching ") + remoteName + "...");
            FetchCommand fetch = client.fetch_();
            if (prune) {
                fetch = fetch.prune();
            }
            URIish remoteURI = null;
            try {
                remoteURI = new URIish(remoteName);
            }
            catch (URISyntaxException ex) {
                listener.getLogger().println("URI syntax exception for '" + remoteName + "' " + ex);
            }
            fetch.from(remoteURI, this.getRefSpecs()).execute();
            T t = retriever.run(client, remoteName);
            return t;
        }
        finally {
            cacheLock.unlock();
        }
    }

    private ResponseList<PullRequest> getOpenPullRequests() throws MalformedURLException {
        PullRequestQueryParams params = new PullRequestQueryParams();
        params.statusType(Collections.singletonList(PullRequest.StatusType.Open));
        params.count(100);
        String repoName = new URIish(new URL(this.remote)).getHumanishName();
        return BacklogClientFactory.getBacklogClient(this.bpp).getPullRequests(this.bpp.getProject(), repoName, params);
    }

    private boolean isPullRequestOpen(ResponseList<PullRequest> pullRequests, String branchName) {
        for (PullRequest pullRequest : pullRequests) {
            if (pullRequest.getNumber() != Long.parseLong(branchName)) continue;
            return true;
        }
        return false;
    }

    private static interface Retriever<T> {
        public T run(GitClient var1, String var2) throws IOException, InterruptedException;
    }

    @Extension
    public static class ListenerImpl
    extends GitStatus.Listener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<GitStatus.ResponseContributor> onNotifyCommit(URIish uri, final String sha1, List<ParameterValue> buildParameters, String ... branches) {
            boolean[] notified;
            ArrayList<GitStatus.ResponseContributor> result;
            block11: {
                result = new ArrayList<GitStatus.ResponseContributor>();
                notified = new boolean[]{false};
                Jenkins jenkins = Jenkins.getInstance();
                if (jenkins == null) {
                    LOGGER.severe("Jenkins instance is null in BacklogPullRequestSCMSource.onNotifyCommit");
                    return result;
                }
                jenkins.getACL();
                SecurityContext old = ACL.impersonate((Authentication)ACL.SYSTEM);
                try {
                    if (branches.length > 0) {
                        final URIish u = uri;
                        for (final String branch : branches) {
                            SCMHeadEvent.fireNow((SCMHeadEvent)new SCMHeadEvent<String>(SCMEvent.Type.UPDATED, branch){

                                public boolean isMatch(@NonNull SCMNavigator navigator) {
                                    return false;
                                }

                                @NonNull
                                public String getSourceName() {
                                    return u.getHumanishName();
                                }

                                public boolean isMatch(SCMSource source) {
                                    if (source instanceof BacklogPullRequestSCMSource) {
                                        URIish remote;
                                        BacklogPullRequestSCMSource git = (BacklogPullRequestSCMSource)source;
                                        if (git.ignoreOnPushNotifications) {
                                            return false;
                                        }
                                        try {
                                            remote = new URIish(git.getRemote());
                                        }
                                        catch (URISyntaxException e) {
                                            return false;
                                        }
                                        if (GitStatus.looselyMatches((URIish)u, (URIish)remote)) {
                                            notified[0] = true;
                                            return true;
                                        }
                                        return false;
                                    }
                                    return false;
                                }

                                @NonNull
                                public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
                                    SCMHead head = new SCMHead(branch);
                                    return Collections.singletonMap(head, sha1 != null ? new AbstractGitSCMSource.SCMRevisionImpl(head, sha1) : null);
                                }

                                public boolean isMatch(@NonNull SCM scm) {
                                    return false;
                                }
                            });
                        }
                        break block11;
                    }
                    for (final SCMSourceOwner owner : SCMSourceOwners.all()) {
                        for (SCMSource source : owner.getSCMSources()) {
                            URIish remote;
                            BacklogPullRequestSCMSource git;
                            if (!(source instanceof BacklogPullRequestSCMSource) || (git = (BacklogPullRequestSCMSource)source).ignoreOnPushNotifications) continue;
                            try {
                                remote = new URIish(git.getRemote());
                            }
                            catch (URISyntaxException e) {
                                continue;
                            }
                            if (!GitStatus.looselyMatches((URIish)uri, (URIish)remote)) continue;
                            LOGGER.info("Triggering the indexing of " + owner.getFullDisplayName());
                            owner.onSCMSourceUpdated(source);
                            result.add(new GitStatus.ResponseContributor(){

                                public void addHeaders(StaplerRequest req, StaplerResponse rsp) {
                                    rsp.addHeader("Triggered", owner.getAbsoluteUrl());
                                }

                                public void writeBody(PrintWriter w) {
                                    w.println("Scheduled indexing of " + owner.getFullDisplayName());
                                }
                            });
                            notified[0] = true;
                        }
                    }
                }
                finally {
                    SecurityContextHolder.setContext((SecurityContext)old);
                }
            }
            if (!notified[0]) {
                result.add((GitStatus.ResponseContributor)new GitStatus.MessageResponseContributor("No Git consumers using SCM API plugin for: " + uri.toString()));
            }
            return result;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        public String getDisplayName() {
            return Messages.BacklogPullRequestSCMSource_DisplayName();
        }

        @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"}, justification="pending https://github.com/jenkinsci/credentials-plugin/pull/68")
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath SCMSourceOwner context, @QueryParameter String remote, @QueryParameter String credentialsId) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, (Item)context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)remote).build(), GitClient.CREDENTIALS_MATCHER).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath SCMSourceOwner context, @QueryParameter String url, @QueryParameter String value) {
            if (context == null && !Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) || context != null && !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if ((value = Util.fixEmptyAndTrim((String)value)) == null) {
                return FormValidation.ok();
            }
            if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
                return FormValidation.ok();
            }
            for (ListBoxModel.Option o : CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)context, (Authentication)(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM), (List)URIRequirementBuilder.fromUri((String)url).build(), (CredentialsMatcher)GitClient.CREDENTIALS_MATCHER)) {
                if (!StringUtils.equals((String)value, (String)o.value)) continue;
                return FormValidation.ok();
            }
            return FormValidation.warning((String)("Cannot find any credentials with id " + value));
        }

        public GitSCM.DescriptorImpl getSCMDescriptor() {
            return (GitSCM.DescriptorImpl)Jenkins.getInstance().getDescriptor(GitSCM.class);
        }

        public List<GitSCMExtensionDescriptor> getExtensionDescriptors() {
            return this.getSCMDescriptor().getExtensionDescriptors();
        }

        public List<Descriptor<RepositoryBrowser<?>>> getBrowserDescriptors() {
            return this.getSCMDescriptor().getBrowserDescriptors();
        }

        public boolean showGitToolOptions() {
            return this.getSCMDescriptor().showGitToolOptions();
        }

        public ListBoxModel doFillGitToolItems() {
            return this.getSCMDescriptor().doFillGitToolItems();
        }
    }
}

