/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.backlog;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.backlog.repositorybrowser.RepositoryBrowserHelper;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.ChangeLogSet;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import org.kohsuke.stapler.DataBoundConstructor;

public class BacklogGitRepositoryBrowser
extends GitRepositoryBrowser {
    public final String repoName;

    @DataBoundConstructor
    public BacklogGitRepositoryBrowser(String repoName, String repoUrl) {
        super(repoUrl);
        this.repoName = repoName;
    }

    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.getRepoUrl());
        if (path.getEditType() != EditType.EDIT) {
            return null;
        }
        GitChangeSet logEntry = path.getChangeSet();
        if (helper.getSpaceURL((ChangeLogSet.Entry)logEntry) == null || helper.getProject((ChangeLogSet.Entry)logEntry) == null) {
            return null;
        }
        String filePath = path.getPath();
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String encodedPath = URLEncoder.encode(filePath, "UTF-8");
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)logEntry) + "git/" + helper.getProject((ChangeLogSet.Entry)logEntry) + "/" + this.repoName + "/diff/" + logEntry.getParentCommit() + "..." + logEntry.getCommitId() + "/" + encodedPath);
    }

    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.getRepoUrl());
        if (path.getEditType() == EditType.DELETE) {
            return null;
        }
        GitChangeSet logEntry = path.getChangeSet();
        if (helper.getSpaceURL((ChangeLogSet.Entry)logEntry) == null || helper.getProject((ChangeLogSet.Entry)logEntry) == null) {
            return null;
        }
        String filePath = path.getPath();
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        String encodedPath = URLEncoder.encode(filePath, "UTF-8");
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)logEntry) + "git/" + helper.getProject((ChangeLogSet.Entry)logEntry) + "/" + this.repoName + "/blob/" + logEntry.getCommitId() + "/" + encodedPath);
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        RepositoryBrowserHelper helper = new RepositoryBrowserHelper(this.getRepoUrl());
        if (helper.getSpaceURL((ChangeLogSet.Entry)changeSet) == null || helper.getProject((ChangeLogSet.Entry)changeSet) == null) {
            return null;
        }
        return new URL(helper.getSpaceURL((ChangeLogSet.Entry)changeSet) + "git/" + helper.getProject((ChangeLogSet.Entry)changeSet) + "/" + this.repoName + "/commit/" + changeSet.getRevision());
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<RepositoryBrowser<?>> {
        public DescriptorImpl() {
            super(BacklogGitRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Backlog";
        }
    }
}

