/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.amazonaws.auth.AWSCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.credentialsbinding.BindingDescriptor;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.kohsuke.stapler.DataBoundConstructor;

public class AmazonWebServicesCredentialsBinding
extends MultiBinding<AmazonWebServicesCredentials> {
    public static final String DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME = "AWS_ACCESS_KEY_ID";
    private static final String DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME = "AWS_SECRET_ACCESS_KEY";
    @NonNull
    private final String accessKeyVariable;
    @NonNull
    private final String secretKeyVariable;

    @DataBoundConstructor
    public AmazonWebServicesCredentialsBinding(@Nullable String accessKeyVariable, @Nullable String secretKeyVariable, String credentialsId) {
        super(credentialsId);
        this.accessKeyVariable = StringUtils.defaultIfBlank((String)accessKeyVariable, (String)DEFAULT_ACCESS_KEY_ID_VARIABLE_NAME);
        this.secretKeyVariable = StringUtils.defaultIfBlank((String)secretKeyVariable, (String)DEFAULT_SECRET_ACCESS_KEY_VARIABLE_NAME);
    }

    @NonNull
    public String getAccessKeyVariable() {
        return this.accessKeyVariable;
    }

    @NonNull
    public String getSecretKeyVariable() {
        return this.secretKeyVariable;
    }

    protected Class<AmazonWebServicesCredentials> type() {
        return AmazonWebServicesCredentials.class;
    }

    public MultiBinding.MultiEnvironment bind(@Nonnull Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
        AWSCredentials credentials = ((AmazonWebServicesCredentials)this.getCredentials(build)).getCredentials();
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(this.accessKeyVariable, credentials.getAWSAccessKeyId());
        m.put(this.secretKeyVariable, credentials.getAWSSecretKey());
        return new MultiBinding.MultiEnvironment(m);
    }

    public Set<String> variables() {
        return new HashSet<String>(Arrays.asList(this.accessKeyVariable, this.secretKeyVariable));
    }

    @Extension
    public static class DescriptorImpl
    extends BindingDescriptor<AmazonWebServicesCredentials> {
        protected Class<AmazonWebServicesCredentials> type() {
            return AmazonWebServicesCredentials.class;
        }

        public String getDisplayName() {
            return "AWS access key and secret";
        }
    }
}

