/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.threading;

import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueListener;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueMonitor;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueMonitorScheduler;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueProvider;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.events.ConfigurationChangedEvent;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.events.EventBroker;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang.StringUtils;

public class SQSQueueMonitorSchedulerImpl
implements SQSQueueMonitorScheduler {
    private static final Log log = Log.get(SQSQueueMonitorSchedulerImpl.class);
    private final ExecutorService executor;
    private final SQSQueueProvider provider;
    private SQSFactory factory;
    private final Map<String, SQSQueueMonitor> monitors = new HashMap<String, SQSQueueMonitor>();

    @Inject
    public SQSQueueMonitorSchedulerImpl(ExecutorService executor, SQSQueueProvider provider, SQSFactory factory) {
        this.executor = executor;
        this.provider = provider;
        this.factory = factory;
        EventBroker.getInstance().register(this);
    }

    @Override
    public boolean register(SQSQueueListener listener) {
        log.debug("Register SQS listener", new Object[0]);
        String uuid = listener.getQueueUuid();
        SQSQueue queue = this.provider.getSqsQueue(uuid);
        if (queue == null) {
            log.warning("No queue for {%s}, aborted", uuid);
            return false;
        }
        this.register(listener, uuid, queue);
        return true;
    }

    @Override
    public synchronized boolean unregister(SQSQueueListener listener) {
        if (listener == null) {
            return false;
        }
        log.debug("Unregister SQS listener", new Object[0]);
        String uuid = listener.getQueueUuid();
        SQSQueueMonitor monitor = this.monitors.get(uuid);
        if (monitor == null) {
            log.warning("No monitor for {%s}, aborted", uuid);
            return false;
        }
        log.debug("Remove listener from monitor for {%s}", uuid);
        if (monitor.remove(listener)) {
            monitor.shutDown();
        }
        if (monitor.isShutDown()) {
            log.debug("Monitor is shut down, remove monitor for {%s}", uuid);
            this.monitors.remove(uuid);
        }
        return true;
    }

    @Override
    @Subscribe
    public synchronized void onConfigurationChanged(ConfigurationChangedEvent event) {
        Iterator<Map.Entry<String, SQSQueueMonitor>> entries = this.monitors.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<String, SQSQueueMonitor> entry = entries.next();
            this.reconfigure(entries, entry);
        }
    }

    private synchronized void register(SQSQueueListener listener, String uuid, SQSQueue queue) {
        SQSQueueMonitor monitor = this.monitors.get(uuid);
        if (monitor == null) {
            log.debug("No monitor exists, creating new monitor for %s", queue);
            monitor = this.factory.createMonitor(this.executor, queue);
            this.monitors.put(uuid, monitor);
        }
        log.debug("Add listener to monitor for %s", queue);
        monitor.add(listener);
    }

    private synchronized void reconfigure(Iterator<Map.Entry<String, SQSQueueMonitor>> entries, Map.Entry<String, SQSQueueMonitor> entry) {
        String uuid = entry.getKey();
        SQSQueueMonitor monitor = entry.getValue();
        SQSQueue queue = this.provider.getSqsQueue(uuid);
        if (queue == null) {
            log.debug("Queue {%s} removed, shut down monitor", uuid);
            monitor.shutDown();
            entries.remove();
        } else if (monitor.isShutDown() || this.hasQueueChanged(monitor, queue)) {
            log.debug("Queue {%s} changed or monitor stopped, create new monitor", uuid);
            monitor = this.factory.createMonitor(monitor, queue);
            entry.setValue(monitor).shutDown();
            this.executor.execute(monitor);
        }
    }

    private boolean hasQueueChanged(SQSQueueMonitor monitor, SQSQueue queue) {
        try {
            SQSQueue current = monitor.getQueue();
            if (!StringUtils.equals((String)current.getUrl(), (String)queue.getUrl())) {
                return true;
            }
            if (!StringUtils.equals((String)current.getCredentialsId(), (String)queue.getCredentialsId())) {
                return true;
            }
            if (current.getMaxNumberOfMessages() != queue.getMaxNumberOfMessages()) {
                return true;
            }
            return current.getWaitTimeSeconds() != queue.getWaitTimeSeconds();
        }
        catch (Exception e) {
            log.warning("Cannot compare queues: %s, error: %s", e.getMessage(), e);
            return true;
        }
    }

    public synchronized void setFactory(SQSFactory factory) {
        this.factory = factory;
    }
}

