/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.net;

import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.RequestFactory;
import java.util.ArrayList;
import java.util.List;

public class RequestFactoryImpl
implements RequestFactory {
    @Override
    public ReceiveMessageRequest createReceiveMessageRequest(SQSQueue queue) {
        return this.createReceiveMessageRequest(queue.getUrl(), queue.getMaxNumberOfMessages(), queue.getWaitTimeSeconds());
    }

    @Override
    public ReceiveMessageRequest createReceiveMessageRequest(String queueUrl, int maxNumberMessages, int waitTimeSeconds) {
        ReceiveMessageRequest request = new ReceiveMessageRequest(queueUrl);
        request.setMaxNumberOfMessages(Integer.valueOf(maxNumberMessages));
        request.setWaitTimeSeconds(Integer.valueOf(waitTimeSeconds));
        return request;
    }

    @Override
    public DeleteMessageBatchRequest createDeleteMessageBatchRequest(SQSQueue queue, List<Message> messages) {
        return this.createDeleteMessageBatchRequest(queue.getUrl(), messages);
    }

    @Override
    public DeleteMessageBatchRequest createDeleteMessageBatchRequest(String queueUrl, List<Message> messages) {
        ArrayList<DeleteMessageBatchRequestEntry> entries = new ArrayList<DeleteMessageBatchRequestEntry>(messages.size());
        for (Message message : messages) {
            DeleteMessageBatchRequestEntry entry = this.createDeleteMessageBatchRequestEntry(message);
            entries.add(entry);
        }
        DeleteMessageBatchRequest request = new DeleteMessageBatchRequest(queueUrl);
        request.setEntries(entries);
        return request;
    }

    private DeleteMessageBatchRequestEntry createDeleteMessageBatchRequestEntry(Message message) {
        DeleteMessageBatchRequestEntry entry = new DeleteMessageBatchRequestEntry();
        entry.setReceiptHandle(message.getReceiptHandle());
        entry.setId(message.getMessageId());
        return entry;
    }
}

