/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.model.job;

import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJob;
import com.ribose.jenkins.plugin.awscodecommittrigger.utils.StringUtils;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;

public class RepoInfo {
    private List<String> codeCommitUrls;
    private List<String> branches;
    private List<String> nonCodeCommitUrls;

    private RepoInfo() {
    }

    public static RepoInfo fromSqsJob(SQSJob sqsJob) {
        if (sqsJob == null) {
            return null;
        }
        RepoInfo repoInfo = new RepoInfo();
        List<SCM> scms = sqsJob.getScmList();
        ArrayList<String> codeCommitUrls = new ArrayList<String>();
        ArrayList<String> nonCodeCommitUrls = new ArrayList<String>();
        ArrayList<String> branches = new ArrayList<String>();
        for (SCM scm : scms) {
            if (!(scm instanceof GitSCM)) continue;
            GitSCM git = (GitSCM)scm;
            List repos = git.getRepositories();
            for (RemoteConfig repo : repos) {
                for (URIish urIish : repo.getURIs()) {
                    String url = urIish.toString();
                    if (StringUtils.isCodeCommitRepo(url)) {
                        codeCommitUrls.add(url);
                        continue;
                    }
                    nonCodeCommitUrls.add(url);
                }
            }
            for (BranchSpec branchSpec : git.getBranches()) {
                branches.add(branchSpec.getName());
            }
        }
        repoInfo.nonCodeCommitUrls = nonCodeCommitUrls;
        repoInfo.codeCommitUrls = codeCommitUrls;
        repoInfo.branches = branches;
        return repoInfo;
    }

    public List<String> getCodeCommitUrls() {
        return this.codeCommitUrls;
    }

    public List<String> getBranches() {
        return this.branches;
    }

    public String getBranchesString() {
        return org.apache.commons.lang.StringUtils.join(this.branches, (String)", ");
    }

    public List<String> getNonCodeCommitUrls() {
        return this.nonCodeCommitUrls;
    }

    public boolean isHasCodeCommit() {
        return CollectionUtils.isNotEmpty(this.codeCommitUrls);
    }

    public boolean isHasNonCodeCommit() {
        return CollectionUtils.isNotEmpty(this.nonCodeCommitUrls);
    }

    public boolean isNoUrlFound() {
        return CollectionUtils.isEmpty(this.nonCodeCommitUrls) && CollectionUtils.isEmpty(this.codeCommitUrls);
    }
}

