/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit;

import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.Event;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.Record;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.entities.codecommit.Reference;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.transport.URIish;

public class CodeCommitEvent
implements Event {
    private static final Log log = Log.get(CodeCommitEvent.class);
    private static final String HOST = "git-codecommit.%s.amazonaws.com";
    private static final String PATH = "/v1/repos/%s";
    private final String host;
    private final String path;
    private final String branch;
    private final String noPrefixBranch;
    private final String arn;
    private final String user;

    public CodeCommitEvent(Record record, Reference reference) {
        this.arn = record.getEventSourceARN();
        String[] tokens = this.arn.split(":", 6);
        this.host = String.format(HOST, tokens[3]);
        this.path = String.format(PATH, tokens[5]);
        this.branch = reference.getReference();
        this.noPrefixBranch = reference.getReference().replaceAll("(refs/heads|refs/remotes|remotes)", "");
        this.user = record.getUserIdentityARN();
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getBranch() {
        return this.branch;
    }

    @Override
    public String getNoPrefixBranch() {
        return this.noPrefixBranch;
    }

    @Override
    public boolean isMatch(URIish uri) {
        String p2;
        if (uri == null) {
            return false;
        }
        if (!StringUtils.equals((String)this.host, (String)uri.getHost())) {
            log.debug("Event %s not match host %s", this.getArn(), uri.getHost());
            return false;
        }
        String p1 = this.path.endsWith("/") ? this.path : this.path + "/";
        String string = p2 = uri.getPath().endsWith("/") ? uri.getPath() : uri.getPath() + "/";
        if (!StringUtils.equalsIgnoreCase((String)p1, (String)p2)) {
            log.debug("Event %s not match path %s", this.getArn(), uri.getPath());
            return false;
        }
        log.debug("Event %s match uri %s", this.getArn(), uri);
        return true;
    }

    @Override
    public String getArn() {
        return this.arn;
    }
}

