/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.matchers.impl;

import com.ribose.jenkins.plugin.awscodecommittrigger.SQSScmConfig;
import com.ribose.jenkins.plugin.awscodecommittrigger.SQSTrigger;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.Event;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.EventTriggerMatcher;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.model.job.SQSJob;
import hudson.plugins.git.BranchSpec;
import hudson.plugins.git.GitSCM;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.collections.CollectionUtils;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.jenkinsci.plugins.multiplescms.MultiSCM;

public class ScmJobEventTriggerMatcher
implements EventTriggerMatcher {
    private static final Log log = Log.get(ScmJobEventTriggerMatcher.class);

    @Override
    public boolean matches(List<Event> events, SQSJob job) {
        SQSTrigger trigger = job.getTrigger();
        ArrayList<SQSScmConfig> scmConfigs = new ArrayList<SQSScmConfig>();
        List<SQSScmConfig> triggerScms = trigger.getSqsScmConfigs();
        if (CollectionUtils.isNotEmpty(triggerScms)) {
            scmConfigs.addAll(triggerScms);
        }
        if (trigger.isSubscribeInternalScm()) {
            scmConfigs.add(new SQSScmConfig(SQSScmConfig.Type.AutoSubscription.name(), null, null));
        }
        ArrayList<Object> scms = new ArrayList<Object>();
        for (SQSScmConfig sQSScmConfig : scmConfigs) {
            switch (sQSScmConfig.getType()) {
                case AutoSubscription: {
                    scms.addAll(job.getScmList());
                    break;
                }
                case ManualSubscription: {
                    scms.add(sQSScmConfig.toGitSCM());
                }
            }
        }
        log.debug("Events size: %d, SCMs size: %d", job, events.size(), scms.size());
        for (SCM sCM : scms) {
            if (sCM.getClass().isAssignableFrom(NullSCM.class)) {
                log.debug("NullSCM detected, continue match next SCM", job, new Object[0]);
                continue;
            }
            for (Event event : events) {
                log.debug("Matching event %s with SCM %s", event, sCM.getKey());
                if (!this.matches(event, sCM)) continue;
                log.debug("Hurray! Event %s matched SCM %s", job, event.getArn(), sCM.getKey());
                return true;
            }
        }
        log.debug("No event matched", job, new Object[0]);
        return false;
    }

    private boolean matches(Event event, SCM scm) {
        if (event == null || scm == null) {
            return false;
        }
        if (this.isGitScmAvailable() && this.matchesGitSCM(event, scm)) {
            return true;
        }
        return this.isMultiScmAvailable() && this.matchesMultiSCM(event, scm);
    }

    private boolean matchesGitSCM(Event event, SCM scmProvider) {
        if (!(scmProvider instanceof GitSCM)) {
            return false;
        }
        GitSCM git = (GitSCM)scmProvider;
        List configs = git.getRepositories();
        boolean matched = this.matchesConfigs(event, configs);
        matched = matched && this.matchBranch(event, git.getBranches());
        return matched;
    }

    private boolean matchesMultiSCM(Event event, SCM scmProvider) {
        if (!(scmProvider instanceof MultiSCM)) {
            return false;
        }
        MultiSCM multiSCM = (MultiSCM)scmProvider;
        List scms = multiSCM.getConfiguredSCMs();
        for (SCM scm : scms) {
            if (!this.matches(event, scm)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesConfigs(Event event, List<RemoteConfig> configs) {
        for (RemoteConfig config : configs) {
            if (!this.matchesConfig(event, config)) continue;
            return true;
        }
        return false;
    }

    private boolean matchBranch(Event event, List<BranchSpec> branchSpecs) {
        for (BranchSpec branchSpec : branchSpecs) {
            log.debug("branchSpec= %s", branchSpec.toString());
            if (branchSpec.matches(event.getBranch())) {
                log.info("Event branch: %s matched branch: %s", event.getBranch(), branchSpec.getName());
                return true;
            }
            if (!branchSpec.matches(event.getNoPrefixBranch())) continue;
            log.info("Event no-prefix-branch: %s matched branch: %s", event.getNoPrefixBranch(), branchSpec.getName());
            return true;
        }
        log.info("Found no event matched any branch", event.getArn());
        return false;
    }

    private boolean matchesConfig(Event event, RemoteConfig config) {
        return this.getMatchesConfig(event, config) != null;
    }

    private URIish getMatchesConfig(Event event, RemoteConfig config) {
        List uris = config.getURIs();
        for (URIish uri : uris) {
            log.debug("Event-arn= %s ; uri= %s", event.getArn(), uri);
            if (!event.isMatch(uri)) continue;
            log.info("Event matched uri %s", uri);
            return uri;
        }
        log.info("Found no event matched config: ", event.getArn(), config.getName());
        return null;
    }

    private boolean isMultiScmAvailable() {
        Jenkins jenkins = Jenkins.get();
        boolean hasPlugin = jenkins.getPlugin("multiple-scms") != null;
        log.debug("Multiple-SCMs plugin found: %s", hasPlugin);
        return hasPlugin;
    }

    private boolean isGitScmAvailable() {
        Jenkins jenkins = Jenkins.get();
        boolean hasPlugin = jenkins.getPlugin("git") != null;
        log.debug("Git plugin found: %s", hasPlugin);
        return hasPlugin;
    }
}

