/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger.factories;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.builder.ExecutorFactory;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.AmazonSQSAsyncClientBuilder;
import com.amazonaws.services.sqs.buffered.AmazonSQSBufferedAsyncClient;
import com.amazonaws.services.sqs.buffered.QueueBufferConfig;
import com.google.inject.Inject;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSExecutorFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueueMonitor;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.RequestFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.SQSChannel;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.SQSChannelImpl;
import com.ribose.jenkins.plugin.awscodecommittrigger.threading.SQSQueueMonitorImpl;
import com.ribose.jenkins.plugin.awscodecommittrigger.utils.StringUtils;
import hudson.ProxyConfiguration;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;

public class SQSFactoryImpl
implements SQSFactory {
    private static final Log log = Log.get(SQSFactoryImpl.class);
    private final RequestFactory factory;
    private final SQSExecutorFactory SQSExecutorFactory;

    @Inject
    public SQSFactoryImpl(SQSExecutorFactory SQSExecutorFactory2, RequestFactory factory) {
        this.SQSExecutorFactory = SQSExecutorFactory2;
        this.factory = factory;
    }

    @Override
    public AmazonSQS createSQSAsync(SQSQueue queue) {
        DefaultAWSCredentialsProviderChain credentials = queue.hasCredentials() ? queue.lookupAwsCredentials() : DefaultAWSCredentialsProviderChain.getInstance();
        AmazonSQSAsyncClientBuilder sqsAsyncBuilder = this.createStandardAsyncClientBuilder(queue, (AWSCredentialsProvider)credentials);
        QueueBufferConfig queueBufferConfig = this.getQueueBufferConfig(queue);
        AmazonSQSBufferedAsyncClient sqsBufferedAsync = new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)sqsAsyncBuilder.build(), queueBufferConfig);
        return sqsBufferedAsync;
    }

    @Override
    public AmazonSQS createSQSAsync(String accessKey, String secretKey) {
        AmazonSQSAsyncClientBuilder sqsAsyncBuilder = this.createStandardAsyncClientBuilder(null, (AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)));
        QueueBufferConfig queueBufferConfig = this.getQueueBufferConfig(null);
        AmazonSQSBufferedAsyncClient sqsBufferedAsync = new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)sqsAsyncBuilder.build(), queueBufferConfig);
        return sqsBufferedAsync;
    }

    @Override
    public AmazonSQS createSQSAsync(String accessKey, String secretKey, String region) {
        AmazonSQSAsyncClientBuilder sqsAsyncBuilder = this.createStandardAsyncClientBuilder(null, (AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(accessKey, secretKey)));
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)region)) {
            sqsAsyncBuilder.withRegion(Regions.valueOf((String)region));
        }
        QueueBufferConfig queueBufferConfig = this.getQueueBufferConfig(null);
        AmazonSQSBufferedAsyncClient sqsBufferedAsync = new AmazonSQSBufferedAsyncClient((AmazonSQSAsync)sqsAsyncBuilder.build(), queueBufferConfig);
        return sqsBufferedAsync;
    }

    private AmazonSQSAsyncClientBuilder createStandardAsyncClientBuilder(SQSQueue queue, AWSCredentialsProvider credentials) {
        Regions region;
        ClientConfiguration clientConfiguration = this.getClientConfiguration(queue);
        AmazonSQSAsyncClientBuilder builder = (AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)((AmazonSQSAsyncClientBuilder)AmazonSQSAsyncClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials(credentials)).withExecutorFactory((ExecutorFactory)this.SQSExecutorFactory);
        if (queue != null && (region = queue.getRegion()) != null) {
            builder.withRegion(region);
        }
        return builder;
    }

    private SQSChannel createChannel(SQSQueue queue) {
        AmazonSQS sqs = this.createSQSAsync(queue);
        return new SQSChannelImpl(sqs, queue, this.factory);
    }

    @Override
    public SQSQueueMonitor createMonitor(ExecutorService executor, SQSQueue queue) {
        AmazonSQS sqs = this.createSQSAsync(queue);
        SQSChannelImpl channel = new SQSChannelImpl(sqs, queue, this.factory);
        SQSQueueMonitorImpl monitor = new SQSQueueMonitorImpl(executor, queue, channel);
        return monitor;
    }

    @Override
    public SQSQueueMonitor createMonitor(SQSQueueMonitor monitor, SQSQueue queue) {
        SQSChannel channel = this.createChannel(queue);
        return monitor.clone(queue, channel);
    }

    private ClientConfiguration getClientConfiguration(@Nullable SQSQueue queue) {
        ProxyConfiguration proxyConfig = Jenkins.getActiveInstance().proxy;
        String proxyUrl = queue == null ? "sqs.*.amazonaws.com" : StringUtils.getSqsEndpoint(queue.getUrl());
        Proxy proxy = proxyConfig == null ? Proxy.NO_PROXY : proxyConfig.createProxy(proxyUrl);
        return this.getClientConfiguration(proxy);
    }

    @Override
    public ClientConfiguration getClientConfiguration(Proxy proxy) {
        ClientConfiguration config = PredefinedClientConfigurations.defaultConfig();
        if (!Proxy.NO_PROXY.equals(proxy) && proxy.address() instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            config.setProxyHost(address.getHostName());
            config.setProxyPort(address.getPort());
            ProxyConfiguration proxyConfig = Jenkins.getActiveInstance().proxy;
            if (org.apache.commons.lang.StringUtils.isNotBlank((String)proxyConfig.getUserName())) {
                config.setProxyUsername(proxyConfig.getUserName());
                config.setProxyPassword(proxyConfig.getPassword());
            }
            log.debug("Proxy settings for SQS: %s:%s", config.getProxyHost(), config.getProxyPort());
        }
        return config;
    }

    private QueueBufferConfig getQueueBufferConfig(SQSQueue queue) {
        QueueBufferConfig config = new QueueBufferConfig();
        config.setLongPollWaitTimeoutSeconds(queue == null ? 20 : queue.getWaitTimeSeconds());
        config.setLongPoll(true);
        return config;
    }
}

