/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.sqs.AmazonSQS;
import com.amazonaws.services.sqs.model.DeleteMessageBatchRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.ribose.jenkins.plugin.awscodecommittrigger.Context;
import com.ribose.jenkins.plugin.awscodecommittrigger.credentials.AwsCredentialsHelper;
import com.ribose.jenkins.plugin.awscodecommittrigger.exception.UnexpectedException;
import com.ribose.jenkins.plugin.awscodecommittrigger.i18n.sqstriggerqueue.Messages;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.interfaces.SQSQueue;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import com.ribose.jenkins.plugin.awscodecommittrigger.net.RequestFactory;
import com.ribose.jenkins.plugin.awscodecommittrigger.utils.StringUtils;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;

public class SQSTriggerQueue
extends AbstractDescribableImpl<SQSTriggerQueue>
implements SQSQueue {
    private static final Log log = Log.get(SQSTriggerQueue.class);
    private String version;
    private String uuid;
    private Integer waitTimeSeconds;
    private Integer maxNumberOfMessages;
    private String url;
    private String credentialsId;
    private Regions region = null;
    private transient SQSFactory sqsFactory;
    private transient AmazonSQS sqs;
    private transient boolean compatible;

    @DataBoundConstructor
    public SQSTriggerQueue(String uuid, String region, String url, String credentialsId, Integer waitTimeSeconds, Integer maxNumberOfMessages, String version) {
        this.version = version;
        String string = this.uuid = org.apache.commons.lang.StringUtils.isBlank((String)uuid) ? UUID.randomUUID().toString() : uuid;
        if (org.apache.commons.lang.StringUtils.isNotBlank((String)region)) {
            this.region = Regions.valueOf((String)region);
        }
        this.url = url;
        this.credentialsId = credentialsId;
        this.waitTimeSeconds = this.limit(waitTimeSeconds, 1, 20, 20);
        this.maxNumberOfMessages = this.limit(maxNumberOfMessages, 1, 10, 10);
        log.debug("Create new SQSTriggerQueue(%s, %s)", this.uuid, this.url);
    }

    public AmazonSQS getSQSClient() {
        if (this.sqs == null) {
            this.sqs = this.getSqsFactory().createSQSAsync(this);
        }
        return this.sqs;
    }

    public SQSFactory getSqsFactory() {
        return this.sqsFactory;
    }

    public void setRegion(Regions region) {
        this.region = region;
    }

    public void setSqsFactory(SQSFactory sqsFactory) {
        this.sqsFactory = sqsFactory;
    }

    public void setSqs(AmazonSQS sqs) {
        this.sqs = sqs;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public void setWaitTimeSeconds(Integer waitTimeSeconds) {
        this.waitTimeSeconds = waitTimeSeconds;
    }

    public void setMaxNumberOfMessages(Integer maxNumberOfMessages) {
        this.maxNumberOfMessages = maxNumberOfMessages;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setCompatible(boolean compatible) {
        this.compatible = compatible;
    }

    public boolean isCompatible() {
        return this.compatible;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    public int getWaitTimeSeconds() {
        if (this.waitTimeSeconds == null) {
            return 20;
        }
        return this.waitTimeSeconds;
    }

    @Override
    public int getMaxNumberOfMessages() {
        if (this.maxNumberOfMessages == null) {
            return 10;
        }
        return this.maxNumberOfMessages;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public String getName() {
        return StringUtils.getSqsQueueName(this.url);
    }

    @Override
    @CheckForNull
    public AmazonWebServicesCredentials lookupAwsCredentials() {
        if (this.credentialsId == null) {
            return null;
        }
        return AwsCredentialsHelper.getCredentials(this.credentialsId);
    }

    @Override
    public boolean hasCredentials() {
        return org.apache.commons.lang.StringUtils.isNotBlank((String)this.credentialsId);
    }

    @Override
    public Regions getRegion() {
        return this.region;
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQSTriggerQueue)) {
            return false;
        }
        SQSTriggerQueue other = (SQSTriggerQueue)obj;
        return this.uuid.equals(other.uuid);
    }

    private int limit(Integer value, int min, int max, int fallbackValue) {
        if (value == null || value < min || value > max) {
            return fallbackValue;
        }
        return value;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SQSTriggerQueue> {
        private transient SQSFactory sqsFactory = (SQSFactory)Context.injector().getBinding(SQSFactory.class).getProvider().get();
        private transient RequestFactory requestFactory = (RequestFactory)Context.injector().getBinding(RequestFactory.class).getProvider().get();

        public DescriptorImpl() {
            this.load();
        }

        public String getDisplayName() {
            return Messages.displayName();
        }

        public FormValidation doCheckWaitTimeSeconds(@QueryParameter String value) {
            return this.validateNumber(value, 1, 20, Messages.errorWaitTimeSeconds());
        }

        public FormValidation doCheckMaxNumberOfMessage(@QueryParameter String value) {
            return this.validateNumber(value, 1, 10, Messages.errorMaxNumberOfMessages());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FormValidation doValidate(@QueryParameter String region, @QueryParameter String url, @QueryParameter String credentialsId) throws IOException, ServletException {
            if (org.apache.commons.lang.StringUtils.isBlank((String)credentialsId)) {
                return FormValidation.warning((String)"No Credential selected");
            }
            AmazonWebServicesCredentials credentials = AwsCredentialsHelper.getCredentials(credentialsId);
            if (credentials == null) {
                return FormValidation.error((String)"Credentials is null");
            }
            AWSCredentials awsCred = credentials.getCredentials();
            AmazonSQS client = this.sqsFactory.createSQSAsync(awsCred.getAWSAccessKeyId(), awsCred.getAWSSecretKey(), region);
            String queueName = StringUtils.getSqsQueueName(url);
            boolean hasReadPermission = false;
            try {
                ReceiveMessageRequest receiveMessageRequest = this.requestFactory.createReceiveMessageRequest(url, 1, 20);
                client.receiveMessage(receiveMessageRequest);
                hasReadPermission = true;
                DeleteMessageBatchRequest deleteMessageBatchRequest = this.requestFactory.createDeleteMessageBatchRequest(url, Collections.singletonList(new Message()));
                client.deleteMessageBatch(deleteMessageBatchRequest);
            }
            catch (AmazonServiceException e) {
                log.debug(e.getMessage(), new Object[]{e});
                switch (e.getStatusCode()) {
                    case 403: {
                        if (hasReadPermission) {
                            FormValidation formValidation = FormValidation.errorWithMarkup((String)"<span class=\"error\">User does not have <i>sqs:DeleteMessageBatch</i> permission</span>");
                            return formValidation;
                        }
                        FormValidation formValidation = FormValidation.errorWithMarkup((String)"<span class=\"error\">User does not have <i>sqs:ReceiveMessage</i> permission</span>");
                        return formValidation;
                    }
                    case 400: {
                        FormValidation formValidation = FormValidation.okWithMarkup((String)String.format("<span class=\"info\">Access to %s successful</span>", queueName));
                        return formValidation;
                    }
                }
                FormValidation formValidation = FormValidation.error((Throwable)e, (String)e.getMessage());
                return formValidation;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
                FormValidation formValidation = FormValidation.error((Throwable)e, (String)String.format("Error validating %s access", queueName));
                return formValidation;
            }
            finally {
                client.shutdown();
            }
            return FormValidation.error((String)"Unknown error");
        }

        public ListBoxModel doFillRegionItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("", "");
            for (Regions region : Regions.values()) {
                Region r = Region.getRegion((Regions)region);
                if (!r.isServiceSupported("sqs") || !r.isServiceSupported("codecommit")) continue;
                items.add(region.getName(), region.name());
            }
            return items;
        }

        public ListBoxModel doFillUrlItems(@QueryParameter String region, @QueryParameter String credentialsId) throws IOException {
            ListBoxModel items = new ListBoxModel();
            try {
                AmazonWebServicesCredentials credentials = AwsCredentialsHelper.getCredentials(credentialsId);
                if (credentials == null) {
                    throw new UnexpectedException("Unable to find credentials: " + credentialsId);
                }
                AWSCredentials awsCred = credentials.getCredentials();
                String key = awsCred.getAWSAccessKeyId();
                String secret = awsCred.getAWSSecretKey();
                AmazonSQS client = this.sqsFactory.createSQSAsync(key, secret, region);
                List queueUrls = client.listQueues().getQueueUrls();
                for (String queueUrl : queueUrls) {
                    items.add(StringUtils.getSqsQueueName(queueUrl), queueUrl);
                }
            }
            catch (AmazonServiceException e) {
                Stapler.getCurrentResponse().sendError(e.getStatusCode(), e.getErrorMessage());
            }
            catch (Exception e) {
                items.clear();
            }
            return items;
        }

        private FormValidation validateNumber(String value, int min, int max, String message) {
            try {
                if (org.apache.commons.lang.StringUtils.isBlank((String)value)) {
                    return FormValidation.error((String)message);
                }
                int number = Integer.parseInt(value);
                if (number < min || number > max) {
                    return FormValidation.error((String)message);
                }
                return FormValidation.ok();
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)message);
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            return new StandardListBoxModel().includeEmptyValue().includeAs(ACL.SYSTEM, context, AmazonWebServicesCredentials.class).includeCurrentValue(credentialsId);
        }

        public String getVersion() {
            return "3.0.12";
        }

        public void setSqsFactory(SQSFactory sqsFactory) {
            this.sqsFactory = sqsFactory;
        }

        public void setRequestFactory(RequestFactory requestFactory) {
            this.requestFactory = requestFactory;
        }
    }
}

