/*
 * Decompiled with CFR 0.152.
 */
package com.ribose.jenkins.plugin.awscodecommittrigger;

import com.ribose.jenkins.plugin.awscodecommittrigger.exception.UnexpectedException;
import com.ribose.jenkins.plugin.awscodecommittrigger.logging.Log;
import hudson.model.Action;
import hudson.model.Job;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.servlet.ServletException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.lang.time.FastDateFormat;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RespondSuccess;

public class SQSActivityAction
implements Action {
    private static final Log log = Log.get(SQSActivityAction.class);
    private static final FastDateFormat df = FastDateFormat.getInstance((String)"yyyyMMdd");
    private final transient Job job;
    private final transient File activityDir;

    public SQSActivityAction(Job job) {
        this.job = job;
        this.activityDir = new File(this.job.getRootDir(), ".activity");
        if (!this.activityDir.exists() && !this.activityDir.mkdirs()) {
            log.error("Unable to create trigger activity dir %s", this.activityDir.getPath());
        }
        log.debug("Activity dir %s is writeable? %s", this.activityDir.getPath(), this.activityDir.canWrite());
    }

    public String getIconFileName() {
        return "clipboard.png";
    }

    @Nonnull
    public String getDisplayName() {
        return "SQS Activity";
    }

    public String getUrlName() {
        return this.getDisplayName().toLowerCase().replace(" ", "-");
    }

    public File getActivityDir() {
        return this.activityDir;
    }

    public List<String> getLogNames() {
        ArrayList<String> names = new ArrayList<String>();
        File[] files = this.activityDir.listFiles();
        if (files != null) {
            Arrays.sort(files, NameFileComparator.NAME_REVERSE);
            for (File file : files) {
                names.add(file.getName());
            }
        }
        return names;
    }

    @RespondSuccess
    public void doDownload() throws IOException, ServletException {
        StaplerRequest request = Stapler.getCurrentRequest();
        StaplerResponse response = Stapler.getCurrentResponse();
        String name = request.getRestOfPath();
        File file = new File(this.activityDir.getPath() + "/" + name);
        if (file.exists()) {
            FileInputStream is = FileUtils.openInputStream((File)file);
            response.serveFile(request, (InputStream)is, 0L, 60000L, file.length(), name);
        } else {
            response.setStatus(404);
            response.getOutputStream().println("sorry, we not found it " + name.replace("/", ""));
        }
    }

    public Job getJob() {
        return this.job;
    }

    public FormValidation doClear() {
        try {
            FileUtils.cleanDirectory((File)this.activityDir);
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Unable clear Activity");
        }
        return FormValidation.ok((String)"Done. Please refresh the page.");
    }

    public File getActivityLogFile() {
        String date = df.format(new Date());
        String logPath = String.format("%s/activities-on-%s.log", this.getActivityDir().getPath(), date);
        File logFile = new File(logPath);
        if (!logFile.exists()) {
            try {
                FileUtils.write((File)logFile, (CharSequence)"", (String)"UTF-8");
            }
            catch (IOException e) {
                throw new UnexpectedException("Unable to create activity file: " + logPath, e);
            }
        }
        return logFile;
    }
}

