/*
 * Decompiled with CFR 0.152.
 */
package wirelabs.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.autocompleteparameter.JSONUtils;
import wirelabs.commons.CredentialsUtils;
import wirelabs.commons.ExpirableCache;
import wirelabs.commons.ExpirableCacheRepopulator;
import wirelabs.commons.RequestResponse;

public class RequestBuilder {
    private HttpURLConnection conn;
    private String body;
    private String url;
    private int lowerAcceptableStatus = 200;
    private int upperAcceptableStatus = 399;
    private StringBuilder signatureContent = new StringBuilder();
    private static ExpirableCache<RequestResponse> requestCache = new ExpirableCache(3000L);
    private long enableCacheForMs = 0L;

    public static RequestBuilder url(String url) {
        return new RequestBuilder(url);
    }

    public RequestBuilder() {
    }

    public RequestBuilder(String url) {
        this.url = url;
        this.signatureContent.append(url);
        try {
            this.conn = (HttpURLConnection)new URL(url).openConnection();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RequestBuilder cache() {
        this.enableCacheForMs = 3000L;
        return this;
    }

    public RequestBuilder cache(long ttlInMs) {
        this.enableCacheForMs = ttlInMs;
        return this;
    }

    public RequestBuilder header(String key, String value) {
        this.signatureContent.append(key + ":" + value);
        this.conn.addRequestProperty(key, value);
        return this;
    }

    public RequestBuilder credentials(String credentialsId) {
        this.signatureContent.append(credentialsId);
        CredentialsUtils.addAuth(this.url, credentialsId, this.conn);
        return this;
    }

    public RequestBuilder body(Object body) {
        this.body = body instanceof String ? body.toString() : JSONUtils.toJSON(body);
        this.signatureContent.append(this.body);
        return this;
    }

    public void acceptableRange(int from, int to) {
        this.lowerAcceptableStatus = from;
        this.upperAcceptableStatus = to;
    }

    public RequestResponse post() {
        return this.doRequest("POST");
    }

    public RequestResponse put() {
        return this.doRequest("PUT");
    }

    public RequestResponse patch() {
        return this.doRequest("PATCH");
    }

    public RequestResponse get() {
        return this.doRequest("GET");
    }

    public RequestResponse delete() {
        return this.doRequest("DELETE");
    }

    private RequestResponse doRequest(final String method) {
        this.signatureContent.append(method);
        if (this.enableCacheForMs == 0L) {
            return this.doActualRequest(method);
        }
        return requestCache.get(this.md5OrCry(), this.enableCacheForMs, new ExpirableCacheRepopulator<RequestResponse>(){

            @Override
            public RequestResponse call(RequestResponse expiredValue) {
                return RequestBuilder.this.doActualRequest(method);
            }
        });
    }

    private String md5OrCry() {
        try {
            return new String(MessageDigest.getInstance("MD5").digest(this.signatureContent.toString().getBytes("UTF-8")), "UTF-8");
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private RequestResponse doActualRequest(String method) {
        OutputStreamWriter writer = null;
        try {
            String content;
            this.conn.setRequestMethod(method);
            if (!StringUtils.isEmpty((String)this.body)) {
                this.conn.setDoOutput(true);
                writer = new OutputStreamWriter(this.conn.getOutputStream(), "UTF-8");
                writer.write(this.body);
                writer.flush();
            }
            int responseCode = this.conn.getResponseCode();
            try {
                content = IOUtils.toString((InputStream)this.conn.getInputStream(), (String)"UTF-8");
            }
            catch (IOException e) {
                content = e.getMessage();
            }
            if (responseCode < this.lowerAcceptableStatus || responseCode > this.upperAcceptableStatus) {
                throw new IllegalStateException("Failed : HTTP error code : " + responseCode);
            }
            RequestResponse requestResponse = new RequestResponse(responseCode, content, this.conn.getHeaderFields());
            return requestResponse;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

