/*
 * Decompiled with CFR 0.152.
 */
package jenkins.authentication.tokens.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.LinkedHashMap;
import java.util.Map;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class AuthenticationTokenContext<T> {
    @NonNull
    private final Class<T> tokenClass;
    @CheckForNull
    private final Map<Object, Object> purposes;

    public AuthenticationTokenContext(@NonNull Class<T> tokenClass) {
        this(tokenClass, null);
    }

    private AuthenticationTokenContext(@NonNull Class<T> tokenClass, @CheckForNull Map<Object, Object> purposes) {
        this.tokenClass = tokenClass;
        this.purposes = purposes;
    }

    public static <T> Builder<T> builder(@NonNull Class<T> tokenClass) {
        return new Builder(tokenClass);
    }

    @NonNull
    public Class<T> getTokenClass() {
        return this.tokenClass;
    }

    public boolean canHave(@NonNull Object purpose, Object ... validValues) {
        if (this.purposes == null || !this.purposes.containsKey(purpose)) {
            return true;
        }
        Object value = this.purposes.get(purpose);
        for (Object valid : validValues) {
            if (!(value == null ? valid == null : value.equals(valid))) continue;
            return true;
        }
        return false;
    }

    public boolean mustHave(@NonNull Object purpose, Object ... validValues) {
        if (this.purposes == null || !this.purposes.containsKey(purpose)) {
            return false;
        }
        Object value = this.purposes.get(purpose);
        for (Object valid : validValues) {
            if (!(value == null ? valid == null : value.equals(valid))) continue;
            return true;
        }
        return false;
    }

    @NotThreadSafe
    public static final class Builder<T> {
        @NonNull
        private final Class<T> tokenClass;
        @CheckForNull
        private Map<Object, Object> purposes = null;

        private Builder(@NonNull Class<T> tokenClass) {
            this.tokenClass = tokenClass;
        }

        @NonNull
        public Builder<T> with(@NonNull Object purpose) {
            return this.with(purpose, Boolean.TRUE);
        }

        @NonNull
        public Builder<T> with(@NonNull Object purpose, @CheckForNull Object value) {
            if (this.purposes == null) {
                this.purposes = new LinkedHashMap<Object, Object>();
            }
            this.purposes.put(purpose, value);
            return this;
        }

        @NonNull
        public AuthenticationTokenContext<T> build() {
            return new AuthenticationTokenContext(this.tokenClass, this.purposes == null || this.purposes.isEmpty() ? null : this.purposes);
        }
    }
}

