/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AuditLogger;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.kohsuke.stapler.DataBoundConstructor;

public class LogFileAuditLogger
extends AuditLogger {
    private static final Logger LOGGER = Logger.getLogger(LogFileAuditLogger.class.getName());
    static final String DEFAULT_LOG_SEPARATOR = " ";
    @Nonnull
    private String logSeparator;
    private transient FileHandler handler;
    private String log;
    private int limit = 1;
    private int count = 1;

    @DataBoundConstructor
    public LogFileAuditLogger(String log, int limit, int count, String logSeparator) {
        this.log = log;
        this.limit = limit;
        this.count = count;
        this.logSeparator = Optional.ofNullable(logSeparator).orElse(DEFAULT_LOG_SEPARATOR);
        this.configure();
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="value can be null if no config file exists")
    private Object readResolve() {
        if (this.logSeparator == null) {
            this.logSeparator = DEFAULT_LOG_SEPARATOR;
        }
        this.configure();
        return this;
    }

    @Override
    public void log(String event) {
        if (this.handler == null) {
            return;
        }
        this.handler.publish(new LogRecord(Level.CONFIG, event));
    }

    public String getLog() {
        return this.log;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    @Nonnull
    public String getLogSeparator() {
        return this.logSeparator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogFileAuditLogger)) {
            return false;
        }
        LogFileAuditLogger that = (LogFileAuditLogger)o;
        if (this.count != that.count) {
            return false;
        }
        if (this.limit != that.limit) {
            return false;
        }
        if (!this.logSeparator.equals(that.logSeparator)) {
            return false;
        }
        return !(this.log != null ? !this.log.equals(that.log) : that.log != null);
    }

    public int hashCode() {
        int result = this.log != null ? this.log.hashCode() : 0;
        result = 31 * result + this.limit;
        result = 31 * result + this.count;
        result = 31 * result + this.logSeparator.hashCode();
        return result;
    }

    private void configure() {
        try {
            FileHandler h;
            block6: {
                h = null;
                try {
                    h = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                }
                catch (NoSuchFileException ex) {
                    LOGGER.info("Couldn't create the file handler lock file, forcing creation of intermediate directories");
                    String lockFileName = ex.getFile();
                    boolean mkdirs = new File(lockFileName).getParentFile().mkdirs();
                    if (!mkdirs) break block6;
                    h = new FileHandler(this.log, this.limit * 1024 * 1024, this.count, true);
                }
            }
            if (h != null) {
                h.setFormatter(new Formatter(){
                    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy h:mm:ss,SSS aa");

                    @Override
                    public synchronized String format(LogRecord record) {
                        return this.dateFormat.format(new Date(record.getMillis())) + LogFileAuditLogger.this.getLogSeparator() + record.getMessage() + '\n';
                    }
                });
                h.setLevel(Level.CONFIG);
                this.handler = h;
            } else {
                LOGGER.severe("Couldn't configure the plugin, as the file handler wasn't successfully created. You should report this issue");
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "Couldn't configure the plugin, you should report this issue", ex);
        }
    }

    @Override
    public void cleanUp() throws SecurityException {
        if (this.handler != null) {
            this.handler.close();
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Log file";
        }
    }
}

