/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;

@Extension
public class AuditTrailRunListener
extends RunListener<Run> {
    private static final String MASKED = "****";
    @Inject
    AuditTrailPlugin configuration;

    public AuditTrailRunListener() {
        super(Run.class);
    }

    public void onStarted(Run run, TaskListener listener) {
        if (this.configuration.shouldLogBuildCause()) {
            StringBuilder builder = new StringBuilder(100);
            this.dumpCauses(run, builder);
            this.dumpParameters(run, builder);
            for (AuditLogger logger : this.configuration.getLoggers()) {
                logger.log(run.getParent().getUrl() + " #" + run.getNumber() + ' ' + builder.toString());
            }
        }
    }

    public void onFinalized(Run run) {
        if (this.configuration.shouldLogBuildCause()) {
            StringBuilder builder = new StringBuilder(100);
            this.dumpCauses(run, builder);
            this.dumpParameters(run, builder);
            for (AuditLogger logger : this.configuration.getLoggers()) {
                String message = run.getFullDisplayName() + " " + builder.toString() + " on node " + this.buildNodeName(run) + " started at " + run.getTimestampString2() + " completed in " + run.getDuration() + "ms completed: " + run.getResult();
                logger.log(message);
            }
        }
    }

    private void dumpParameters(Run<?, ?> run, StringBuilder builder) {
        builder.append(", Parameters:[");
        ParametersAction parameters = (ParametersAction)run.getAction(ParametersAction.class);
        if (parameters != null) {
            builder.append(StreamSupport.stream(parameters.spliterator(), false).map(this::prettyPrintParameter).collect(Collectors.joining(", ")));
        }
        builder.append("]");
    }

    private String prettyPrintParameter(ParameterValue param) {
        return param.getName() + ": {" + (param.isSensitive() ? MASKED : param.getValue()) + "}";
    }

    private void dumpCauses(Run<?, ?> run, StringBuilder buf) {
        for (CauseAction action : run.getActions(CauseAction.class)) {
            for (Cause cause : action.getCauses()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(cause.getShortDescription());
            }
        }
        if (buf.length() == 0) {
            buf.append("Started");
        }
    }

    private String buildNodeName(Run run) {
        Node node;
        if (run instanceof AbstractBuild && (node = ((AbstractBuild)run).getBuiltOn()) != null) {
            return node.getDisplayName();
        }
        return "#unknown#";
    }
}

