/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.google.inject.Injector;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.User;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;

@Extension
public class AuditTrailFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AuditTrailFilter.class.getName());
    private static Pattern uriPattern = null;
    @Inject
    private AuditTrailPlugin configuration;

    @Deprecated
    public AuditTrailFilter(AuditTrailPlugin plugin) {
        this.configuration = plugin;
    }

    public AuditTrailFilter() {
    }

    public void init(FilterConfig fc) {
    }

    static void setPattern(String pattern) throws PatternSyntaxException {
        uriPattern = Pattern.compile(pattern);
        LOGGER.log(Level.FINE, "set pattern to {0}", pattern);
    }

    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String uri = req.getPathInfo() == null ? req.getRequestURI().substring(req.getContextPath().length()) : req.getPathInfo();
        if (uriPattern != null && uriPattern.matcher(uri).matches()) {
            User user = User.current();
            String username = user != null ? user.getId() : req.getRemoteAddr();
            String extra = "";
            if (uri.startsWith("/queue/item/")) {
                extra = this.extractInfoFromQueueItem(uri);
            } else if (uri.startsWith("/queue/cancelItem")) {
                extra = this.getFormattedQueueItemUrlFromItemId(Integer.parseInt(req.getParameter("id")));
                uri = uri + "?" + req.getQueryString();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Audit request {0} by user {1}", new Object[]{uri, username});
            }
            this.onRequest(uri, extra, username);
        } else {
            LOGGER.log(Level.FINEST, "Skip audit for request {0}", uri);
        }
        chain.doFilter((ServletRequest)req, res);
    }

    private String extractInfoFromQueueItem(String uri) {
        try {
            int itemId = Integer.parseInt(uri.substring(12, uri.indexOf(47, 13)));
            return this.getFormattedQueueItemUrlFromItemId(itemId);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Error occurred while parsing queue item", e);
            return "";
        }
    }

    private String getFormattedQueueItemUrlFromItemId(int itemId) {
        return this.formatExtraInfoString(Jenkins.getInstance().getQueue().getItem((long)((long)itemId)).task.getUrl());
    }

    private String formatExtraInfoString(String toFormat) {
        return String.format(" (%s)", toFormat);
    }

    public void destroy() {
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws ServletException {
        Injector injector = Jenkins.getInstance().getInjector();
        if (injector == null) {
            return;
        }
        PluginServletFilter.addFilter((Filter)((Filter)injector.getInstance(AuditTrailFilter.class)));
    }

    private void onRequest(String uri, String extra, String username) {
        if (this.configuration != null) {
            for (AuditLogger logger : this.configuration.getLoggers()) {
                logger.log(uri + extra + " by " + username);
            }
        }
    }
}

