/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.util.ListBoxModel;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.kohsuke.stapler.DataBoundConstructor;

public class ConsoleAuditLogger
extends AuditLogger {
    private final Output output;
    private final String dateFormat;
    private final String logPrefix;
    private transient PrintStream out;
    private transient SimpleDateFormat sdf;
    private transient String logPrefixPadded;

    @DataBoundConstructor
    public ConsoleAuditLogger(Output output, String dateFormat, String logPrefix) {
        if (output == null) {
            throw new NullPointerException("output can not be null");
        }
        if (dateFormat == null) {
            throw new NullPointerException("dateFormat can not be null");
        }
        this.logPrefix = logPrefix;
        this.output = output;
        if (output != Output.STD_ERR && output != Output.STD_OUT) {
            throw new IllegalArgumentException("Unsupported output " + (Object)((Object)output));
        }
        this.dateFormat = dateFormat;
        new SimpleDateFormat(dateFormat);
        this.configure();
    }

    private Object readResolve() {
        this.configure();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String event) {
        Output output = this.output;
        synchronized (output) {
            this.out.println(this.sdf.format(new Date()) + this.logPrefixPadded + event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure() {
        Output output = this.output;
        synchronized (output) {
            switch (this.output) {
                case STD_ERR: {
                    this.out = System.err;
                    break;
                }
                case STD_OUT: {
                    this.out = System.out;
                }
            }
            this.sdf = new SimpleDateFormat(this.dateFormat);
            this.logPrefixPadded = this.getLogPrefixPadded();
        }
    }

    public Output getOutput() {
        return this.output;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getLogPrefix() {
        return this.logPrefix;
    }

    private Boolean hasLogPrefix() {
        return this.logPrefix != null && !this.logPrefix.equals("");
    }

    private String getLogPrefixPadded() {
        if (this.hasLogPrefix().booleanValue()) {
            if (this.logPrefixPadded == null) {
                this.logPrefixPadded = String.format(" - %s - ", this.getLogPrefix());
            }
            return this.logPrefixPadded;
        }
        return " - ";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConsoleAuditLogger)) {
            return false;
        }
        ConsoleAuditLogger that = (ConsoleAuditLogger)o;
        if (!this.dateFormat.equals(that.dateFormat)) {
            return false;
        }
        if (this.output != that.output) {
            return false;
        }
        return this.logPrefix.equals(that.logPrefix);
    }

    public int hashCode() {
        int result = this.output.hashCode();
        result = 31 * result + this.dateFormat.hashCode();
        result = 31 * result + this.logPrefix.hashCode();
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AuditLogger> {
        public String getDisplayName() {
            return "Console";
        }

        public ListBoxModel doFillOutputItems() {
            Output[] outputs;
            ListBoxModel items = new ListBoxModel();
            for (Output output : outputs = Output.values()) {
                items.add(output.name());
            }
            return items;
        }
    }

    public static enum Output {
        STD_OUT,
        STD_ERR;

    }
}

