/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.google.inject.Injector;
import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.User;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import hudson.util.PluginServletFilter;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;

@Extension
public class AuditTrailFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(AuditTrailFilter.class.getName());
    private static Pattern uriPattern = null;
    @Inject
    private AuditTrailPlugin configuration;

    @Deprecated
    public AuditTrailFilter(AuditTrailPlugin plugin) {
        this.configuration = plugin;
    }

    public AuditTrailFilter() {
    }

    public void init(FilterConfig fc) {
    }

    static void setPattern(String pattern) throws PatternSyntaxException {
        uriPattern = Pattern.compile(pattern);
        LOGGER.log(Level.FINE, "set pattern to {0}", pattern);
    }

    public void doFilter(ServletRequest request, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String uri = req.getPathInfo() == null ? req.getRequestURI().substring(req.getContextPath().length()) : req.getPathInfo();
        if (uriPattern != null && uriPattern.matcher(uri).matches()) {
            User user = User.current();
            String username = user != null ? user.getId() : req.getRemoteAddr();
            String extra = "";
            if (uri.startsWith("/queue/item/")) {
                try {
                    extra = " (" + Jenkins.getInstance().getQueue().getItem((long)((long)Integer.parseInt((String)uri.substring((int)12, (int)uri.indexOf((int)47, (int)13))))).task.getUrl() + ')';
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINEST, "Error occurred during parsing queue item", e);
                }
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Audit request {0} by user {1}", new Object[]{uri, username});
            }
            this.onRequest(uri, extra, username);
        } else {
            LOGGER.log(Level.FINEST, "Skip audit for request {0}", uri);
        }
        chain.doFilter((ServletRequest)req, res);
    }

    public void destroy() {
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void init() throws ServletException {
        Injector injector = Jenkins.getInstance().getInjector();
        if (injector == null) {
            return;
        }
        PluginServletFilter.addFilter((Filter)((Filter)injector.getInstance(AuditTrailFilter.class)));
    }

    private void onRequest(String uri, String extra, String username) {
        if (this.configuration != null) {
            for (AuditLogger logger : this.configuration.getLoggers()) {
                logger.log(uri + extra + " by " + username);
            }
        }
    }
}

