/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.assembla.api;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.jenkinsci.plugins.assembla.api.Method;
import org.jenkinsci.plugins.assembla.api.models.MergeRequest;
import org.jenkinsci.plugins.assembla.api.models.MergeRequestComment;
import org.jenkinsci.plugins.assembla.api.models.MergeRequestVersion;
import org.jenkinsci.plugins.assembla.api.models.Space;
import org.jenkinsci.plugins.assembla.api.models.SpaceTool;
import org.jenkinsci.plugins.assembla.api.models.Ticket;
import org.jenkinsci.plugins.assembla.api.models.TicketComment;
import org.jenkinsci.plugins.assembla.api.models.TicketCommentWrapper;
import org.jenkinsci.plugins.assembla.api.models.User;

public class AssemblaClient {
    private static final Logger LOGGER = Logger.getLogger(AssemblaClient.class.getName());
    private static final String DEFAULT_API_ENDPOINT = "https://api.assembla.com/";
    private static final String DEFAULT_ASSEMBLA_URL = "https://app.assembla.com/";
    private String assemblaHost;
    private String apiKey;
    private String apiSecret;
    private String apiEndpoint;
    private boolean ignoreSSLErrors;
    private Gson gson;

    public AssemblaClient(String apiKey, String apiSecret, String assemblaHost, boolean ignoreSSLErrors) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.assemblaHost = assemblaHost;
        this.gson = new GsonBuilder().create();
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.apiEndpoint = this.getApiEndpoint(assemblaHost);
    }

    public User getUser() {
        return (User)this.gson.fromJson(this.apiRequest("user", Method.GET), User.class);
    }

    public Space getSpace(String spaceName) {
        String requestPath = String.format("spaces/%s", spaceName);
        return (Space)this.gson.fromJson(this.apiRequest(requestPath, Method.GET), Space.class);
    }

    public SpaceTool getTool(String spaceName, String id) {
        String requestPath = String.format("spaces/%s/space_tools/%s", spaceName, id);
        return (SpaceTool)this.gson.fromJson(this.apiRequest(requestPath, Method.GET), SpaceTool.class);
    }

    public SpaceTool getRepoByUrl(String spaceName, String url) {
        for (SpaceTool tool : this.getRepos(spaceName)) {
            if (!tool.getUrl().equals(url)) continue;
            return tool;
        }
        return null;
    }

    public List<SpaceTool> getRepos(String spaceName) {
        String requestPath = "spaces/" + spaceName + "/space_tools/repo";
        Type listType = new TypeToken<ArrayList<SpaceTool>>(){}.getType();
        return (List)this.gson.fromJson(this.apiRequest(requestPath, Method.GET), listType);
    }

    public MergeRequest getMergeRequest(String spaceName, String toolId, int id) {
        String requestPath = "spaces/" + spaceName + "/space_tools/" + toolId + "/merge_requests/" + String.valueOf(id);
        return (MergeRequest)this.gson.fromJson(this.apiRequest(requestPath, Method.GET), MergeRequest.class);
    }

    public List<MergeRequestVersion> getMergeRequestVersions(MergeRequest mr) {
        String requestPath = String.format("spaces/%s/space_tools/%s/merge_requests/%s/versions", mr.getTargetSpaceId(), mr.getSpaceToolId(), String.valueOf(mr.getId()));
        Type listType = new TypeToken<ArrayList<MergeRequestVersion>>(){}.getType();
        return (List)this.gson.fromJson(this.apiRequest(requestPath, Method.GET), listType);
    }

    public String getMergeRequestWebUrl(MergeRequest mr) {
        String url = "";
        try {
            url = new URL(new URL(this.assemblaHost), String.format("/spaces/%s/%s/merge_requests/%s", mr.getTargetSpaceId(), mr.getSpaceToolId(), mr.getId())).toString();
        }
        catch (MalformedURLException e) {
            LOGGER.log(Level.SEVERE, "Invalid URL", e);
        }
        return url;
    }

    public List<Ticket> getMergeRequestTickets(MergeRequest mr) {
        String requestPath = String.format("spaces/%s/space_tools/%s/merge_requests/%s/tickets", mr.getTargetSpaceId(), mr.getSpaceToolId(), String.valueOf(mr.getId()));
        Type listType = new TypeToken<ArrayList<Ticket>>(){}.getType();
        String response = this.apiRequest(requestPath, Method.GET);
        ArrayList tickets = (ArrayList)this.gson.fromJson(response, listType);
        if (tickets == null) {
            tickets = new ArrayList();
        }
        return tickets;
    }

    public void createTicketComment(Ticket ticket, String commentText) {
        TicketCommentWrapper comment = new TicketCommentWrapper(new TicketComment(commentText));
        String requestPath = String.format("spaces/%s/tickets/%s/ticket_comments", ticket.getSpaceId(), ticket.getNumber());
        this.apiRequest(requestPath, Method.POST, this.gson.toJson((Object)comment));
    }

    public MergeRequestVersion getLatestVersion(MergeRequest mr) {
        for (MergeRequestVersion mrVersion : this.getMergeRequestVersions(mr)) {
            if (!mrVersion.isLatest()) continue;
            return mrVersion;
        }
        return null;
    }

    public void upVoteMergeRequest(MergeRequest mr, MergeRequestVersion version) {
        String requestPath = String.format("spaces/%s/space_tools/%s/merge_requests/%s/versions/%s/votes/upvote", mr.getTargetSpaceId(), mr.getSpaceToolId(), String.valueOf(version.getMergeRequestId()), version.getVersion());
        this.apiRequest(requestPath, Method.POST);
    }

    public void downVoteMergeRequest(MergeRequest mr, MergeRequestVersion version) {
        String requestPath = String.format("spaces/%s/space_tools/%s/merge_requests/%s/versions/%s/votes/downvote", mr.getTargetSpaceId(), mr.getSpaceToolId(), String.valueOf(version.getMergeRequestId()), version.getVersion());
        this.apiRequest(requestPath, Method.POST);
    }

    public void commentMergeRequest(MergeRequest mr, MergeRequestVersion version, String commentText) {
        MergeRequestComment comment = new MergeRequestComment(commentText);
        String requestPath = String.format("spaces/%s/space_tools/%s/merge_requests/%s/versions/%s/comments", mr.getTargetSpaceId(), mr.getSpaceToolId(), String.valueOf(version.getMergeRequestId()), version.getVersion());
        this.apiRequest(requestPath, Method.POST, this.gson.toJson((Object)comment));
    }

    public AssemblaClient setConfig(String apiKey, String apiSecret, String assemblaHost, boolean ignoreSSLErrors) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.assemblaHost = assemblaHost;
        this.ignoreSSLErrors = ignoreSSLErrors;
        this.apiEndpoint = this.getApiEndpoint(assemblaHost);
        return this;
    }

    private CloseableHttpClient getClient() {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (this.ignoreSSLErrors) {
            try {
                SSLContextBuilder builder = SSLContexts.custom();
                builder.loadTrustMaterial(null, new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                });
                SSLContext sslContext = builder.build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new X509HostnameVerifier(){

                    public void verify(String host, SSLSocket ssl) throws IOException {
                    }

                    public void verify(String host, X509Certificate cert) throws SSLException {
                    }

                    public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                    }

                    public boolean verify(String s, SSLSession sslSession) {
                        return true;
                    }
                });
                Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslsf).build();
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
                clientBuilder.setConnectionManager((HttpClientConnectionManager)cm);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                LOGGER.log(Level.SEVERE, "Failed to initialize HttpClient", e);
            }
        }
        return clientBuilder.build();
    }

    private String apiRequest(String path, Method requestMethod, Object body) {
        HttpGet method;
        String url = this.getRequestUrl(path);
        String responseBody = "";
        if (requestMethod == Method.GET) {
            method = new HttpGet(url);
        } else {
            HttpPost postMethod = new HttpPost(url);
            if (body != null) {
                LOGGER.info("Sending payload: " + body.toString());
                postMethod.setEntity((HttpEntity)new StringEntity(body.toString(), ContentType.APPLICATION_JSON));
            }
            method = postMethod;
        }
        method.setHeader("Content-type", "application/json");
        method.setHeader("X-Api-Key", this.apiKey);
        method.setHeader("X-Api-Secret", this.apiSecret);
        try (CloseableHttpClient client = this.getClient();){
            HttpEntity httpEntity;
            LOGGER.info("Starting " + method.getMethod() + " " + url + " request to Assembla API");
            CloseableHttpResponse response = client.execute((HttpUriRequest)method);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200 && statusCode != 201 && statusCode != 204) {
                LOGGER.severe("Request for " + url + " failed, server returned: " + response.getStatusLine());
            }
            if ((httpEntity = response.getEntity()) != null) {
                responseBody = IOUtils.toString((InputStream)httpEntity.getContent());
                LOGGER.info("Assembla API response: " + responseBody);
            }
            if (statusCode == 404) {
                throw new NotFoundError(url, responseBody);
            }
            if (statusCode == 401) {
                throw new UnauthorizedError();
            }
            if (statusCode == 403) {
                throw new ForbiddenError();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Network failure", e);
        }
        return responseBody;
    }

    private String apiRequest(String path, Method requestMethod) {
        return this.apiRequest(path, requestMethod, null);
    }

    private String getRequestUrl(String path) {
        return this.mergeUrl(this.apiEndpoint, path);
    }

    private String getApiEndpoint(String assemblaHost) {
        String endpoint = assemblaHost == null || DEFAULT_ASSEMBLA_URL.equals(assemblaHost) ? DEFAULT_API_ENDPOINT : assemblaHost;
        return this.mergeUrl(endpoint, "/v1/");
    }

    private String mergeUrl(String baseUrl, String relativeUrl) {
        try {
            return new URL(new URL(baseUrl), relativeUrl).toString();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public static class ForbiddenError
    extends AssemblaApiException {
    }

    public static class UnauthorizedError
    extends AssemblaApiException {
    }

    public static class NotFoundError
    extends AssemblaApiException {
        private String requestUrl;
        private String response;

        public NotFoundError(String requestUrl, String response) {
            this.requestUrl = requestUrl;
            this.response = response;
        }

        @Override
        public String toString() {
            return "NotFoundError{requestUrl='" + this.requestUrl + '\'' + ", response='" + this.response + '\'' + '}';
        }
    }

    public static class AssemblaApiException
    extends RuntimeException {
    }
}

