/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.assembla;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.EnvironmentContributor;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SafeParametersAction
extends ParametersAction {
    private List<ParameterValue> parameters;

    public SafeParametersAction(List<ParameterValue> parameters) {
        super(new ParameterValue[0]);
        this.parameters = parameters;
    }

    public SafeParametersAction(ParameterValue ... parameters) {
        this(Arrays.asList(parameters));
    }

    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue parameter : this.parameters) {
            if (parameter == null || !parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    @Extension
    public static final class SafeParametersActionEnvironmentContributor
    extends EnvironmentContributor {
        public void buildEnvironmentFor(Run r, EnvVars envs, TaskListener listener) throws IOException, InterruptedException {
            SafeParametersAction action = (SafeParametersAction)r.getAction(SafeParametersAction.class);
            if (action != null) {
                for (ParameterValue p : action.getParameters()) {
                    envs.putIfNotNull(p.getName(), String.valueOf(p.getValue()));
                }
            }
        }
    }
}

