/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.hudson.util;

import com.google.common.collect.Sets;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import hudson.plugins.jira.selector.DefaultIssueSelector;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.jfrog.build.api.IssueTracker;
import org.jfrog.build.api.Issues;
import org.jfrog.build.api.builder.BuildInfoBuilder;
import org.jfrog.build.extractor.clientConfiguration.ArtifactoryClientConfiguration;
import org.jfrog.build.extractor.clientConfiguration.util.IssuesTrackerUtils;
import org.jfrog.hudson.util.plugins.PluginsUtils;

public class IssuesTrackerHelper {
    private String issueTrackerVersion;
    private boolean aggregateBuildIssues;
    private String aggregationBuildStatus;
    private String affectedIssues;
    private String deploymentProperties;

    public IssuesTrackerHelper(Run build, TaskListener listener, boolean aggregateBuildIssues, String aggregationBuildStatus) {
        this.aggregateBuildIssues = aggregateBuildIssues;
        this.aggregationBuildStatus = aggregationBuildStatus;
        JiraSite site = JiraSite.get((Job)build.getParent());
        if (site == null) {
            return;
        }
        try {
            this.issueTrackerVersion = this.getJiraVersion(site);
            StringBuilder affectedIssuesBuilder = new StringBuilder();
            StringBuilder deploymentPropertiesBuilder = new StringBuilder();
            HashSet issueIds = Sets.newHashSet(this.manuallyCollectIssues(build, site, listener));
            for (String issueId : issueIds) {
                if (!site.existsIssue(issueId)) continue;
                if (affectedIssuesBuilder.length() > 0) {
                    affectedIssuesBuilder.append(",");
                    deploymentPropertiesBuilder.append(",");
                }
                URL url = site.getUrl(issueId);
                JiraIssue issue = site.getIssue(issueId);
                affectedIssuesBuilder.append(issueId).append(">>").append(url.toString()).append(">>").append(issue.getSummary());
                deploymentPropertiesBuilder.append(issueId);
            }
            this.affectedIssues = affectedIssuesBuilder.toString();
            this.deploymentProperties = deploymentPropertiesBuilder.toString();
        }
        catch (Exception e) {
            listener.getLogger().print("[Warning] Error while trying to collect issue tracker and change information: " + e.getMessage());
        }
    }

    private String getJiraVersion(JiraSite site) {
        return PluginsUtils.getJiraVersion(site.url);
    }

    private Set<String> manuallyCollectIssues(Run build, JiraSite site, TaskListener listener) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        DefaultIssueSelector issueSelector = new DefaultIssueSelector();
        return issueSelector.findIssueIds(build, site, listener);
    }

    public void setIssueTrackerInfo(ArtifactoryClientConfiguration configuration) {
        configuration.info.issues.setIssueTrackerName("JIRA");
        configuration.info.issues.setIssueTrackerVersion(this.issueTrackerVersion);
        configuration.info.issues.setAggregateBuildIssues(this.aggregateBuildIssues);
        if (this.aggregateBuildIssues) {
            configuration.info.issues.setAggregationBuildStatus(this.aggregationBuildStatus);
        } else {
            configuration.info.issues.setAggregationBuildStatus("");
        }
        configuration.info.issues.setAffectedIssues(this.affectedIssues);
        configuration.publisher.addMatrixParam("affectedIssues", this.deploymentProperties);
    }

    public void setIssueTrackerInfo(BuildInfoBuilder builder) {
        Issues issues = new Issues();
        issues.setAggregateBuildIssues(this.aggregateBuildIssues);
        issues.setAggregationBuildStatus(this.aggregationBuildStatus);
        issues.setTracker(new IssueTracker("JIRA", this.issueTrackerVersion));
        Set affectedIssuesSet = IssuesTrackerUtils.getAffectedIssuesSet((String)this.affectedIssues);
        if (!affectedIssuesSet.isEmpty()) {
            issues.setAffectedIssues(affectedIssuesSet);
        }
        builder.issues(issues);
    }
}

